/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.project.BrokenIncludes;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ToolsCacheManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.ui.MakeProjectCustomizerEx;
import org.netbeans.modules.cnd.makeproject.ui.AnnotatedNode;
import org.netbeans.modules.cnd.makeproject.ui.LogicalViewChildren;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.ProjectTabBridge;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemNode;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemPasteType;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;

final class MakeLogicalViewRootNode
extends AnnotatedNode
implements ChangeListener,
LookupListener,
PropertyChangeListener {
    private boolean brokenIncludes;
    private boolean brokenProject;
    private Folder folder;
    private final Lookup.Result<BrokenIncludes> brokenIncludesResult;
    private final MakeLogicalViewProvider provider;
    private final InstanceContent ic;
    private final RequestProcessor.Task stateChangedTask;
    private static final int WAIT_DELAY = 500;
    private boolean confProviderListenerAttached = false;

    public MakeLogicalViewRootNode(Folder folder, MakeLogicalViewProvider provider, InstanceContent ic) {
        this(new ProjectRootChildren(folder, provider), folder, provider, ic);
    }

    private MakeLogicalViewRootNode(ProjectRootChildren children, Folder folder, MakeLogicalViewProvider provider, InstanceContent ic) {
        super((Children)children, (Lookup)new AbstractLookup((AbstractLookup.Content)ic), provider.getAnnotationRP());
        children.setMakeLogicalViewRootNode(this);
        this.ic = ic;
        this.folder = folder;
        this.provider = provider;
        this.setIconBaseWithExtension("org/netbeans/modules/cnd/makeproject/resources/makeProject.gif");
        this.setName(ProjectUtils.getInformation((Project)provider.getProject()).getDisplayName());
        this.brokenIncludesResult = Lookup.getDefault().lookup(new Lookup.Template(BrokenIncludes.class));
        this.brokenIncludesResult.addLookupListener((LookupListener)this);
        this.resultChanged(null);
        this.brokenIncludes = this.hasBrokenIncludes((Project)provider.getProject());
        this.setForceAnnotation(true);
        if (folder != null) {
            this.updateAnnotationFiles();
        }
        ProjectInformation pi = (ProjectInformation)provider.getProject().getLookup().lookup(ProjectInformation.class);
        pi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)pi));
        ToolsCacheManager.addChangeListener((ChangeListener)WeakListeners.change((ChangeListener)this, null));
        ProjectConfigurationProvider confProvider = (ProjectConfigurationProvider)provider.getProject().getLookup().lookup(ProjectConfigurationProvider.class);
        if (confProvider != null) {
            confProvider.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)confProvider));
            this.confProviderListenerAttached = true;
        }
        this.stateChangedTask = provider.getAnnotationRP().create((Runnable)new StateChangeRunnableImpl(), true);
    }

    public String getHtmlDisplayName() {
        String ret = this.getHtmlDisplayName2();
        ExecutionEnvironment env = this.provider.getProject().getFileSystemHost();
        if (env != null && env.isRemote()) {
            if (ret == null) {
                ret = this.getName();
            }
            ret = ret + " <font color=\"!textInactiveText\">[" + env.getDisplayName() + "]";
        }
        return ret;
    }

    private String getHtmlDisplayName2() {
        String ret = super.getHtmlDisplayName();
        if (this.brokenProject) {
            try {
                ret = XMLUtil.toElementContent((String)ret);
            }
            catch (CharConversionException ex) {
                return ret;
            }
            return "<font color=\"#" + Integer.toHexString(MakeLogicalViewRootNode.getErrorForeground().getRGB() & 0xFFFFFF) + "\">" + ret + "</font>";
        }
        return ret;
    }

    private static Color getErrorForeground() {
        Color result = UIManager.getDefaults().getColor("nb.errorForeground");
        if (result == null) {
            result = Color.RED;
        }
        return result;
    }

    public void reInit(MakeConfigurationDescriptor configurationDescriptor) {
        ProjectConfigurationProvider confProvider;
        Folder logicalFolders = configurationDescriptor.getLogicalFolders();
        if (this.folder != null) {
            this.ic.remove((Object)this.folder);
        }
        this.folder = logicalFolders;
        this.ic.add((Object)logicalFolders);
        this.setChildren((Children)new LogicalViewChildren(this.folder, this.provider));
        if (!this.confProviderListenerAttached && (confProvider = (ProjectConfigurationProvider)this.provider.getProject().getLookup().lookup(ProjectConfigurationProvider.class)) != null) {
            confProvider.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)confProvider));
            this.confProviderListenerAttached = true;
        }
        this.stateChanged(null);
    }

    void reInitWithRemovedPrivate() {
        MakeConfigurationDescriptor mcd = this.provider.getMakeConfigurationDescriptor();
        Configuration[] confs = mcd.getConfs().toArray();
        for (int i = 0; i < confs.length; ++i) {
            int platform2;
            int platform1;
            MakeConfiguration conf = (MakeConfiguration)confs[i];
            if (!conf.getDevelopmentHost().isLocalhost() || (platform1 = CompilerSetManager.get((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).getPlatform()) == (platform2 = conf.getDevelopmentHost().getBuildPlatformConfiguration().getValue())) continue;
            conf.getDevelopmentHost().getBuildPlatformConfiguration().setValue(platform1);
        }
        this.reInit(this.provider.getMakeConfigurationDescriptor());
    }

    void reInitWithUnsupportedVersion() {
        this.reInit(this.provider.getMakeConfigurationDescriptor());
    }

    private void setRealProjectFolder(Folder folder) {
        assert (folder != null);
        if (this.folder != null) {
            this.ic.remove((Object)this.folder);
        }
        this.folder = folder;
        this.ic.add((Object)folder);
        this.stateChanged(null);
        Runnable runnable = () -> {
            try {
                Node[] selectedNodes = ProjectTabBridge.getInstance().getExplorerManager().getSelectedNodes();
                ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(new Node[0]);
                ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(selectedNodes);
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    private Project getProject() {
        return this.provider.getProject();
    }

    private boolean gotMakeConfigurationDescriptor() {
        return this.provider.gotMakeConfigurationDescriptor();
    }

    MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        return this.provider.getMakeConfigurationDescriptor();
    }

    private void updateAnnotationFiles() {
        FileObject fo = this.getProject().getProjectDirectory();
        if (fo == null || !fo.isValid()) {
            Logger.getLogger("cnd.makeproject").log(Level.WARNING, "project.getProjectDirectory() == null - {0}", this.getProject());
        }
        if (!this.gotMakeConfigurationDescriptor()) {
            return;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return;
        }
        Configurations confs = makeConfigurationDescriptor.getConfs();
        if (confs == null) {
            return;
        }
        LinkedHashSet<FileObject> set = new LinkedHashSet<FileObject>();
        for (Configuration conf : confs.toArray()) {
            MakefileConfiguration makefileConfiguration;
            FileObject buildCommandFO;
            MakeConfiguration makeConfiguration = (MakeConfiguration)conf;
            if (!makeConfiguration.isMakefileConfiguration() || (buildCommandFO = (makefileConfiguration = makeConfiguration.getMakefileConfiguration()).getAbsBuildCommandFileObject()) == null || !buildCommandFO.isValid()) continue;
            try {
                FileObject fileObject = CndFileUtils.getCanonicalFileObject((FileObject)buildCommandFO);
                if (fileObject == null || !fileObject.isValid()) continue;
                set.add(fileObject);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
        }
        set.add(this.getProject().getProjectDirectory());
        this.setFiles(set);
        Folder aFolder = this.folder;
        if (aFolder != null) {
            ArrayList<Folder> allFolders = new ArrayList<Folder>();
            allFolders.add(aFolder);
            allFolders.addAll(aFolder.getAllFolders(true));
            Iterator iter = allFolders.iterator();
            while (iter.hasNext()) {
                ((Folder)iter.next()).addChangeListener((ChangeListener)this);
            }
        }
    }

    public String getShortDescription() {
        return MakeLogicalViewProvider.getShortDescription(this.provider.getProject());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setName(ProjectUtils.getInformation((Project)this.provider.getProject()).getDisplayName());
        String prop = evt.getPropertyName();
        if ("displayName".equals(prop)) {
            this.fireDisplayNameChange(null, null);
        } else if ("name".equals(prop)) {
            this.fireNameChange(null, null);
        } else if ("icon".equals(prop)) {
            this.fireIconChange();
        } else if ("loadedConfigurations".equals(prop)) {
            this.reInit(this.getMakeConfigurationDescriptor());
        } else if ("configurations".equals(prop)) {
            this.stateChanged(null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.stateChangedTask != null) {
            this.stateChangedTask.schedule(500);
        }
    }

    public Object getValue(String valstring) {
        if (valstring == null) {
            return super.getValue(null);
        }
        if (valstring.equals("Folder")) {
            return this.folder;
        }
        if (valstring.equals("Project")) {
            return this.getProject();
        }
        if (valstring.equals("This")) {
            return this;
        }
        return super.getValue(valstring);
    }

    public Image getIcon(int type) {
        ProjectInformation pi = (ProjectInformation)this.provider.getProject().getLookup().lookup(ProjectInformation.class);
        return this.mergeBadge(this.annotateIcon(ImageUtilities.icon2Image((Icon)pi.getIcon()), type));
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    private Image mergeBadge(Image original) {
        ProjectProblemsProvider pp = (ProjectProblemsProvider)this.getProject().getLookup().lookup(ProjectProblemsProvider.class);
        if (this.brokenProject) {
            return ImageUtilities.mergeImages((Image)original, (Image)MakeLogicalViewProvider.brokenProjectBadge, (int)8, (int)0);
        }
        if (pp.getProblems().size() > 0) {
            return ImageUtilities.mergeImages((Image)original, (Image)MakeLogicalViewProvider.brokenProjectBadge, (int)8, (int)0);
        }
        if (this.brokenIncludes) {
            return ImageUtilities.mergeImages((Image)original, (Image)MakeLogicalViewProvider.brokenIncludeBadge, (int)8, (int)0);
        }
        return original;
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!this.gotMakeConfigurationDescriptor()) {
            actions.add(CommonProjectActions.closeProjectAction());
            return actions.toArray(new Action[actions.size()]);
        }
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            descriptor.getLogicalFolders();
        }
        MakeConfiguration active = descriptor == null ? null : descriptor.getActiveConfiguration();
        String projectType = "org-netbeans-modules-cnd-makeproject";
        Action[] projectActions = null;
        if (active != null && active.isCustomConfiguration()) {
            projectActions = ((MakeProjectCustomizerEx)active.getProjectCustomizer()).getActions(this.getProject(), Arrays.asList(CommonProjectActions.forType((String)projectType)));
            projectType = active.getProjectCustomizer().getCustomizerId();
        }
        Action[] actionArray = projectActions = projectActions == null ? CommonProjectActions.forType((String)projectType) : projectActions;
        if (this.brokenProject) {
            actions.add(CommonProjectActions.closeProjectAction());
            Action resolveAction = Actions.forID((String)"Project", (String)"org.netbeans.modules.project.ui.problems.BrokenProjectActionFactory");
            for (Action action : projectActions) {
                if (action != resolveAction) continue;
                actions.add(action);
            }
            return actions.toArray(new Action[actions.size()]);
        }
        actions.addAll(Arrays.asList(projectActions));
        actions.add(null);
        return actions.toArray(new Action[actions.size()]);
    }

    public boolean canRename() {
        return false;
    }

    public PasteType getDropType(Transferable transferable, int action, int index) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].getSubType().equals("x-org-netbeans-modules-cnd-makeproject-uidnd")) continue;
            return super.getDropType(transferable, action, index);
        }
        return null;
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].getSubType().equals("x-org-netbeans-modules-cnd-makeproject-uidnd")) continue;
            try {
                ViewItemNode viewItemNode = (ViewItemNode)transferable.getTransferData(flavors[i]);
                int type = Integer.parseInt(flavors[i].getParameter("mask"));
                list.add(new ViewItemPasteType(this.getFolder(), viewItemNode, type, this.provider));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.createPasteTypes(transferable, list);
    }

    public void resultChanged(LookupEvent ev) {
        this.brokenIncludesResult.allInstances().forEach(elem -> elem.addChangeListener((ChangeListener)this));
    }

    private boolean hasBrokenIncludes(Project project) {
        NativeProject id;
        BrokenIncludes biProvider = (BrokenIncludes)Lookup.getDefault().lookup(BrokenIncludes.class);
        if (biProvider != null && (id = (NativeProject)project.getLookup().lookup(NativeProject.class)) != null) {
            return biProvider.isBroken(id);
        }
        return false;
    }

    private final class StateChangeRunnableImpl
    implements Runnable {
        private StateChangeRunnableImpl() {
        }

        @Override
        public void run() {
            MakeConfigurationDescriptor makeConfigurationDescriptor;
            MakeLogicalViewRootNode.this.brokenIncludes = MakeLogicalViewRootNode.this.hasBrokenIncludes(MakeLogicalViewRootNode.this.getProject());
            if (MakeLogicalViewRootNode.this.provider.gotMakeConfigurationDescriptor() && (makeConfigurationDescriptor = MakeLogicalViewRootNode.this.provider.getMakeConfigurationDescriptor()) != null) {
                MakeLogicalViewRootNode.this.brokenProject = makeConfigurationDescriptor.getState() == ConfigurationDescriptor.State.BROKEN;
                if (makeConfigurationDescriptor.getConfs().size() == 0) {
                    MakeLogicalViewRootNode.this.brokenProject = true;
                }
                if (MakeLogicalViewRootNode.this.provider.isIncorectVersion()) {
                    MakeLogicalViewRootNode.this.brokenProject = true;
                }
            }
            MakeLogicalViewRootNode.this.updateAnnotationFiles();
            EventQueue.invokeLater(new VisualUpdater());
        }
    }

    private static final class ProjectRootChildren
    extends LogicalViewChildren {
        private MakeLogicalViewRootNode parent;

        private ProjectRootChildren(Folder folder, MakeLogicalViewProvider provider) {
            super(folder, provider);
        }

        @Override
        protected void onFolderChange(Folder folder) {
            assert (this.parent != null);
            this.parent.setRealProjectFolder(folder);
        }

        private void setMakeLogicalViewRootNode(MakeLogicalViewRootNode parent) {
            assert (this.parent == null);
            this.parent = parent;
        }

        @Override
        protected boolean isRoot() {
            return true;
        }
    }

    private final class VisualUpdater
    implements Runnable {
        private VisualUpdater() {
        }

        @Override
        public void run() {
            if (MakeLogicalViewRootNode.this.brokenProject) {
                MakeLogicalViewRootNode.this.setChildren(Children.LEAF);
            }
            MakeLogicalViewRootNode.this.fireIconChange();
            MakeLogicalViewRootNode.this.fireOpenedIconChange();
            MakeLogicalViewRootNode.this.fireDisplayNameChange(null, null);
        }
    }
}

