/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.spi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.remote.impl.fileoperations.spi.AnnotationProvider;
import org.netbeans.modules.remote.impl.fileoperations.spi.FileOperationsProvider;
import org.netbeans.modules.remote.impl.fileoperations.spi.FilesystemInterceptorProvider;
import org.netbeans.modules.remotefs.versioning.spi.VersioningAnnotationProviderImpl;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.filesystems.VCSFilesystemInterceptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;

public class FilesystemInterceptorProviderImpl
extends FilesystemInterceptorProvider {
    private final Map<FileSystem, FilesystemInterceptorProvider.FilesystemInterceptor> map = new HashMap<FileSystem, FilesystemInterceptorProvider.FilesystemInterceptor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FilesystemInterceptorProvider.FilesystemInterceptor getFilesystemInterceptor(FileSystem fs) {
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
        Map<FileSystem, FilesystemInterceptorProvider.FilesystemInterceptor> map = this.map;
        synchronized (map) {
            interceptor = this.map.get(fs);
            if (interceptor == null) {
                interceptor = new FilesystemInterceptorImpl(fs);
                this.map.put(fs, interceptor);
            }
        }
        return interceptor;
    }

    public static VCSFileProxy toVCSFileProxy(FileObject file) {
        return VCSFileProxy.createFileProxy((FileObject)file);
    }

    public static VCSFileProxy toVCSFileProxy(FilesystemInterceptorProvider.FileProxyI proxy) {
        VCSFileProxy res;
        FileSystem fileSystem = proxy.getFileSystem();
        FileOperationsProvider.FileOperations fileOperations = (FileOperationsProvider.FileOperations)fileSystem.getRoot().getAttribute("FileProxyOperations");
        if (fileOperations != null) {
            res = VCSFileProxy.createFileProxy((FileObject)fileSystem.getRoot());
            String[] split = proxy.getPath().split("/");
            for (int i = 0; i < split.length; ++i) {
                if (split[i].isEmpty() || ".".equals(split[i])) continue;
                res = VCSFileProxy.createFileProxy((VCSFileProxy)res, (String)split[i]);
            }
        } else {
            res = VCSFileProxy.createFileProxy((File)new File(proxy.getPath()));
        }
        return res;
    }

    private static final class FilesystemInterceptorImpl
    implements FilesystemInterceptorProvider.FilesystemInterceptor,
    FileChangeListener,
    VCSFilesystemInterceptor.VCSAnnotationListener {
        private final FileSystem fs;

        public FilesystemInterceptorImpl(FileSystem fs) {
            this.fs = fs;
            VCSFilesystemInterceptor.registerFileStatusListener((VCSFilesystemInterceptor.VCSAnnotationListener)this);
            fs.addFileChangeListener((FileChangeListener)this);
        }

        public void annotationChanged(VCSFilesystemInterceptor.VCSAnnotationEvent ev) {
            ((VersioningAnnotationProviderImpl)AnnotationProvider.getDefault()).deliverStatusEvent(this.fs, ev);
        }

        public boolean canWriteReadonlyFile(FilesystemInterceptorProvider.FileProxyI file) {
            return VCSFilesystemInterceptor.canWriteReadonlyFile((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(file));
        }

        public Object getAttribute(FilesystemInterceptorProvider.FileProxyI file, String attrName) {
            return VCSFilesystemInterceptor.getAttribute((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(file), (String)attrName);
        }

        public void beforeChange(FilesystemInterceptorProvider.FileProxyI file) {
            VCSFilesystemInterceptor.beforeChange((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(file));
        }

        public void fileChanged(FilesystemInterceptorProvider.FileProxyI file) {
            VCSFilesystemInterceptor.fileChanged((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(file));
        }

        public void fileChanged(FileEvent fe) {
            VCSFilesystemInterceptor.fileChanged((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(fe.getFile()));
        }

        public FilesystemInterceptorProvider.IOHandler getDeleteHandler(FilesystemInterceptorProvider.FileProxyI file) {
            final VCSFilesystemInterceptor.IOHandler deleteHandler = VCSFilesystemInterceptor.getDeleteHandler((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(file));
            if (deleteHandler != null) {
                return new FilesystemInterceptorProvider.IOHandler(){

                    public void handle() throws IOException {
                        deleteHandler.handle();
                    }
                };
            }
            return null;
        }

        public void deleteSuccess(FilesystemInterceptorProvider.FileProxyI file) {
            VCSFilesystemInterceptor.deleteSuccess((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(file));
        }

        public void deletedExternally(FilesystemInterceptorProvider.FileProxyI file) {
            VCSFilesystemInterceptor.deletedExternally((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(file));
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void beforeCreate(FilesystemInterceptorProvider.FileProxyI parent, String name, boolean isFolder) {
            VCSFilesystemInterceptor.beforeCreate((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(parent), (String)name, (boolean)isFolder);
        }

        public void createFailure(FilesystemInterceptorProvider.FileProxyI parent, String name, boolean isFolder) {
            VCSFilesystemInterceptor.createFailure((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(parent), (String)name, (boolean)isFolder);
        }

        public void createSuccess(FilesystemInterceptorProvider.FileProxyI fo) {
            VCSFilesystemInterceptor.createSuccess((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(fo));
        }

        public void createdExternally(FilesystemInterceptorProvider.FileProxyI fo) {
            VCSFilesystemInterceptor.createdExternally((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(fo));
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public FilesystemInterceptorProvider.IOHandler getMoveHandler(FilesystemInterceptorProvider.FileProxyI from, FilesystemInterceptorProvider.FileProxyI to) {
            final VCSFilesystemInterceptor.IOHandler moveHandler = VCSFilesystemInterceptor.getMoveHandler((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(from), (VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(to));
            if (moveHandler != null) {
                return new FilesystemInterceptorProvider.IOHandler(){

                    public void handle() throws IOException {
                        moveHandler.handle();
                    }
                };
            }
            return null;
        }

        public FilesystemInterceptorProvider.IOHandler getRenameHandler(FilesystemInterceptorProvider.FileProxyI from, String newName) {
            final VCSFilesystemInterceptor.IOHandler renameHandler = VCSFilesystemInterceptor.getRenameHandler((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(from), (String)newName);
            if (renameHandler != null) {
                return new FilesystemInterceptorProvider.IOHandler(){

                    public void handle() throws IOException {
                        renameHandler.handle();
                    }
                };
            }
            return null;
        }

        public void fileRenamed(FileRenameEvent fe) {
            String name = fe.getName();
            String ext = fe.getExt();
            if (ext != null && !ext.isEmpty()) {
                name = name + "." + ext;
            }
            VCSFilesystemInterceptor.afterMove((VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fe.getFile()).getParentFile(), (String)name), (VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(fe.getFile()));
        }

        public void afterMove(FilesystemInterceptorProvider.FileProxyI from, FilesystemInterceptorProvider.FileProxyI to) {
            VCSFilesystemInterceptor.afterMove((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(from), (VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(to));
        }

        public FilesystemInterceptorProvider.IOHandler getCopyHandler(FilesystemInterceptorProvider.FileProxyI from, FilesystemInterceptorProvider.FileProxyI to) {
            final VCSFilesystemInterceptor.IOHandler copyHandler = VCSFilesystemInterceptor.getCopyHandler((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(from), (VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(to));
            if (copyHandler != null) {
                return new FilesystemInterceptorProvider.IOHandler(){

                    public void handle() throws IOException {
                        copyHandler.handle();
                    }
                };
            }
            return null;
        }

        public void beforeCopy(FilesystemInterceptorProvider.FileProxyI from, FilesystemInterceptorProvider.FileProxyI to) {
            VCSFilesystemInterceptor.beforeCopy((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(from), (VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(to));
        }

        public void copySuccess(FilesystemInterceptorProvider.FileProxyI from, FilesystemInterceptorProvider.FileProxyI to) {
            VCSFilesystemInterceptor.copySuccess((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(from), (VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(to));
        }

        public void fileLocked(FilesystemInterceptorProvider.FileProxyI fo) throws IOException {
            VCSFilesystemInterceptor.fileLocked((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(fo));
        }

        public long refreshRecursively(FilesystemInterceptorProvider.FileProxyI dir, long lastTimeStamp, List<? super FilesystemInterceptorProvider.FileProxyI> children) {
            ArrayList<VCSFileProxy> res = new ArrayList<VCSFileProxy>();
            for (FilesystemInterceptorProvider.FileProxyI fileProxyI : children) {
                res.add(FilesystemInterceptorProviderImpl.toVCSFileProxy(fileProxyI));
            }
            return VCSFilesystemInterceptor.listFiles((VCSFileProxy)FilesystemInterceptorProviderImpl.toVCSFileProxy(dir), (long)lastTimeStamp, res);
        }

        public String toString() {
            return this.fs.getDisplayName();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

