/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticOptions;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.LangOptions;
import org.clang.basic.PresumedLoc;
import org.clang.basic.spi.PreprocessorImplementation;
import org.clang.frontend.TextDiagnosticPrinter;
import org.clang.tools.services.support.ClangUtilities;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class DefaultDiagnosticConsumer
extends TextDiagnosticPrinter {
    private boolean insideSourceFile = false;
    private final raw_ostream out;
    private final boolean null_stream;

    public DefaultDiagnosticConsumer(raw_ostream os, DiagnosticOptions diags) {
        super(os, diags, false);
        assert (os != null);
        this.out = os;
        this.null_stream = os == llvm.nulls();
    }

    public void BeginSourceFile(LangOptions LangOpts, PreprocessorImplementation PP) {
        super.BeginSourceFile(LangOpts, PP);
        this.insideSourceFile = true;
    }

    public void EndSourceFile() {
        this.insideSourceFile = false;
        super.EndSourceFile();
    }

    public void HandleDiagnostic(DiagnosticsEngine.Level DiagLevel, Diagnostic Info) {
        PresumedLoc presumedLoc;
        if (this.null_stream) {
            return;
        }
        if (this.insideSourceFile) {
            super.HandleDiagnostic(DiagLevel, Info);
            return;
        }
        SmallString out = new SmallString(1024);
        Info.FormatDiagnostic(out);
        String Loc = "";
        if (Info.hasSourceManager() && (presumedLoc = Info.getSourceManager().getPresumedLoc(Info.getLocation())).isValid()) {
            Loc = "In file " + Native.$toString((char.ptr)presumedLoc.getFilename()) + " line " + presumedLoc.getLine() + ", col " + presumedLoc.getColumn() + "\n";
        }
        Level level = ClangUtilities.toLoggerLevel(DiagLevel);
        String msg = new std.string(out.data()).toJavaString();
        if (DiagLevel.getValue() >= DiagnosticsEngine.Level.Error.getValue()) {
            // empty if block
        }
        Logger.getLogger(DefaultDiagnosticConsumer.class.getName()).log(level, "{2}{0}:{1}\n", new Object[]{DiagLevel, msg, Loc});
    }
}

