/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptions;
import org.netbeans.modules.cnd.repository.disk.FilesAccessStrategyImpl;
import org.netbeans.modules.cnd.repository.disk.LayerIndex;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.impl.spi.LayeringSupport;
import org.netbeans.modules.cnd.repository.impl.spi.ReadLayerCapability;
import org.netbeans.modules.cnd.repository.impl.spi.UnitDescriptorsList;
import org.netbeans.modules.cnd.repository.impl.spi.WriteLayerCapability;
import org.openide.filesystems.FileSystem;

public final class DiskLayerImpl {
    private final FilesAccessStrategyImpl fas;
    private final LayerDescriptor layerDescriptor;
    private final LayerIndex layerIndex;

    public DiskLayerImpl(LayerDescriptor layerDescriptor, LayeringSupport layeringSupport) {
        this.layerDescriptor = layerDescriptor;
        URI cacheDirectory = layerDescriptor.getURI();
        this.layerIndex = new LayerIndex(cacheDirectory);
        this.fas = new FilesAccessStrategyImpl(this.layerIndex, cacheDirectory, layerDescriptor, layeringSupport);
    }

    public Collection<LayerKey> removedTableKeySet() {
        return this.fas.removedTableKeySet();
    }

    public boolean startup(int persistMechanismVersion, boolean recreate, boolean isWritable) {
        return this.layerIndex.load(persistMechanismVersion, recreate, isWritable);
    }

    public LayerDescriptor getLayerDescriptor() {
        return this.layerDescriptor;
    }

    public void shutdown() {
        this.fas.shutdown(this.layerDescriptor.isWritable());
    }

    public void openUnit(int unitIdx) {
    }

    public void closeUnit(int unitIdx, boolean cleanRepository, Set<Integer> requiredUnits) {
        throw new InternalError();
    }

    void closeUnit(int unitIdInLayer, boolean cleanRepository, Set<Integer> requiredUnits, boolean isWritable) {
        this.layerIndex.closeUnit(unitIdInLayer, cleanRepository, requiredUnits);
        this.fas.closeUnit(unitIdInLayer, cleanRepository);
    }

    public UnitDescriptorsList getUnitsTable() {
        return this.layerIndex.getUnitsTable();
    }

    public List<FileSystem> getFileSystemsTable() {
        return this.layerIndex.getFileSystemsTable();
    }

    public ReadLayerCapability getReadCapability() {
        return this.fas;
    }

    public WriteLayerCapability getWriteCapability() {
        return this.fas;
    }

    public int findMatchedFileSystemIndexInLayer(FileSystem clientFileSystem) {
        return this.layerIndex.getFileSystemsTable().indexOf(clientFileSystem);
    }

    public void storeIndex() {
        try {
            this.layerIndex.store();
        }
        catch (IOException ex) {
            RepositoryExceptions.throwException((Object)this, (Throwable)ex);
        }
    }
}

