/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.testbench;

import java.io.PrintStream;
import java.util.Map;
import org.netbeans.modules.cnd.repository.testbench.BaseStatistics;

public class RangeStatistics
extends BaseStatistics<Integer> {
    protected int rangeCount;
    private Range[] ranges;

    public RangeStatistics(String text, int level) {
        this(text, level, 10);
    }

    public RangeStatistics(String text, int level, int rangeCount) {
        super(text, level);
        this.rangeCount = rangeCount;
    }

    public void consume(int value) {
        this.consume(value, value);
    }

    @Override
    public void print(PrintStream ps) {
        int avg = this.cnt == 0 ? 0 : this.sum / this.cnt;
        ps.printf("%s %8d min    %8d max    %8d avg    %8d cnt    %8d sum\n", this.text, this.min, this.max, avg, this.cnt, this.sum);
        if (this.values != null) {
            this.printDistribution(ps);
        }
    }

    @Override
    protected void printDistribution(PrintStream ps) {
        ps.printf("\tDistribution:\n", new Object[0]);
        if (this.level > 2 || this.values.size() <= this.rangeCount) {
            this.printDistributionDetailed(ps);
        } else {
            this.printDistributionGrouped(ps);
        }
    }

    private void createRanges() {
        int[] valuesArray = new int[this.values.size()];
        int pos = 0;
        for (Map.Entry entry : this.values.entrySet()) {
            valuesArray[pos++] = (Integer)entry.getKey();
        }
        this.ranges = new Range[this.rangeCount];
        int rangeSize = this.values.size() / this.rangeCount + (this.values.size() % this.rangeCount == 0 ? 0 : 1);
        for (int i = 0; i < this.ranges.length; ++i) {
            int from = Math.min(rangeSize * i, valuesArray.length - 1);
            int to = Math.min(from + rangeSize - 1, valuesArray.length - 1);
            try {
                this.ranges[i] = new Range(valuesArray[from], valuesArray[to]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.printf("i=%d from=%d to=%d valuesArray.length=%d\n", i, from, to, valuesArray.length);
                e.printStackTrace(System.err);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private Range getRange(int value) {
        if (this.ranges == null) {
            this.createRanges();
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            if (this.ranges[i].from > value || value > this.ranges[i].to) continue;
            return this.ranges[i];
        }
        throw new IllegalArgumentException("Value " + value + " are out of range " + this.min + '-' + this.max);
    }

    private void printDistributionGrouped(PrintStream ps) {
        for (Map.Entry entry : this.values.entrySet()) {
            Range range = this.getRange((Integer)entry.getKey());
            range.cnt += ((Integer)entry.getValue()).intValue();
        }
        int maxFrom = 0;
        int maxTo = 0;
        int maxCnt = 0;
        for (int i = 0; i < this.ranges.length; ++i) {
            maxFrom = Math.max(maxCnt, this.ranges[i].from);
            maxTo = Math.max(maxCnt, this.ranges[i].to);
            maxCnt = Math.max(maxCnt, this.ranges[i].cnt);
        }
        maxFrom = (int)Math.log10(maxFrom) + 1;
        maxTo = (int)Math.log10(maxTo) + 1;
        maxCnt = (int)Math.log10(maxCnt) + 1;
        StringBuilder format = new StringBuilder("\t%");
        format.append(maxFrom);
        format.append("d - %");
        format.append(maxTo);
        format.append("d   %");
        format.append(maxCnt);
        format.append("d   %2d%%\n");
        for (int i = 0; i < this.ranges.length; ++i) {
            if (this.ranges[i].cnt <= 0) continue;
            int percent = this.ranges[i].cnt * 100 / this.cnt;
            ps.printf(format.toString(), this.ranges[i].from, this.ranges[i].to, this.ranges[i].cnt, percent);
        }
    }

    private static class Range {
        public int from;
        public int to;
        public int cnt;

        public Range(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.from);
            sb.append('-');
            sb.append(this.to);
            sb.append(": ");
            sb.append(this.cnt);
            return sb.toString();
        }
    }
}

