/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.SecurityTableModel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.Util;
import org.openide.util.NbBundle;

public class PropertiesTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Name"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Value")};
    private static final String attrName = "Name";
    private static final String hibernate_prefix = "hibernate.";
    private SessionFactory sessionFactory;
    private String propCategory;
    private ArrayList<PropertyData> propsData;

    public PropertiesTableModel(SessionFactory sessionFactory, String propCat) {
        this.sessionFactory = sessionFactory;
        this.propCategory = propCat;
        this.getPropsData();
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.sessionFactory == null) {
            return null;
        }
        if (column == 0) {
            return this.propsData.get(row).getPropName();
        }
        return this.propsData.get(row).getPropValue();
    }

    @Override
    public int getRowCount() {
        if (this.sessionFactory == null) {
            return 0;
        }
        return this.propsData.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void addRow(String propName, String propValue) {
        int index = this.sessionFactory.addProperty2(propValue);
        this.sessionFactory.setAttributeValue("Property2", index, attrName, propName);
        this.propsData.add(new PropertyData(index, propName, propValue));
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void editRow(int row, String propValue) {
        PropertyData data = this.propsData.get(row);
        this.sessionFactory.setProperty2(data.getModelIndex(), propValue);
        data.setPropValue(propValue);
        this.fireTableRowsUpdated(row, row);
    }

    public void removeRow(int row) {
        this.sessionFactory.removeValue("Property2", this.propsData.get(row).getModelIndex());
        this.getPropsData();
        this.fireTableRowsDeleted(row, row);
    }

    private void getPropsData() {
        this.propsData = new ArrayList();
        List<String> allPropsOfThisCat = Arrays.asList(Util.getAllPropNames(this.propCategory));
        if (this.sessionFactory != null) {
            for (int i = 0; i < this.sessionFactory.sizeProperty2(); ++i) {
                String propName = this.sessionFactory.getAttributeValue("Property2", i, attrName);
                if (!allPropsOfThisCat.contains(propName) && !allPropsOfThisCat.contains(hibernate_prefix + propName)) continue;
                String propValue = this.sessionFactory.getProperty2(i);
                this.propsData.add(new PropertyData(i, propName, propValue));
            }
        }
    }

    private class PropertyData {
        private int modelIndex;
        private String name;
        private String value;

        public PropertyData(int modelIndex, String propName, String propValue) {
            this.modelIndex = modelIndex;
            this.name = propName;
            this.value = propValue;
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public String getPropName() {
            return this.name;
        }

        public String getPropValue() {
            return this.value;
        }

        public void setPropValue(String value) {
            this.value = value;
        }
    }
}

