/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class CustomJDBCConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private Connection connection = null;
    private Properties connectionProperties = null;
    private static final Logger logger = Logger.getLogger(CustomJDBCConnectionProvider.class.getName());

    public void configure(Map map) {
        this.connectionProperties = new Properties();
        this.connectionProperties.putAll((Map<?, ?>)map);
    }

    public Connection getConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            logger.info("Connection already established.. returing");
            return this.connection;
        }
        try {
            String driverClassName = this.connectionProperties.getProperty("hibernate.connection.driver_class");
            String driverURL = this.connectionProperties.getProperty("hibernate.connection.url");
            String username = this.connectionProperties.getProperty("hibernate.connection.username");
            String password = this.connectionProperties.getProperty("hibernate.connection.password");
            if (driverClassName == null) {
                driverClassName = this.connectionProperties.getProperty("connection.driver_class");
            }
            if (driverURL == null) {
                driverURL = this.connectionProperties.getProperty("connection.url");
            }
            if (username == null) {
                username = this.connectionProperties.getProperty("connection.username");
            }
            if (password == null) {
                password = this.connectionProperties.getProperty("connection.password");
            }
            if (username == null) {
                username = "";
            }
            if (password == null) {
                password = "";
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(driverClassName);
            Driver driver = (Driver)clazz.newInstance();
            logger.info("Loaded JDBC driver ");
            Properties info = new Properties();
            info.setProperty("user", username);
            info.setProperty("password", password);
            this.connection = driver.connect(driverURL, info);
            logger.info("Got connection.. returning");
            info = null;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.INFO, "DB Driver class not found during connection creation.", e);
            NotifyDescriptor.Exception ne = new NotifyDescriptor.Exception((Throwable)e);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)ne);
        }
        catch (InstantiationException e) {
            logger.log(Level.INFO, "Cannot instantiate driver class.", e);
            NotifyDescriptor.Exception ne = new NotifyDescriptor.Exception((Throwable)e);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)ne);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.INFO, "Illegal access during connection creation.", e);
            NotifyDescriptor.Exception ne = new NotifyDescriptor.Exception((Throwable)e);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)ne);
        }
        catch (SQLException e) {
            logger.log(Level.INFO, "DB connection error.", e);
            NotifyDescriptor.Exception ne = new NotifyDescriptor.Exception((Throwable)e);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)ne);
        }
        return this.connection;
    }

    public void closeConnection(Connection arg0) throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void close() throws HibernateException {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || CustomJDBCConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || CustomJDBCConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void stop() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
        }
    }
}

