/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class GitMergeResult {
    private final MergeStatus mergeStatus;
    private final VCSFileProxy workDir;
    private final List<VCSFileProxy> conflicts;
    private final List<VCSFileProxy> failures;
    private final String newHead;
    private final String base;
    private final String[] mergedCommits;

    GitMergeResult(MergeResultContainer mergeResult, VCSFileProxy workDir) {
        this.mergeStatus = mergeResult.mergeStatus;
        this.workDir = workDir;
        this.newHead = mergeResult.newHead;
        this.base = mergeResult.base;
        this.mergedCommits = mergeResult.mergedCommits == null ? new String[]{} : mergeResult.mergedCommits;
        this.conflicts = mergeResult.conflicts;
        this.failures = mergeResult.failures;
    }

    public MergeStatus getMergeStatus() {
        return this.mergeStatus;
    }

    public String getBase() {
        return this.base;
    }

    public String[] getMergedCommits() {
        return this.mergedCommits;
    }

    public String getNewHead() {
        return this.newHead;
    }

    public Collection<VCSFileProxy> getConflicts() {
        return this.conflicts;
    }

    public Collection<VCSFileProxy> getFailures() {
        return this.failures;
    }

    public static final class MergeResultContainer {
        public MergeStatus mergeStatus;
        public VCSFileProxy workDir;
        public List<VCSFileProxy> conflicts = new ArrayList<VCSFileProxy>();
        public List<VCSFileProxy> failures = new ArrayList<VCSFileProxy>();
        public String newHead;
        public String base;
        public String[] mergedCommits;
    }

    public static enum MergeStatus {
        FAST_FORWARD{

            public String toString() {
                return "Fast-forward";
            }
        }
        ,
        ABORTED{

            public String toString() {
                return "Aborted";
            }
        }
        ,
        ALREADY_UP_TO_DATE{

            public String toString() {
                return "Already up-to-date";
            }
        }
        ,
        FAILED{

            public String toString() {
                return "Failed";
            }
        }
        ,
        MERGED{

            public String toString() {
                return "Merged";
            }
        }
        ,
        CONFLICTING{

            public String toString() {
                return "Conflicting";
            }
        }
        ,
        NOT_SUPPORTED{

            public String toString() {
                return "Not-yet-supported";
            }
        };

    }
}

