/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.Utils;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class RenameCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final VCSFileProxy source;
    private final VCSFileProxy target;
    private final boolean after;
    private final ProgressMonitor monitor;
    private final FileListener listener;

    public RenameCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy source, VCSFileProxy target, boolean after, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.source = source;
        this.target = target;
        this.after = after;
        this.monitor = monitor;
        this.listener = listener;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            String relPathToTarget;
            VCSFileProxy workTree = this.getRepository().getLocation();
            String relPathToSource = Utils.getRelativePath(workTree, this.source);
            if (relPathToSource.startsWith((relPathToTarget = Utils.getRelativePath(workTree, this.target)) + "/")) {
                this.monitor.preparationsFailed(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Error_SourceFolderUnderTarget"), relPathToSource, relPathToTarget));
                throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Error_SourceFolderUnderTarget"), relPathToSource, relPathToTarget));
            }
            if (relPathToTarget.startsWith(relPathToSource + "/")) {
                this.monitor.preparationsFailed(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Error_TargetFolderUnderSource"), relPathToTarget, relPathToSource));
                throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Error_TargetFolderUnderSource"), relPathToTarget, relPathToSource));
            }
            if (this.source.equals((Object)this.getRepository().getLocation())) {
                throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Exception_CannotMoveWT"), this.source.getPath()));
            }
            if (!this.source.exists() && !this.after) {
                throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Exception_SourceDoesNotExist"), this.source.getPath()));
            }
            if (this.target.exists()) {
                if (!this.after) {
                    throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Exception_TargetExists"), this.target.getPath()));
                }
            } else if (this.after) {
                throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Exception_TargetDoesNotExist"), this.target.getPath()));
            }
        }
        return retval;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(3);
        super.prepare();
        this.addArgument(0, "mv");
        this.addArgument(0, "--verbose");
        this.addArgument(0, "-f");
        this.addArgument(0, Utils.getRelativePath(this.getRepository().getLocation(), this.source));
        this.addArgument(0, Utils.getRelativePath(this.getRepository().getLocation(), this.target));
        this.addArgument(1, "rm");
        this.addArgument(1, "--ignore-unmatch");
        this.addArgument(1, "-r");
        this.addArgument(1, "--");
        this.addArgument(1, Utils.getRelativePath(this.getRepository().getLocation(), this.source));
        this.addArgument(2, "add");
        this.addArgument(2, "-v");
        this.addArgument(2, "--");
        this.addArgument(2, Utils.getRelativePath(this.getRepository().getLocation(), this.target));
    }

    @Override
    protected void run() throws GitException {
        block7: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                if (!this.after) {
                    this.rename();
                    final AtomicBoolean isError = new AtomicBoolean(false);
                    new GitCommand.Runner(canceled, 0){

                        @Override
                        public void outputParser(String output) throws GitException {
                            RenameCommand.this.parseMoveOutput(output);
                        }

                        @Override
                        protected void errorParser(String error) throws GitException {
                            isError.set(true);
                        }
                    }.runCLI();
                    if (isError.get()) {
                        VCSFileProxySupport.renameTo((VCSFileProxy)this.source, (VCSFileProxy)this.target);
                        this.listener.notifyFile(this.target, Utils.getRelativePath(this.getRepository().getLocation(), this.target));
                    }
                } else {
                    new GitCommand.Runner(canceled, 1){

                        @Override
                        public void outputParser(String output) throws GitException {
                            RenameCommand.this.parseRemoveOutput(output);
                        }
                    }.runCLI();
                    new GitCommand.Runner(canceled, 2){

                        @Override
                        public void outputParser(String output) throws GitException {
                            RenameCommand.this.parseAddVerboseOutput(output);
                        }
                    }.runCLI();
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block7;
                throw new GitException(t);
            }
        }
    }

    private void rename() throws GitException {
        VCSFileProxy parentFile = this.target.getParentFile();
        if (!parentFile.exists() && !VCSFileProxySupport.mkdirs((VCSFileProxy)parentFile)) {
            throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Exception_CannotCreateFolder"), parentFile.getPath()));
        }
    }

    private void parseMoveOutput(String output) {
        for (String line : output.split("\n")) {
            if (!line.startsWith("Renaming")) continue;
            String[] s = line.split(" ");
            String file = s[s.length - 1];
            this.listener.notifyFile(VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)file), file);
        }
    }

    private void parseAddVerboseOutput(String output) {
        for (String line : output.split("\n")) {
            String s;
            if (!line.startsWith("add") || !(s = line.substring(3).trim()).startsWith("'") || !s.endsWith("'")) continue;
            String file = s.substring(1, s.length() - 1);
            this.listener.notifyFile(VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)file), file);
        }
    }

    private void parseRemoveOutput(String output) {
        HashSet<VCSFileProxy> parents = new HashSet<VCSFileProxy>();
        for (String line : output.split("\n")) {
            if (!(line = line.trim()).startsWith("rm '") || !line.endsWith("'")) continue;
            String file = line.substring(4, line.length() - 1);
            VCSFileProxy path = VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)file);
            if (file.indexOf(47) > 0) {
                parents.add(path.getParentFile());
            }
            this.listener.notifyFile(path, file);
        }
        for (VCSFileProxy parent : parents) {
            if (parent.exists()) continue;
            this.listener.notifyFile(parent, Utils.getRelativePath(this.getRepository().getLocation(), parent));
        }
    }
}

