/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultSettings {
    private static final Logger logger = Logger.getLogger(Util.class.getName());
    private static final String WSSIP = "wssip";
    private static final String XWS_SECURITY_CLIENT = "xws-security-client";
    private static final String XWS_SECURITY_SERVER = "xws-security-server";
    private static final String SERVER_KEYSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/server-keystore.jks";
    private static final String SERVER_TRUSTSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/server-truststore.jks";
    private static final String CLIENT_KEYSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/client-keystore.jks";
    private static final String CLIENT_TRUSTSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/client-truststore.jks";
    private static final String PASSWORD = "changeit";
    private static final String STORE_FOLDER_NAME = "certs";
    private static final String BUILD_SCRIPT = "/build.xml";
    private static final String BACKUP_EXT = ".bak";
    private static final String IMPORT_WSIT_DEPLOY_XML = "<import file=\"nbproject/wsit-deploy.xml\"/>";
    private static final String IMPORT_TAG = "<import";
    private static final String WSIT_DEPLOY_XML_PATH = "nbproject/wsit-deploy.xml";
    private static final String WSIT_DEPLOY_XSL = "org/netbeans/modules/websvc/wsitconf/resources/wsit-deploy.xsl";

    public static final void fillDefaultsToServer(String serverID) {
        boolean glassfish = ServerUtils.isGlassfish(serverID);
        String serverKeyStorePath = ServerUtils.getStoreLocation(serverID, false, false);
        String serverTrustStorePath = ServerUtils.getStoreLocation(serverID, true, false);
        String clientKeyStorePath = ServerUtils.getStoreLocation(serverID, false, true);
        String clientTrustStorePath = ServerUtils.getStoreLocation(serverID, true, true);
        if (!glassfish) {
            FileObject tomcatLocation = ServerUtils.getTomcatLocation(serverID);
            try {
                FileObject[] filesToCreate;
                FileObject targetFolder = FileUtil.createFolder((FileObject)tomcatLocation, (String)STORE_FOLDER_NAME);
                DataFolder folderDO = (DataFolder)DataObject.find((FileObject)targetFolder);
                FileObject foClientKey = FileUtil.getConfigFile((String)"Templates/WebServices/client-keystore.jks");
                FileObject foClientTrust = FileUtil.getConfigFile((String)"Templates/WebServices/client-truststore.jks");
                FileObject foServerKey = FileUtil.getConfigFile((String)"Templates/WebServices/server-keystore.jks");
                FileObject foServerTrust = FileUtil.getConfigFile((String)"Templates/WebServices/server-truststore.jks");
                for (FileObject fo : filesToCreate = new FileObject[]{foClientKey, foClientTrust, foServerKey, foServerTrust}) {
                    DataObject template;
                    if (fo == null || (template = DataObject.find((FileObject)fo)) == null || targetFolder.getFileObject(fo.getName(), fo.getExt()) != null) continue;
                    template.createFromTemplate(folderDO, fo.getNameExt());
                }
                FileObject tomcatUsers = tomcatLocation.getFileObject("conf/tomcat-users.xml");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbf.newDocumentBuilder();
                Document document = builder.parse(FileUtil.toFile((FileObject)tomcatUsers));
                NodeList nodes = document.getElementsByTagName("tomcat-users");
                if (nodes != null && nodes.getLength() > 0) {
                    Node n = nodes.item(0);
                    NodeList users = document.getElementsByTagName("user");
                    boolean foundUser = false;
                    for (int i = 0; i < users.getLength(); ++i) {
                        Element u;
                        String userAttr;
                        Node node = users.item(i);
                        if (!(node instanceof Element) || !"wsitUser".equals(userAttr = (u = (Element)node).getAttribute("name"))) continue;
                        foundUser = true;
                        break;
                    }
                    if (!foundUser) {
                        if (tomcatUsers.getParent().getFileObject("tomcat-users.backup", "xml") == null) {
                            FileUtil.copyFile((FileObject)tomcatUsers, (FileObject)tomcatUsers.getParent(), (String)"tomcat-users.backup");
                        }
                        Element user = document.createElement("user");
                        user.setAttribute("name", "wsitUser");
                        user.setAttribute("password", PASSWORD);
                        user.setAttribute("roles", "tomcat");
                        n.appendChild(user);
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.setOutputProperty("indent", "yes");
                        StreamResult result = new StreamResult(FileUtil.toFile((FileObject)tomcatUsers));
                        DOMSource source = new DOMSource(document);
                        transformer.transform(source, result);
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, null, ex);
            }
            return;
        }
        String dstPasswd = DefaultSettings.getDefaultPassword(serverID);
        try {
            DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, serverKeyStorePath, XWS_SECURITY_SERVER, dstPasswd, false);
            DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, serverKeyStorePath, WSSIP, dstPasswd, false);
            DefaultSettings.copyKey(SERVER_TRUSTSTORE_BUNDLED, "certificate-authority", PASSWORD, PASSWORD, serverTrustStorePath, "xwss-certificate-authority", dstPasswd, true);
            DefaultSettings.copyKey(SERVER_TRUSTSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, serverTrustStorePath, XWS_SECURITY_CLIENT, dstPasswd, true);
            DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, serverTrustStorePath, XWS_SECURITY_SERVER, dstPasswd, true);
            DefaultSettings.copyKey(CLIENT_KEYSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, clientKeyStorePath, XWS_SECURITY_CLIENT, dstPasswd, false);
            DefaultSettings.copyKey(CLIENT_TRUSTSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, clientTrustStorePath, XWS_SECURITY_SERVER, dstPasswd, true);
            DefaultSettings.copyKey(CLIENT_TRUSTSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, clientTrustStorePath, WSSIP, dstPasswd, true);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, null, ex);
        }
    }

    public static final void fillDefaults(Project project, boolean client, boolean refreshScript) {
        boolean tomcat = ServerUtils.isTomcat(project);
        boolean glassfish = ServerUtils.isGlassfish(project);
        if (tomcat) {
            if (project != null) {
                FileObject tomcatLocation = ServerUtils.getTomcatLocation(project);
                try {
                    FileObject[] filesToCreate;
                    FileObject targetFolder = FileUtil.createFolder((FileObject)tomcatLocation, (String)STORE_FOLDER_NAME);
                    DataFolder folderDO = (DataFolder)DataObject.find((FileObject)targetFolder);
                    FileObject foClientKey = FileUtil.getConfigFile((String)"Templates/WebServices/client-keystore.jks");
                    FileObject foClientTrust = FileUtil.getConfigFile((String)"Templates/WebServices/client-truststore.jks");
                    FileObject foServerKey = FileUtil.getConfigFile((String)"Templates/WebServices/server-keystore.jks");
                    FileObject foServerTrust = FileUtil.getConfigFile((String)"Templates/WebServices/server-truststore.jks");
                    for (FileObject fo : filesToCreate = new FileObject[]{foClientKey, foClientTrust, foServerKey, foServerTrust}) {
                        DataObject template;
                        if (fo == null || (template = DataObject.find((FileObject)fo)) == null || targetFolder.getFileObject(fo.getName(), fo.getExt()) != null) continue;
                        template.createFromTemplate(folderDO, fo.getNameExt());
                    }
                    if (!client) {
                        FileObject tomcatUsers = tomcatLocation.getFileObject("conf/tomcat-users.xml");
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = dbf.newDocumentBuilder();
                        Document document = builder.parse(FileUtil.toFile((FileObject)tomcatUsers));
                        NodeList nodes = document.getElementsByTagName("tomcat-users");
                        if (nodes != null && nodes.getLength() > 0) {
                            Node n = nodes.item(0);
                            NodeList users = document.getElementsByTagName("user");
                            boolean foundUser = false;
                            for (int i = 0; i < users.getLength(); ++i) {
                                Element u;
                                String userAttr;
                                Node node = users.item(i);
                                if (!(node instanceof Element) || !"wsitUser".equals(userAttr = (u = (Element)node).getAttribute("name"))) continue;
                                foundUser = true;
                                break;
                            }
                            if (!foundUser) {
                                if (tomcatUsers.getParent().getFileObject("tomcat-users.backup", "xml") == null) {
                                    FileUtil.copyFile((FileObject)tomcatUsers, (FileObject)tomcatUsers.getParent(), (String)"tomcat-users.backup");
                                }
                                Element user = document.createElement("user");
                                user.setAttribute("name", "wsitUser");
                                user.setAttribute("password", PASSWORD);
                                user.setAttribute("roles", "tomcat");
                                n.appendChild(user);
                                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                                transformer.setOutputProperty("indent", "yes");
                                StreamResult result = new StreamResult(FileUtil.toFile((FileObject)tomcatUsers));
                                DOMSource source = new DOMSource(document);
                                transformer.transform(source, result);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, null, ex);
                }
            }
            return;
        }
        String dstPasswd = DefaultSettings.getDefaultPassword(project);
        if (glassfish) {
            try {
                if (!client && refreshScript) {
                    DefaultSettings.refreshBuildScript(project);
                }
                String serverKeyStorePath = ServerUtils.getStoreLocation(project, false, false);
                String serverTrustStorePath = ServerUtils.getStoreLocation(project, true, false);
                String clientKeyStorePath = ServerUtils.getStoreLocation(project, false, true);
                String clientTrustStorePath = ServerUtils.getStoreLocation(project, true, true);
                DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, serverKeyStorePath, XWS_SECURITY_SERVER, dstPasswd, false);
                DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, serverKeyStorePath, WSSIP, dstPasswd, false);
                DefaultSettings.copyKey(SERVER_TRUSTSTORE_BUNDLED, "certificate-authority", PASSWORD, PASSWORD, serverTrustStorePath, "xwss-certificate-authority", dstPasswd, true);
                DefaultSettings.copyKey(SERVER_TRUSTSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, serverTrustStorePath, XWS_SECURITY_CLIENT, dstPasswd, true);
                DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, serverTrustStorePath, XWS_SECURITY_SERVER, dstPasswd, true);
                DefaultSettings.copyKey(CLIENT_KEYSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, clientKeyStorePath, XWS_SECURITY_CLIENT, dstPasswd, false);
                DefaultSettings.copyKey(CLIENT_TRUSTSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, clientTrustStorePath, XWS_SECURITY_SERVER, dstPasswd, true);
                DefaultSettings.copyKey(CLIENT_TRUSTSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, clientTrustStorePath, WSSIP, dstPasswd, true);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyKey(String srcPath, String srcAlias, String srcPasswd, String srcKeyPasswd, String dstPath, String dstAlias, String dstPasswd, boolean trustedCertEntry) throws Exception {
        KeyStore srcStore = KeyStore.getInstance("JKS");
        KeyStore dstStore = KeyStore.getInstance("JKS");
        srcStore.load(Util.class.getResourceAsStream(srcPath), srcPasswd.toCharArray());
        FileInputStream is = new FileInputStream(dstPath);
        try {
            dstStore.load(is, dstPasswd.toCharArray());
            Key privKey = srcStore.getKey(srcAlias, srcKeyPasswd.toCharArray());
            if (is != null) {
                ((InputStream)is).close();
            }
            FileOutputStream os = new FileOutputStream(dstPath);
            try {
                if (privKey == null || trustedCertEntry) {
                    dstStore.setCertificateEntry(dstAlias, srcStore.getCertificate(srcAlias));
                } else {
                    Certificate cert = srcStore.getCertificate(srcAlias);
                    Certificate[] chain = new Certificate[]{cert};
                    dstStore.setKeyEntry(dstAlias, privKey, dstPasswd.toCharArray(), chain);
                }
            }
            finally {
                if (os != null) {
                    dstStore.store(os, dstPasswd.toCharArray());
                    ((OutputStream)os).close();
                }
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshBuildScript(Project p) {
        String buildScript = FileUtil.toFile((FileObject)p.getProjectDirectory()).getPath() + BUILD_SCRIPT;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        String line = null;
        boolean added = false;
        try {
            reader = new BufferedReader(new FileReader(buildScript));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(IMPORT_WSIT_DEPLOY_XML) == -1) continue;
                added = true;
                break;
            }
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            logger.log(Level.INFO, null, ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    logger.log(Level.INFO, null, ex);
                }
            }
        }
        if (!added) {
            try {
                File backupBuildScript = new File(buildScript);
                backupBuildScript.renameTo(new File(buildScript + BACKUP_EXT));
                reader = new BufferedReader(new FileReader(buildScript + BACKUP_EXT));
                writer = new BufferedWriter(new FileWriter(buildScript));
                added = false;
                int index = 0;
                while ((line = reader.readLine()) != null) {
                    if (!added && (index = line.indexOf(IMPORT_TAG)) != -1) {
                        StringBuffer buf = new StringBuffer(line);
                        buf = buf.replace(index, line.length(), IMPORT_WSIT_DEPLOY_XML);
                        writer.write(buf.toString());
                        writer.newLine();
                        added = true;
                    }
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (FileNotFoundException ex) {
                logger.log(Level.INFO, null, ex);
            }
            catch (IOException ex) {
                logger.log(Level.INFO, null, ex);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.flush();
                        writer.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.INFO, null, ex);
                }
            }
        }
        GeneratedFilesHelper genFilesHelper = new GeneratedFilesHelper(p.getProjectDirectory());
        try {
            genFilesHelper.refreshBuildScript(WSIT_DEPLOY_XML_PATH, Util.class.getClassLoader().getResource(WSIT_DEPLOY_XSL), false);
        }
        catch (IOException ex) {
            logger.log(Level.INFO, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unfillDefaults(Project p) {
        String buildScript = FileUtil.toFile((FileObject)p.getProjectDirectory()).getPath() + BUILD_SCRIPT;
        FileObject createUserFile = p.getProjectDirectory().getFileObject("nbproject/wsit.createuser");
        if (createUserFile != null && createUserFile.isValid() && !createUserFile.isVirtual()) {
            try {
                createUserFile.delete();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        BufferedReader reader = null;
        BufferedWriter writer = null;
        String line = null;
        boolean added = false;
        try {
            reader = new BufferedReader(new FileReader(buildScript));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(IMPORT_WSIT_DEPLOY_XML) == -1) continue;
                added = true;
                break;
            }
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            logger.log(Level.INFO, null, ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    logger.log(Level.INFO, null, ex);
                }
            }
        }
        if (added) {
            try {
                File backupBuildScript = new File(buildScript);
                backupBuildScript.renameTo(new File(buildScript + BACKUP_EXT));
                reader = new BufferedReader(new FileReader(buildScript + BACKUP_EXT));
                writer = new BufferedWriter(new FileWriter(buildScript));
                added = false;
                while ((line = reader.readLine()) != null) {
                    if (line.indexOf(IMPORT_WSIT_DEPLOY_XML) != -1) continue;
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (FileNotFoundException ex) {
                logger.log(Level.INFO, null, ex);
            }
            catch (IOException ex) {
                logger.log(Level.INFO, null, ex);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.flush();
                        writer.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.INFO, null, ex);
                }
            }
        }
    }

    public static String getDefaultPassword(Project p) {
        String storeLoc;
        String password = PASSWORD;
        if (ServerUtils.isGlassfish(p) && !DefaultSettings.passwordOK(storeLoc = ServerUtils.getStoreLocation(p, false, false), password) && !DefaultSettings.passwordOK(storeLoc, password = Util.getPassword(p))) {
            password = "";
        }
        return password;
    }

    public static String getDefaultPassword(String serverID) {
        String storeLoc;
        String password = PASSWORD;
        if (ServerUtils.isGlassfish(serverID) && !DefaultSettings.passwordOK(storeLoc = ServerUtils.getStoreLocation(serverID, false, false), password) && !DefaultSettings.passwordOK(storeLoc, password = "adminadmin")) {
            password = "";
        }
        return password;
    }

    private static boolean passwordOK(String storePath, String password) {
        try {
            Util.getAliases(storePath, password.toCharArray(), "JKS");
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

