/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import org.netbeans.modules.cnd.apt.impl.support.APTConstTextToken;
import org.netbeans.modules.cnd.apt.support.APTTokenAbstact;

public final class APTLiteLiteralToken
extends APTTokenAbstact {
    private static final int COL_BITS = 10;
    private static final int MAX_COL = 1023;
    private static final int LINE_BITS = 14;
    private static final int MAX_LINE = 16383;
    private static final int TYPE_BITS = 8;
    private static final int MAX_TYPE = 255;
    private final int offset;
    private final int columnLineType;

    public static boolean isApplicable(int type, int offset, int column, int line, int literalType) {
        if (type != 91 || line > 16383 || column > 1023) {
            return false;
        }
        return literalType > 109 && literalType < 276;
    }

    public APTLiteLiteralToken(int offset, int column, int line, int literalType) {
        this.offset = offset;
        assert (APTConstTextToken.constText[literalType] != null) : "no text for literal type " + literalType;
        int type = literalType - 109;
        assert (type > 0 && type < 255);
        this.columnLineType = (((column & 0x3FF) << 14) + (line & 0x3FFF) << 8) + (type & 0xFF);
        assert (column == this.getColumn()) : column + " vs. " + this.getColumn();
        assert (line == this.getLine()) : line + " vs. " + this.getLine();
        assert (literalType == this.getLiteralType()) : literalType + " vs. " + this.getLiteralType();
    }

    @Override
    public String getText() {
        return APTConstTextToken.constText[this.getLiteralType()];
    }

    @Override
    public void setText(String t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTextID(CharSequence id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getTextID() {
        return APTConstTextToken.constTextID[this.getLiteralType()];
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getType() {
        return 91;
    }

    public int getLiteralType() {
        return (this.columnLineType & 0xFF) + 109;
    }

    @Override
    public void setType(int t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getColumn() {
        return this.columnLineType >> 22 & 0x3FF;
    }

    @Override
    public void setColumn(int c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLine() {
        return this.columnLineType >> 8 & 0x3FFF;
    }

    @Override
    public void setLine(int l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEndOffset() {
        return this.getOffset() + this.getTextID().length();
    }

    @Override
    public int getEndLine() {
        return this.getLine();
    }

    @Override
    public int getEndColumn() {
        return this.getColumn() + this.getTextID().length();
    }
}

