/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTHandlersSupportImpl;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.openide.filesystems.FileSystem;
import org.openide.util.Parameters;

public final class APTFileCacheManager {
    private static Map<FileSystem, APTFileCacheManager> managers = new WeakHashMap<FileSystem, APTFileCacheManager>();
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static final java.util.concurrent.locks.Lock rLock = rwLock.readLock();
    private static final java.util.concurrent.locks.Lock wLock = rwLock.writeLock();
    private ConcurrentMap<CharSequence, Reference<ConcurrentMap<PPIncludeHandler.State, APTFileCacheEntry>>> file2AptCacheRef = new ConcurrentHashMap<CharSequence, Reference<ConcurrentMap<PPIncludeHandler.State, APTFileCacheEntry>>>();
    private final Object aptCachesLock = new Lock();

    private APTFileCacheManager() {
    }

    public static APTFileCacheManager getInstance(FileSystem fs2) {
        APTFileCacheManager manager;
        Parameters.notNull((CharSequence)"null file system", (Object)fs2);
        rLock.lock();
        try {
            manager = managers.get(fs2);
        }
        finally {
            rLock.unlock();
        }
        if (manager == null) {
            wLock.lock();
            try {
                manager = managers.get(fs2);
                if (manager == null) {
                    manager = new APTFileCacheManager();
                    managers.put(fs2, manager);
                }
            }
            finally {
                wLock.unlock();
            }
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"DLS"})
    private ConcurrentMap<PPIncludeHandler.State, APTFileCacheEntry> getAPTCache(CharSequence file, Boolean createAndClean) {
        ConcurrentMap<PPIncludeHandler.State, APTFileCacheEntry> out;
        if (createAndClean == null) {
            Reference removed = (Reference)this.file2AptCacheRef.remove(file);
            return null;
        }
        Reference ref2fileCache = (SoftReference<ConcurrentHashMap<PPIncludeHandler.State, APTFileCacheEntry>>)this.file2AptCacheRef.get(file);
        ConcurrentHashMap<PPIncludeHandler.State, APTFileCacheEntry> concurrentHashMap = out = ref2fileCache == null ? null : (ConcurrentHashMap<PPIncludeHandler.State, APTFileCacheEntry>)((Reference)ref2fileCache).get();
        if (out == null) {
            out = new ConcurrentHashMap<PPIncludeHandler.State, APTFileCacheEntry>();
            ref2fileCache = APTTraceFlags.USE_SOFT_APT_CACHE ? new SoftReference<ConcurrentHashMap<PPIncludeHandler.State, APTFileCacheEntry>>((ConcurrentHashMap<PPIncludeHandler.State, APTFileCacheEntry>)out) : new WeakReference<ConcurrentHashMap<PPIncludeHandler.State, APTFileCacheEntry>>((ConcurrentHashMap<PPIncludeHandler.State, APTFileCacheEntry>)out);
            Reference prev = this.file2AptCacheRef.putIfAbsent(file, ref2fileCache);
            if (prev != null) {
                ConcurrentMap prevCache = (ConcurrentMap)prev.get();
                if (prevCache != null) {
                    out = prevCache;
                } else {
                    Object object = this.aptCachesLock;
                    synchronized (object) {
                        this.file2AptCacheRef.remove(file, prev);
                        boolean add = false;
                        prev = this.file2AptCacheRef.putIfAbsent(file, ref2fileCache);
                        if (prev != null) {
                            prevCache = (ConcurrentMap)prev.get();
                            if (prevCache != null) {
                                out = prevCache;
                            } else {
                                add = true;
                            }
                        }
                        if (add) {
                            this.file2AptCacheRef.put(file, ref2fileCache);
                        }
                    }
                }
            }
        }
        assert (out != null);
        if (Boolean.TRUE.equals(createAndClean)) {
            out.clear();
        }
        return out;
    }

    public APTFileCacheEntry getEntry(CharSequence file, PreprocHandler.State ppState, Boolean createExclusiveIfAbsent) {
        PPIncludeHandler.State key = APTFileCacheManager.getKey(ppState);
        ConcurrentMap<PPIncludeHandler.State, APTFileCacheEntry> cache = this.getAPTCache(file, Boolean.FALSE);
        APTFileCacheEntry out = (APTFileCacheEntry)cache.get(key);
        if (createExclusiveIfAbsent != null) {
            if (out == null) {
                if (Boolean.TRUE.equals(createExclusiveIfAbsent)) {
                    out = APTFileCacheEntry.createSerialEntry(file);
                } else {
                    out = APTFileCacheEntry.createConcurrentEntry(file);
                    APTFileCacheEntry prev = cache.putIfAbsent(key, out);
                    if (prev != null) {
                        out = prev;
                    }
                }
            } else {
                if (Boolean.TRUE.equals(createExclusiveIfAbsent)) {
                    out = APTFileCacheEntry.toReadOnly(out);
                }
                if (APTTraceFlags.TRACE_APT_CACHE) {
                    System.err.printf("APT CACHE for %s%nsize %d, key: %s%ncache state:%s%n", file, cache.size(), "", "");
                }
            }
        } else if (out != null) {
            out = APTFileCacheEntry.toReadOnly(out);
        }
        assert (createExclusiveIfAbsent == null || out != null);
        return out;
    }

    public void setAPTCacheEntry(CharSequence absPath, PreprocHandler.State ppState, APTFileCacheEntry entry, boolean cleanOthers) {
        if (entry != null) {
            ConcurrentMap<PPIncludeHandler.State, APTFileCacheEntry> cache = this.getAPTCache(absPath, cleanOthers ? Boolean.TRUE : Boolean.FALSE);
            PPIncludeHandler.State key = APTFileCacheManager.getKey(ppState);
            cache.put(key, APTFileCacheEntry.toCachable(entry));
        }
    }

    public void invalidate(CharSequence absPath) {
        ConcurrentMap<PPIncludeHandler.State, APTFileCacheEntry> fileEntry = this.getAPTCache(absPath, null);
        if (fileEntry != null) {
            fileEntry.clear();
        }
    }

    public static void invalidateAll() {
        wLock.lock();
        try {
            for (APTFileCacheManager manager : managers.values()) {
                manager.file2AptCacheRef.clear();
            }
            managers.clear();
        }
        finally {
            wLock.unlock();
        }
    }

    public static void close() {
        APTFileCacheManager.invalidateAll();
    }

    private static PPIncludeHandler.State getKey(PreprocHandler.State ppState) {
        return APTHandlersSupportImpl.extractIncludeState(ppState);
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

