/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette.tester.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.nette.tester.commands.Bundle;
import org.netbeans.modules.php.nette.tester.options.TesterOptions;
import org.netbeans.modules.php.nette.tester.options.TesterOptionsValidator;
import org.netbeans.modules.php.nette.tester.preferences.TesterPreferences;
import org.netbeans.modules.php.nette.tester.preferences.TesterPreferencesValidator;
import org.netbeans.modules.php.nette.tester.run.TapParser;
import org.netbeans.modules.php.nette.tester.run.TestCaseVo;
import org.netbeans.modules.php.nette.tester.run.TestSuiteVo;
import org.netbeans.modules.php.nette.tester.ui.customizer.TesterCustomizer;
import org.netbeans.modules.php.spi.testing.run.TestCase;
import org.netbeans.modules.php.spi.testing.run.TestRunException;
import org.netbeans.modules.php.spi.testing.run.TestRunInfo;
import org.netbeans.modules.php.spi.testing.run.TestSession;
import org.netbeans.modules.php.spi.testing.run.TestSuite;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class Tester {
    private static final Logger LOGGER = Logger.getLogger(Tester.class.getName());
    public static final String TESTER_FILE_NAME = "tester";
    private static final File COVERAGE_LOG;
    private static final String OUTPUT_PARAM = "-o";
    private static final String TAP_OUTPUT_PARAM = "tap";
    private static final String SKIP_INFO_PARAM = "-s";
    private static final String PHP_INI_PARAM = "-c";
    private static final String BINARY_EXECUTABLE_PARAM = "-p";
    private static final String COVERAGE_PARAM = "--coverage";
    private static final String COVERAGE_SRC_PARAM = "--coverage-src";
    private static final String DEFINE_INI_ENTRY_PARAM = "-d";
    private static final String XDEBUG_INI_ENTRY_PARAM;
    private final String testerPath;

    private Tester(String testerPath) {
        assert (testerPath != null);
        this.testerPath = testerPath;
    }

    public static Tester getDefault() throws InvalidPhpExecutableException {
        String error = Tester.validateDefault(true, true);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new Tester(TesterOptions.getInstance().getTesterPath());
    }

    @CheckForNull
    public static Tester getForPhpModule(PhpModule phpModule, boolean showCustomizer) {
        String path;
        String error;
        if (Tester.validatePhpModule(phpModule) != null) {
            if (showCustomizer) {
                UiUtils.invalidScriptProvided((PhpModule)phpModule, (String)TesterCustomizer.IDENTIFIER, null);
            }
            return null;
        }
        if (!TesterPreferences.isPhpIniEnabled(phpModule) && (error = Tester.validateDefault(false, true)) != null) {
            if (showCustomizer) {
                UiUtils.invalidScriptProvided((String)error, (String)"FrameworksAndTools/nette-tester");
            }
            return null;
        }
        if (TesterPreferences.isTesterEnabled(phpModule)) {
            path = TesterPreferences.getTesterPath(phpModule);
        } else {
            String error2 = Tester.validateDefault(true, false);
            if (error2 != null) {
                if (showCustomizer) {
                    UiUtils.invalidScriptProvided((String)error2, (String)"FrameworksAndTools/nette-tester");
                }
                return null;
            }
            path = TesterOptions.getInstance().getTesterPath();
        }
        return new Tester(path);
    }

    public static boolean isTestMethod(PhpType.Method method) {
        return method.getName().startsWith("test");
    }

    @CheckForNull
    private static String validateDefault(boolean validateTester, boolean validatePhpIni) {
        TesterOptionsValidator validator = new TesterOptionsValidator();
        if (validateTester) {
            validator.validateTesterPath(TesterOptions.getInstance().getTesterPath());
        }
        if (validatePhpIni) {
            validator.validatePhpIniPath(TesterOptions.getInstance().getPhpIniPath());
        }
        return Tester.validateResult(validator.getResult());
    }

    @CheckForNull
    private static String validatePhpModule(PhpModule phpModule) {
        ValidationResult result = new TesterPreferencesValidator().validate(phpModule).getResult();
        return Tester.validateResult(result);
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return ((ValidationResult.Message)result.getErrors().get(0)).getMessage();
        }
        return ((ValidationResult.Message)result.getWarnings().get(0)).getMessage();
    }

    @CheckForNull
    public File getCoverageLog() {
        if (COVERAGE_LOG.isFile()) {
            return COVERAGE_LOG;
        }
        return null;
    }

    @CheckForNull
    public Integer runTests(PhpModule phpModule, TestRunInfo runInfo, TestSession testSession) throws TestRunException {
        List customTests;
        PhpExecutable tester = this.getExecutable(phpModule);
        ArrayList<String> params = new ArrayList<String>();
        params.add(OUTPUT_PARAM);
        params.add(TAP_OUTPUT_PARAM);
        params.add(SKIP_INFO_PARAM);
        this.addBinaryExecutable(phpModule, params);
        this.addPhpIni(phpModule, params);
        if (runInfo.isCoverageEnabled()) {
            if (COVERAGE_LOG.isFile() && !COVERAGE_LOG.delete()) {
                LOGGER.info("Cannot delete Nette Tester coverage log file");
            }
            params.add(DEFINE_INI_ENTRY_PARAM);
            params.add(XDEBUG_INI_ENTRY_PARAM);
            params.add(COVERAGE_PARAM);
            params.add(COVERAGE_LOG.getAbsolutePath());
            String coverageSourcePath = null;
            if (TesterPreferences.isCoverageSourcePathEnabled(phpModule)) {
                coverageSourcePath = TesterPreferences.getCoverageSourcePath(phpModule);
            } else {
                FileObject sourceDirectory = phpModule.getSourceDirectory();
                if (sourceDirectory != null) {
                    coverageSourcePath = FileUtil.toFile((FileObject)sourceDirectory).getAbsolutePath();
                }
            }
            if (coverageSourcePath != null) {
                params.add(COVERAGE_SRC_PARAM);
                params.add(coverageSourcePath);
            }
        }
        if ((customTests = runInfo.getCustomTests()).isEmpty()) {
            for (FileObject startFile : runInfo.getStartFiles()) {
                params.add(FileUtil.toFile((FileObject)startFile).getAbsolutePath());
            }
        } else {
            for (TestRunInfo.TestInfo testInfo : customTests) {
                String location = testInfo.getLocation();
                assert (location != null) : testInfo;
                params.add(new File(location).getAbsolutePath());
            }
        }
        tester.additionalParameters(params);
        try {
            if (runInfo.getSessionType() == TestRunInfo.SessionType.TEST) {
                return tester.runAndWait(this.getDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)new ParsingFactory(testSession), "Running tester tests...");
            }
            List startFiles = runInfo.getStartFiles();
            assert (startFiles.size() == 1) : "Exactly one file expected for debugging but got " + startFiles;
            return tester.debug((FileObject)startFiles.get(0), this.getDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)new ParsingFactory(testSession));
        }
        catch (CancellationException ex) {
            LOGGER.log(Level.FINE, "Test running cancelled", ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            if (TesterPreferences.isTesterEnabled(phpModule)) {
                UiUtils.processExecutionException((ExecutionException)ex, (PhpModule)phpModule, (String)TesterCustomizer.IDENTIFIER);
            } else {
                UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/nette-tester");
            }
            throw new TestRunException((Throwable)ex);
        }
        return null;
    }

    private PhpExecutable getExecutable(PhpModule phpModule) {
        FileObject testDirectory = phpModule.getTestDirectory(null);
        assert (testDirectory != null) : "Test directory not found for " + phpModule.getName();
        return new PhpExecutable(this.testerPath).optionsSubcategory("FrameworksAndTools/nette-tester").workDir(FileUtil.toFile((FileObject)testDirectory)).displayName(Bundle.Tester_run_title(phpModule.getDisplayName()));
    }

    private ExecutionDescriptor getDescriptor() {
        return new ExecutionDescriptor().optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/nette-tester").showProgress(true).outLineBased(true).errLineBased(true);
    }

    private void addBinaryExecutable(PhpModule phpModule, List<String> params) {
        String binaryExecutable = TesterPreferences.isBinaryEnabled(phpModule) ? TesterPreferences.getBinaryExecutable(phpModule) : TesterOptions.getInstance().getBinaryExecutable();
        if (StringUtils.hasText((String)binaryExecutable)) {
            params.add(BINARY_EXECUTABLE_PARAM);
            params.add(binaryExecutable);
        }
    }

    private void addPhpIni(PhpModule phpModule, List<String> params) {
        String phpIniPath = TesterPreferences.isPhpIniEnabled(phpModule) ? TesterPreferences.getPhpIniPath(phpModule) : TesterOptions.getInstance().getPhpIniPath();
        if (StringUtils.hasText((String)phpIniPath)) {
            params.add(PHP_INI_PARAM);
            params.add(phpIniPath);
        }
    }

    static {
        XDEBUG_INI_ENTRY_PARAM = "zend_extension=xdebug." + (Utilities.isWindows() ? "dll" : "so");
        String logDirName = System.getProperty("java.io.tmpdir");
        COVERAGE_LOG = new File(logDirName, "nb-tester-coverage.xml");
    }

    private static final class ParsingProcessor
    implements LineProcessor {
        private static final Logger LOGGER = Logger.getLogger(ParsingProcessor.class.getName());
        private final TestSession testSession;
        private final StringBuilder buffer = new StringBuilder();
        private TestSuite testSuite = null;
        private long currentMillis = ParsingProcessor.currentMillis();
        private long testSuiteTime = 0L;

        public ParsingProcessor(TestSession testSession) {
            assert (testSession != null);
            this.testSession = testSession;
        }

        private static long currentMillis() {
            return System.currentTimeMillis();
        }

        public void processLine(String line) {
            LOGGER.log(Level.FINEST, "Processing line: {0}", line);
            if (TapParser.isTestCaseStart(line)) {
                this.process(this.buffer.toString());
                this.buffer.setLength(0);
            }
            this.buffer.append(line);
            this.buffer.append("\n");
        }

        public void reset() {
            LOGGER.fine("Resetting processor");
            this.finish();
        }

        public void close() {
            LOGGER.fine("Closing processor");
            this.finish();
        }

        private void finish() {
            this.process(this.buffer.toString());
            if (this.testSuite != null) {
                LOGGER.log(Level.FINE, "Test suite {0} found, finishing", this.testSuite);
                this.testSuite.finish(this.testSuiteTime);
            }
        }

        public void process(String input) {
            LOGGER.log(Level.FINEST, "Parsing input:\n{0}", input);
            TestSuiteVo suite = new TapParser().parse(input, ParsingProcessor.currentMillis() - this.currentMillis);
            LOGGER.log(Level.FINE, "Parsed test suites: {0}", suite);
            try {
                this.process(suite);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, null, throwable);
            }
            this.currentMillis = ParsingProcessor.currentMillis();
        }

        private void process(TestSuiteVo suite) {
            if (this.testSuite == null) {
                this.testSuite = this.testSession.addTestSuite(suite.getName(), this.getFileObject(suite.getFile()));
            }
            this.addTestCases(suite.getTestCases());
        }

        private FileObject getFileObject(String path) {
            if (path == null) {
                return null;
            }
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(path)));
            assert (fileObject != null) : "Cannot find file object for: " + path;
            return fileObject;
        }

        private void addTestCases(List<TestCaseVo> testCases) {
            for (TestCaseVo kase : testCases) {
                String name = kase.getName();
                LOGGER.log(Level.FINE, "Adding new test case {0}", name);
                TestCase testCase = this.testSuite.addTestCase(name, "Nette Tester");
                try {
                    this.map(kase, testCase);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, null, throwable);
                }
                this.testSuiteTime += kase.getTime();
            }
        }

        private void map(TestCaseVo kase, TestCase testCase) {
            testCase.setStatus(kase.getStatus());
            this.mapLocation(kase, testCase);
            this.mapFailureInfo(kase, testCase);
            testCase.setTime(kase.getTime());
        }

        private void mapLocation(TestCaseVo kase, TestCase testCase) {
        }

        private void mapFailureInfo(TestCaseVo kase, TestCase testCase) {
            if (this.isPass(kase.getStatus())) {
                if (kase.getMessage() != null) {
                    this.mapFailureInfoInternal(kase, testCase);
                }
                assert (kase.getDiff() == null) : kase.getDiff();
                return;
            }
            this.mapFailureInfoInternal(kase, testCase);
        }

        private void mapFailureInfoInternal(TestCaseVo kase, TestCase testCase) {
            TestCase.Diff diff;
            List<String> stackTrace;
            String message = kase.getMessage();
            if (message == null) {
                message = Bundle.ParsingProcessor_failure_unknown();
            }
            if ((stackTrace = kase.getStackTrace()) == null) {
                stackTrace = Collections.emptyList();
            }
            if ((diff = kase.getDiff()) == null) {
                diff = TestCase.Diff.NOT_KNOWN;
            }
            testCase.setFailureInfo(message, stackTrace.toArray(new String[stackTrace.size()]), this.isError(kase.getStatus()), diff);
        }

        private boolean isPass(TestCase.Status status) {
            return status == TestCase.Status.PASSED || status == TestCase.Status.SKIPPED;
        }

        private boolean isError(TestCase.Status status) {
            return status == TestCase.Status.ERROR;
        }
    }

    private static final class ParsingFactory
    implements ExecutionDescriptor.InputProcessorFactory2 {
        private final TestSession testSession;

        private ParsingFactory(TestSession testSession) {
            assert (testSession != null);
            this.testSession = testSession;
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.bridge((LineProcessor)new ParsingProcessor(this.testSession));
        }
    }
}

