/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;

public class StringSwitch<T> {
    private final StringRef Str;
    private T Result;

    public StringSwitch(StringRef S) {
        this.Str = S;
        this.Result = null;
    }

    public StringSwitch(String S) {
        this(new StringRef(S));
    }

    public StringSwitch(char.ptr S) {
        this(new StringRef(S));
    }

    public StringSwitch(std.string S) {
        this(new StringRef(S));
    }

    public StringSwitch<T> Case(String S, T Value) {
        if (this.Result == null && this.Str.$equals(S)) {
            this.Result = Value;
        }
        return this;
    }

    public StringSwitch<T> EndsWith(String S, T Value) {
        if (this.Result == null && this.Str.endswith(S)) {
            this.Result = Value;
        }
        return this;
    }

    public StringSwitch<T> StartsWith(String S, T Value) {
        if (this.Result == null && this.Str.startswith(S)) {
            this.Result = Value;
        }
        return this;
    }

    public StringSwitch<T> Cases(String S0, String S1, T Value) {
        return this.Case(S0, Value).Case(S1, Value);
    }

    public StringSwitch<T> Cases(String S0, String S1, String S2, T Value) {
        return this.Case(S0, Value).Case(S1, Value).Case(S2, Value);
    }

    public StringSwitch<T> Cases(String S0, String S1, String S2, String S3, T Value) {
        return this.Case(S0, Value).Case(S1, Value).Case(S2, Value).Case(S3, Value);
    }

    public StringSwitch<T> Cases(String S0, String S1, String S2, String S3, String S4, T Value) {
        return this.Case(S0, Value).Case(S1, Value).Case(S2, Value).Case(S3, Value).Case(S4, Value);
    }

    public T Default(T Value) {
        if (this.Result != null) {
            return this.Result;
        }
        return Value;
    }

    public T $T_0_1() {
        assert (this.Result != null) : "Fell off the end of a string-switch";
        return this.Result;
    }
}

