/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.char;

public abstract class SmallVectorImplChar
implements Native.assignable<SmallVectorImplChar>,
Native.NativeComparable<SmallVectorImplChar>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<Byte>,
Native.NativeIterable<iterator> {
    protected final byte defaultValue;
    private byte[] array;
    private static final byte[] EMPTY = NativePointer.new$char((int)0, (byte[])new byte[0]);
    private int end;

    public final byte[] $array() {
        return this.array;
    }

    protected SmallVectorImplChar(int capacity, byte defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$char((int)capacity, (byte[])new byte[0]);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplChar(int capacity, int initialSize, byte defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplChar(int capacity, int initialSize, byte value, byte defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplChar(byte[] array2, byte defaultValue) {
        this.array = array2;
        this.end = array2 == null ? 0 : array2.length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplChar(int capacity, char.iterator<?> iter, int length, byte defaultValue) {
        this(capacity, iter, (char.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplChar(int capacity, char.iterator<?> begin, char.iterator<?> end, byte defaultValue) {
        this(capacity, defaultValue);
        this.append(begin, end);
    }

    protected SmallVectorImplChar(SmallVectorImplChar other) {
        this.defaultValue = other.defaultValue;
        this.array = (byte[])other.array.clone();
        this.end = other.end;
    }

    protected SmallVectorImplChar(JavaDifferentiators.JD.Move _dparam, SmallVectorImplChar other) {
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = null;
        other.end = 0;
    }

    public final SmallVectorImplChar $assign(SmallVectorImplChar other) {
        this.array = other.array;
        this.end = other.end;
        return this;
    }

    public final SmallVectorImplChar $assignMove(SmallVectorImplChar other) {
        assert (this != other) : "moving self";
        this.array = other.array;
        this.end = other.end;
        other.array = null;
        other.end = 0;
        return this;
    }

    public final void clear() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, byte defaultValue) {
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone((byte)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(int N) {
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, byte Elt) {
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign(char.iterator<?> __first, char.iterator<?> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public final void swap(SmallVectorImplChar RHS) {
        byte[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(byte elem) {
        return this.find(elem, 0);
    }

    public final int find(byte elem, int from) {
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq((byte)this.array[i], (byte)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(byte elem) {
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(byte elem) {
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            std.copy((byte[])this.array, (int)(index + 1), (int)(this.end - index), (byte[])this.array, (int)index);
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final iterator erase(iterator I) {
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.copy((char.iterator)I.$add(1), (char.iterator)this.end(), (char.iterator)I);
        this.pop_back();
        return N;
    }

    public final iterator erase(iterator S, iterator E) {
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = (iterator)std.copy((char.iterator)E, (char.iterator)this.end(), (char.iterator)S);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public final iterator insert(iterator I, byte Elt) {
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((char.iterator)I, (char.iterator)this.end().$sub(1), (char.iterator)this.end());
        I.star$ref().$set(Elt);
        return I;
    }

    public final iterator insert(iterator I, int NumToInsert, byte Elt) {
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((char.iterator)I, (char.iterator)OldEnd.$sub(NumToInsert), (char.iterator)OldEnd);
            std.fill_n((char.iterator)I, (int)NumToInsert, (byte)Elt);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub(I);
        std.copy((char.iterator)I, (char.iterator)OldEnd, (char.iterator)this.end().$sub(NumOverwritten));
        std.fill_n((char.iterator)I, (int)NumOverwritten, (byte)Elt);
        std.fill_n((char.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (byte)Elt);
        return I;
    }

    public final iterator insert(iterator I, char.iterator<?> From, char.iterator<?> To) {
        int NumOverwritten;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((char.iterator)I, (char.iterator)OldEnd.$sub(NumToInsert), (char.iterator)OldEnd);
            std.copy(From, To, (char.iterator)I);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((char.iterator)I, (char.iterator)OldEnd, (char.iterator)this.end().$sub(NumOverwritten));
        iterator J = I.clone();
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set(From.$star());
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, (char.iterator)OldEnd);
        return I;
    }

    public final void append(char.iterator<?> in_start, char.iterator<?> in_end) {
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        char.iterator iter = (char.iterator)in_start.clone();
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(byte[] a) {
        this.append(a, 0, a.length);
    }

    public final void append(byte[] a, int fromIndex, int count) {
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            byte el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(int NumInputs, byte Elt) {
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final boolean $eq(SmallVectorImplChar RHS) {
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((byte)this.array[i], (byte)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplChar RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplChar)obj).begin(), (Object)((SmallVectorImplChar)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((SmallVectorImplChar)obj);
    }

    public final char.ref ref$at(int idx) {
        return NativePointer.create_char$ref((byte[])this.array, (int)idx);
    }

    public final byte $at(int idx) {
        return this.array[idx];
    }

    public final byte $set(int idx, byte value) {
        this.array[idx] = value;
        return value;
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public final void $destroy() {
    }

    public final void push_back(byte val) {
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void emplace_back(byte val) {
        this.push_back(val);
    }

    public final void emplace_back() {
        this.push_back(this.defaultValue);
    }

    public final void pop_back() {
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final byte pop_back_val() {
        byte val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator begin() {
        return new iterator(this, 0, false);
    }

    public final iterator end() {
        return new iterator(this, this.end, false);
    }

    public final std.reverse_iteratorChar rbegin() {
        return new std.reverse_iteratorChar((char.iterator)NativePointer.create_char$ptr((byte[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorChar rend() {
        return new std.reverse_iteratorChar((char.iterator)NativePointer.create_char$ptr((byte[])this.array));
    }

    public final char.ptr data() {
        return NativePointer.create_char$ptr((byte[])this.array);
    }

    public final byte front() {
        return this.array[0];
    }

    public final byte back() {
        return this.array[this.end - 1];
    }

    public final char.ref ref$front() {
        return new char.ref(){
            private final byte stored;
            private final int index = 0;
            {
                this.stored = SmallVectorImplChar.this.array[0];
                this.index = 0;
            }

            public byte $deref() {
                return this.stored;
            }

            public byte $set(byte value) {
                ((SmallVectorImplChar)SmallVectorImplChar.this).array[0] = value;
                return value;
            }

            public char.ptr deref$ptr() {
                return (char.ptr)SmallVectorImplChar.this.data().$add(0);
            }
        };
    }

    public final char.ref ref$back() {
        return new char.ref(){
            private final byte stored;
            private final int index;
            {
                this.stored = SmallVectorImplChar.this.array[SmallVectorImplChar.this.end - 1];
                this.index = SmallVectorImplChar.this.end - 1;
            }

            public byte $deref() {
                return this.stored;
            }

            public byte $set(byte value) {
                ((SmallVectorImplChar)SmallVectorImplChar.this).array[this.index] = value;
                return value;
            }

            public char.ptr deref$ptr() {
                return (char.ptr)SmallVectorImplChar.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        return this.end;
    }

    public final int max_size() {
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        return this.array.length;
    }

    public final int $sizeof() {
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        int oneElemSize = NativeType.sizeof((byte)this.defaultValue);
        for (byte elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((byte)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final char.ptr ptr$at(int idx) {
        return NativePointer.create_char$ptr((byte[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int capacity) {
        byte[] oldArray = this.array;
        this.array = NativePointer.new$char((int)capacity, (byte[])new byte[0]);
        NativePointer.copy$Object((byte[])oldArray, (int)0, (byte[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    public iterator $toIterator(char.ptr ptr2) {
        assert (ptr2.$array() == this.array);
        return new iterator(this, ptr2.$index(), false);
    }

    @Override
    public Iterator<Byte> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplChar{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            byte element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element == 0 ? "<EOF>" : Character.valueOf((char)element)).append('\n');
        }
        out.append("}SmallVectorImplChar}\n");
        return out.toString();
    }

    private static final class JavaIterator
    implements Iterator<Byte> {
        private final iterator begin;
        private final iterator end;

        public JavaIterator(iterator begin, iterator end) {
            this.begin = (iterator)Native.$tryClone((NativeCloneable)begin);
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.begin.$noteq(this.end);
        }

        @Override
        public Byte next() {
            Byte val = this.begin.$star();
            this.begin.$preInc();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static final class iterator
    implements char.iterator<iterator>,
    Native.assignable<iterator>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final SmallVectorImplChar delegate;
        private int index;

        private iterator(SmallVectorImplChar delegate, int index, boolean makeConst) {
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator $assign(iterator other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        public byte $arrow() {
            return this.$at(0);
        }

        public byte $star() {
            return this.$at(0);
        }

        public char.ref star$ref() {
            return this.ref$at(0);
        }

        public int $sub(iterator iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        public iterator $preInc() {
            assert (!this._const);
            ++this.index;
            return this;
        }

        public iterator $preDec() {
            assert (!this._const);
            --this.index;
            return this;
        }

        public iterator $postInc() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        public iterator $postDec() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        public iterator $inc(int amount) {
            assert (!this._const);
            this.index += amount;
            return this;
        }

        public iterator $dec(int amount) {
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        public iterator $add(int amount) {
            return new iterator(this.delegate, this.index + amount, false);
        }

        public iterator $sub(int amount) {
            return new iterator(this.delegate, this.index - amount, false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        public iterator clone() {
            return new iterator(this.delegate, this.index, false);
        }

        public iterator const_clone() {
            return new iterator(this.delegate, this.index, true);
        }

        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public byte $at(int index) {
            return this.delegate.$at(this.index + index);
        }

        public char.ref ref$at(int index) {
            return this.delegate.ref$at(this.index + index);
        }

        public char.ptr toPointer() {
            return NativePointer.create_char$ptr((byte[])this.delegate.array, (int)this.index);
        }

        public String toString() {
            return "[" + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

