/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.spi.model.services.CsmExpressionResolverImplementation;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.Lookup;

public final class CsmExpressionResolver {
    private static final CsmExpressionResolverImplementation DEFAULT = new Default();

    public static Collection<CsmObject> resolveObjects(CharSequence text, CsmFile contextFile, int contextOffset, List<CsmInstantiation> instantiations) {
        return CsmExpressionResolver.resolveObjects(text, contextFile, contextOffset, null, instantiations);
    }

    public static Collection<CsmObject> resolveObjects(CharSequence text, CsmFile contextFile, int contextOffset, CsmScope contextScope, List<CsmInstantiation> instantiations) {
        return DEFAULT.resolveObjects((CsmOffsetable)new SimpleExpression(text, contextFile, contextOffset, contextScope), instantiations);
    }

    public static Collection<CsmObject> resolveObjects(CsmOffsetable expression, List<CsmInstantiation> instantiations) {
        return DEFAULT.resolveObjects(expression, instantiations);
    }

    @Deprecated
    public static CsmType resolveType(CharSequence text, CsmFile contextFile, int contextOffset, List<CsmInstantiation> instantiations) {
        return CsmExpressionResolver.resolveType(text, contextFile, contextOffset, null, instantiations);
    }

    public static void resolveType(CharSequence text, CsmFile contextFile, int contextOffset, List<CsmInstantiation> instantiations, ResolvedTypeHandler task) {
        CsmExpressionResolver.resolveType(text, contextFile, contextOffset, null, instantiations, task);
    }

    @Deprecated
    public static CsmType resolveType(CharSequence text, CsmFile contextFile, int contextOffset, CsmScope contextScope, List<CsmInstantiation> instantiations) {
        SimpleResolvedTypeHandler resolvedHandler = new SimpleResolvedTypeHandler();
        DEFAULT.resolveType((CsmOffsetable)new SimpleExpression(text, contextFile, contextOffset, contextScope), instantiations, resolvedHandler);
        return resolvedHandler.resolved;
    }

    public static void resolveType(CharSequence text, CsmFile contextFile, int contextOffset, CsmScope contextScope, List<CsmInstantiation> instantiations, ResolvedTypeHandler task) {
        DEFAULT.resolveType((CsmOffsetable)new SimpleExpression(text, contextFile, contextOffset, contextScope), instantiations, task);
    }

    @Deprecated
    public static CsmType resolveType(CsmOffsetable expression, List<CsmInstantiation> instantiations) {
        SimpleResolvedTypeHandler resolvedHandler = new SimpleResolvedTypeHandler();
        DEFAULT.resolveType(expression, instantiations, resolvedHandler);
        return resolvedHandler.resolved;
    }

    public static void resolveType(CsmOffsetable expression, List<CsmInstantiation> instantiations, ResolvedTypeHandler task) {
        DEFAULT.resolveType(expression, instantiations, task);
    }

    public static boolean shouldResolveAsMacroType(CsmType type, CsmScope scope) {
        CsmOffsetable offsetable;
        return type != null && CsmKindUtilities.isOffsetable((Object)scope) && Objects.equals((offsetable = (CsmOffsetable)scope).getContainingFile(), type.getContainingFile()) && offsetable.getStartOffset() == type.getStartOffset() && offsetable.getEndOffset() == type.getEndOffset();
    }

    public static CsmType resolveMacroType(CsmType typeFromMacro, CsmScope scope, List<CsmInstantiation> instantiations, ResolvedTypeHandler handler) {
        assert (CsmExpressionResolver.shouldResolveAsMacroType(typeFromMacro, scope));
        CsmType type = typeFromMacro;
        CompositeResolvedTypeHandler compositeHandler = new CompositeResolvedTypeHandler(new SimpleResolvedTypeHandler(), handler);
        for (int counter = 4; type != null && !CsmBaseUtilities.isValid((CsmObject)type.getClassifier()) && !CharSequenceUtils.isNullOrEmpty((CharSequence)type.getClassifierText()) && counter > 0; --counter) {
            CsmExpressionResolver.resolveType(CsmInstantiationProvider.getDefault().getOriginalText(type), type.getContainingFile(), type.getStartOffset(), scope, instantiations, compositeHandler);
            type = ((SimpleResolvedTypeHandler)compositeHandler.first).resolved;
        }
        return type;
    }

    private CsmExpressionResolver() {
        throw new AssertionError((Object)"Not instantiable");
    }

    private static final class Default
    implements CsmExpressionResolverImplementation {
        private final Lookup.Result<CsmExpressionResolverImplementation> res = Lookup.getDefault().lookupResult(CsmExpressionResolverImplementation.class);
        private CsmExpressionResolverImplementation delegate;

        private Default() {
        }

        private CsmExpressionResolverImplementation getDelegate() {
            CsmExpressionResolverImplementation service = this.delegate;
            if (service == null) {
                Iterator iterator = this.res.allInstances().iterator();
                if (iterator.hasNext()) {
                    CsmExpressionResolverImplementation resolver;
                    service = resolver = (CsmExpressionResolverImplementation)iterator.next();
                }
                this.delegate = service;
            }
            return service;
        }

        @Override
        public Collection<CsmObject> resolveObjects(CsmOffsetable expression, List<CsmInstantiation> instantiations) {
            CsmExpressionResolverImplementation service = this.getDelegate();
            if (service != null) {
                return this.getDelegate().resolveObjects(expression, instantiations);
            }
            return null;
        }

        @Override
        public void resolveType(CsmOffsetable expression, List<CsmInstantiation> instantiations, ResolvedTypeHandler task) {
            CsmExpressionResolverImplementation service = this.getDelegate();
            if (service != null) {
                service.resolveType(expression, instantiations, task);
            }
        }
    }

    private static class CompositeResolvedTypeHandler
    implements ResolvedTypeHandler {
        public final ResolvedTypeHandler first;
        public final ResolvedTypeHandler second;

        public CompositeResolvedTypeHandler(ResolvedTypeHandler first, ResolvedTypeHandler second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void process(CsmType resolvedType) {
            if (this.first != null) {
                this.first.process(resolvedType);
            }
            if (this.second != null) {
                this.second.process(resolvedType);
            }
        }
    }

    private static class SimpleResolvedTypeHandler
    implements ResolvedTypeHandler {
        public CsmType resolved;

        private SimpleResolvedTypeHandler() {
        }

        @Override
        public void process(CsmType resolvedType) {
            this.resolved = resolvedType;
        }
    }

    private static class SimpleExpression
    implements CsmExpression {
        private final String expression;
        private final CsmFile containingFile;
        private final CsmScope scope;
        private final int startOffset;
        private final int endOffset;

        public SimpleExpression(CharSequence expression, CsmFile containingFile, int startOffset, CsmScope scope) {
            this.expression = expression.toString();
            this.containingFile = containingFile;
            this.startOffset = startOffset;
            this.endOffset = startOffset + expression.length();
            this.scope = scope;
        }

        public CsmFile getContainingFile() {
            return this.containingFile;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CharSequence getText() {
            return this.expression;
        }

        public CharSequence getExpandedText() {
            return this.expression;
        }

        public CsmExpression.Kind getKind() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public List<CsmStatement> getLambdas() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public List<CsmExpression> getOperands() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmExpression getParent() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmScope getScope() {
            return this.scope;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + (this.expression != null ? this.expression.hashCode() : 0);
            hash = 97 * hash + (this.containingFile != null ? this.containingFile.hashCode() : 0);
            hash = 97 * hash + this.startOffset;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleExpression other = (SimpleExpression)obj;
            if (!(this.expression == other.expression || this.expression != null && this.expression.equals(other.expression))) {
                return false;
            }
            if (!(this.containingFile == other.containingFile || this.containingFile != null && this.containingFile.equals(other.containingFile))) {
                return false;
            }
            return this.startOffset == other.startOffset;
        }

        public String toString() {
            return this.expression + " at [" + this.containingFile.getAbsolutePath() + ":" + this.startOffset + "]";
        }
    }

    public static interface ResolvedTypeHandler {
        public void process(CsmType var1);
    }
}

