/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.actions.base;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.remote.ui.ServerListUI;
import org.netbeans.modules.cnd.remote.actions.OpenRemoteProjectAction;
import org.netbeans.modules.cnd.remote.actions.base.RemoteOpenActionBase;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public abstract class RemoteActionPerformer
implements ActionListener,
DynamicMenuContent {
    protected RemoteOpenActionBase presenter;
    private JMenuItem lastPresenter;

    protected abstract void actionPerformedRemote(ExecutionEnvironment var1, ActionEvent var2);

    protected final Action findAction(String path, String id) {
        Lookup.Template template;
        Lookup lookup = Lookups.forPath((String)path);
        Lookup.Item item = lookup.lookupItem(template = new Lookup.Template(Action.class, id, null));
        if (item != null) {
            return (Action)item.getInstance();
        }
        return null;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        ExecutionEnvironment env;
        if (e != null && "performerActivated".equals(e.getActionCommand())) {
            this.presenter = (RemoteOpenActionBase)e.getSource();
            return;
        }
        if (e != null && e.getSource() instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)e.getSource();
            Object property = item.getClientProperty("org.netbeans.modules.cnd.remote.actions.ENV");
            if (property instanceof ExecutionEnvironment) {
                this.actionPerformedRemote((ExecutionEnvironment)property, e);
            } else {
                ServerListUI.showServerListDialog();
            }
            return;
        }
        if (e != null && e.getSource() instanceof Lookup.Provider && (env = (ExecutionEnvironment)((Lookup.Provider)e.getSource()).getLookup().lookup(ExecutionEnvironment.class)) != null) {
            this.actionPerformedRemote(env, e);
            return;
        }
        this.actionPerformedRemote(ServerList.getDefaultRecord().getExecutionEnvironment(), e);
    }

    public JComponent[] getMenuPresenters() {
        this.lastPresenter = this.createSubMenu();
        return new JComponent[]{this.lastPresenter};
    }

    public JComponent[] synchMenuPresenters(JComponent[] jcs) {
        this.lastPresenter = this.createSubMenu();
        return new JComponent[]{this.lastPresenter};
    }

    private JMenuItem createSubMenu() throws MissingResourceException {
        String label = this.presenter.getSubmenuTitle();
        JMenu subMenu = new JMenu(label);
        subMenu.setIcon(this.presenter.getIcon());
        for (ServerRecord record : ServerList.getRecords()) {
            if (!record.isRemote()) continue;
            String text = this.presenter.getItemTitle(record.getDisplayName());
            JMenuItem item = new JMenuItem(text);
            item.putClientProperty("org.netbeans.modules.cnd.remote.actions.ENV", record.getExecutionEnvironment());
            item.addActionListener(this);
            subMenu.add(item);
        }
        if (subMenu.getItemCount() > 0) {
            subMenu.add(new JSeparator());
        }
        JMenuItem item = new JMenuItem(NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"LBL_ManagePlatforms_Name"));
        item.putClientProperty("org.netbeans.modules.cnd.remote.actions.ENV", null);
        item.addActionListener(this);
        subMenu.add(item);
        return subMenu;
    }
}

