/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public class CsmSortUtilities {
    public static final Comparator CLASS_NAME_COMPARATOR = new DefaultClassNameComparator();
    public static final Comparator INSENSITIVE_CLASS_NAME_COMPARATOR = new InsensitiveClassNameComparator();
    public static final Comparator NATURAL_MEMBER_NAME_COMPARATOR = new NaturalMemberNameComparator(true);
    public static final Comparator INSENSITIVE_NATURAL_MEMBER_NAME_COMPARATOR = new NaturalMemberNameComparator();
    public static final Comparator NATURAL_NAMESPACE_MEMBER_COMPARATOR = new NsNaturalMemberNameComparator(true);
    public static final Comparator INSENSITIVE_NATURAL_NAMESPACE_MEMBER_COMPARATOR = new NsNaturalMemberNameComparator(false);

    private CsmSortUtilities() {
    }

    public static boolean matchName(CharSequence name_, CharSequence strPrefix_, boolean match, boolean caseSensitive) {
        int n1 = name_.length();
        if (n1 == 0) {
            return false;
        }
        int n2 = strPrefix_.length();
        for (int i = 0; i < n1 && i < n2; ++i) {
            char c2;
            char c1 = name_.charAt(i);
            if (c1 == (c2 = strPrefix_.charAt(i))) continue;
            if (!caseSensitive && !match) {
                if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return false;
            }
            return false;
        }
        if (match) {
            return n1 == n2;
        }
        return n1 >= n2;
    }

    public static List<CsmNamedElement> filterList(Collection<? extends CsmDeclaration> list, CharSequence strPrefix, boolean match, boolean caseSensitive) {
        return CsmSortUtilities.filterList(list.iterator(), strPrefix, match, caseSensitive);
    }

    public static List<CsmNamedElement> filterList(Iterator<? extends CsmDeclaration> it, CharSequence strPrefix, boolean match, boolean caseSensitive) {
        ArrayList<CsmNamedElement> res = new ArrayList<CsmNamedElement>();
        while (it.hasNext()) {
            CsmDeclaration elem = it.next();
            if (!CsmKindUtilities.isNamedElement((Object)elem) || !CsmSortUtilities.matchName(((CsmNamedElement)elem).getName(), strPrefix, match, caseSensitive)) continue;
            res.add(elem);
        }
        return res;
    }

    public static List sortClasses(List classes, boolean sensitive) {
        if (sensitive) {
            Collections.sort(classes, CLASS_NAME_COMPARATOR);
        } else {
            Collections.sort(classes, INSENSITIVE_CLASS_NAME_COMPARATOR);
        }
        return classes;
    }

    public static List sortMembers(List members, boolean sensitive) {
        return CsmSortUtilities.sortMembers(members, true, sensitive);
    }

    public static List sortMembers(List members, boolean natural, boolean sensitive) {
        if (sensitive) {
            Collections.sort(members, NATURAL_MEMBER_NAME_COMPARATOR);
        } else {
            Collections.sort(members, INSENSITIVE_NATURAL_MEMBER_NAME_COMPARATOR);
        }
        return members;
    }

    public static List sortNamespaceMembers(List members, boolean sensitive) {
        if (sensitive) {
            Collections.sort(members, NATURAL_NAMESPACE_MEMBER_COMPARATOR);
        } else {
            Collections.sort(members, INSENSITIVE_NATURAL_NAMESPACE_MEMBER_COMPARATOR);
        }
        return members;
    }

    private static int compareNames(CsmNamedElement elem1, CsmNamedElement elem2, boolean sensitive) {
        int order = sensitive ? CharSequences.comparator().compare(elem1.getName(), elem2.getName()) : CharSequenceUtils.ComparatorIgnoreCase.compare(elem1.getName(), elem2.getName());
        return order;
    }

    private static int compareVariables(CsmVariable var1, CsmVariable var2, boolean sensitive) {
        int order = CsmSortUtilities.compareNames(var1, var2, sensitive);
        int sameName = CharSequences.comparator().compare(var1.getName(), var2.getName());
        if (order == 0 && sameName != 0) {
            order = sameName;
        }
        return order;
    }

    private static int compareEnumerators(CsmEnumerator enmtr1, CsmEnumerator enmtr2, boolean sensitive) {
        int order = CsmSortUtilities.compareNames(enmtr1, enmtr2, sensitive);
        int sameName = CharSequences.comparator().compare(enmtr1.getName(), enmtr2.getName());
        if (order == 0 && sameName != 0) {
            order = sameName;
        }
        return order;
    }

    private static int compareFunctions(CsmFunction fun1, CsmFunction fun2, boolean sensitive) {
        int order = CsmSortUtilities.compareNames(fun1, fun2, sensitive);
        if (order == 0) {
            CsmParameter[] param1 = fun1.getParameters().toArray(new CsmParameter[0]);
            CsmParameter[] param2 = fun2.getParameters().toArray(new CsmParameter[0]);
            int commonCnt = Math.min(param1.length, param2.length);
            for (int i = 0; i < commonCnt; ++i) {
                block6: {
                    try {
                        order = sensitive ? CharSequences.comparator().compare(param1[i].getType().getText(), param2[i].getType().getText()) : CharSequenceUtils.ComparatorIgnoreCase.compare(param1[i].getType().getText(), param2[i].getType().getText());
                    }
                    catch (NullPointerException ex) {
                        order = 0;
                        if (param1[i].isVarArgs() != param2[i].isVarArgs()) {
                            order = param1[i].isVarArgs() ? -1 : 1;
                        }
                        if (param1[i].isVarArgs()) break block6;
                        System.err.println("CsmSortUtilities.compareFunctions: error while checking parameter " + i + "of functions" + fun1 + " and " + fun2);
                        ex.printStackTrace(System.err);
                    }
                }
                if (order == 0) continue;
                return order;
            }
            order = param1.length - param2.length;
        }
        int sameName = CharSequences.comparator().compare(fun1.getName(), fun2.getName());
        if (order == 0 && sameName != 0) {
            order = sameName;
        }
        return order;
    }

    private static int compareMacros(CsmMacro fun1, CsmMacro fun2, boolean sensitive) {
        int order = CsmSortUtilities.compareNames(fun1, fun2, sensitive);
        if (order == 0) {
            int size1 = 0;
            if (fun1.getParameters() != null) {
                size1 = fun1.getParameters().size();
            }
            int size2 = 0;
            if (fun2.getParameters() != null) {
                size2 = fun2.getParameters().size();
            }
            order = size1 - size2;
        }
        return order;
    }

    public static final class NsNaturalMemberNameComparator
    implements Comparator {
        private boolean sensitive;

        public NsNaturalMemberNameComparator() {
            this(false);
        }

        private NsNaturalMemberNameComparator(boolean sensitive) {
            this.sensitive = sensitive;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (CsmKindUtilities.isCsmObject(o1) && CsmKindUtilities.isCsmObject(o2)) {
                CsmObject csm1 = (CsmObject)o1;
                CsmObject csm2 = (CsmObject)o2;
                boolean ns1 = CsmKindUtilities.isNamespace(csm1);
                boolean ns2 = CsmKindUtilities.isNamespace(csm2);
                if (ns1 || ns2) {
                    if (ns1 && ns2) {
                        return CsmSortUtilities.compareNames((CsmNamespace)csm1, (CsmNamespace)csm2, this.sensitive);
                    }
                    if (ns1) {
                        return -1;
                    }
                    assert (ns2);
                    return 1;
                }
                boolean cls1 = CsmKindUtilities.isClassifier(csm1);
                boolean cls2 = CsmKindUtilities.isClassifier(csm2);
                if (cls1 || cls2) {
                    if (cls1 && cls2) {
                        return CsmSortUtilities.compareNames((CsmClassifier)csm1, (CsmClassifier)csm2, this.sensitive);
                    }
                    if (cls1) {
                        return -1;
                    }
                    assert (cls2);
                    return 1;
                }
                boolean var1 = CsmKindUtilities.isVariable(csm1);
                boolean var2 = CsmKindUtilities.isVariable(csm2);
                if (var1 || var2) {
                    if (var1 && var2) {
                        return CsmSortUtilities.compareVariables((CsmVariable)csm1, (CsmVariable)csm2, this.sensitive);
                    }
                    if (var1) {
                        return -1;
                    }
                    assert (var2);
                    return 1;
                }
                boolean fun1 = CsmKindUtilities.isFunction(csm1);
                boolean fun2 = CsmKindUtilities.isFunction(csm2);
                if (fun1 || fun2) {
                    if (fun1 && fun2) {
                        return CsmSortUtilities.compareFunctions((CsmFunction)csm1, (CsmFunction)csm2, this.sensitive);
                    }
                    if (fun1) {
                        return -1;
                    }
                    assert (fun2);
                    return 1;
                }
            }
            return 0;
        }
    }

    public static final class NaturalMemberNameComparator
    implements Comparator {
        private boolean sensitive;

        public NaturalMemberNameComparator() {
            this(false);
        }

        private NaturalMemberNameComparator(boolean sensitive) {
            this.sensitive = sensitive;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (CsmKindUtilities.isCsmObject(o1) && CsmKindUtilities.isCsmObject(o2)) {
                CsmObject csm1 = (CsmObject)o1;
                CsmObject csm2 = (CsmObject)o2;
                boolean var1 = CsmKindUtilities.isVariable(csm1);
                boolean var2 = CsmKindUtilities.isVariable(csm2);
                if (var1 || var2) {
                    if (var1 && var2) {
                        return CsmSortUtilities.compareVariables((CsmVariable)csm1, (CsmVariable)csm2, this.sensitive);
                    }
                    if (var1) {
                        return -1;
                    }
                    assert (var2);
                    return 1;
                }
                boolean enmtr1 = CsmKindUtilities.isEnumerator(csm1);
                boolean enmtr2 = CsmKindUtilities.isEnumerator(csm2);
                if (enmtr1 || enmtr2) {
                    if (enmtr1 && enmtr2) {
                        return CsmSortUtilities.compareEnumerators((CsmEnumerator)csm1, (CsmEnumerator)csm2, this.sensitive);
                    }
                    if (enmtr1) {
                        return -1;
                    }
                    assert (enmtr2);
                    return 1;
                }
                boolean fun1 = CsmKindUtilities.isFunction(csm1);
                boolean fun2 = CsmKindUtilities.isFunction(csm2);
                if (fun1 || fun2) {
                    if (fun1 && fun2) {
                        return CsmSortUtilities.compareFunctions((CsmFunction)csm1, (CsmFunction)csm2, this.sensitive);
                    }
                    if (fun1) {
                        return -1;
                    }
                    assert (fun2);
                    return 1;
                }
                boolean mac1 = CsmKindUtilities.isMacro(csm1);
                boolean mac2 = CsmKindUtilities.isMacro(csm2);
                if (mac1 || mac2) {
                    if (mac1 && mac2) {
                        return CsmSortUtilities.compareMacros((CsmMacro)csm1, (CsmMacro)csm2, this.sensitive);
                    }
                    if (mac1) {
                        return -1;
                    }
                    assert (mac2);
                    return 1;
                }
            }
            return 0;
        }
    }

    public static final class InsensitiveClassNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (CsmKindUtilities.isCsmObject(o1) && CsmKindUtilities.isCsmObject(o2)) {
                if (CsmKindUtilities.isClass((CsmObject)o1) && CsmKindUtilities.isClass((CsmObject)o2)) {
                    return CharSequenceUtils.ComparatorIgnoreCase.compare(((CsmClass)o1).getName(), ((CsmClass)o2).getName());
                }
                if (CsmKindUtilities.isNamespace((CsmObject)o1) && CsmKindUtilities.isNamespace((CsmObject)o2)) {
                    return CharSequenceUtils.ComparatorIgnoreCase.compare(((CsmNamespace)o1).getName(), ((CsmNamespace)o2).getName());
                }
            }
            return 0;
        }
    }

    public static final class DefaultClassNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (CsmKindUtilities.isCsmObject(o1) && CsmKindUtilities.isCsmObject(o2)) {
                if (CsmKindUtilities.isClass((CsmObject)o1) && CsmKindUtilities.isClass((CsmObject)o2)) {
                    return CharSequences.comparator().compare(((CsmClass)o1).getName(), ((CsmClass)o2).getName());
                }
                if (CsmKindUtilities.isNamespace((CsmObject)o1) && CsmKindUtilities.isNamespace((CsmObject)o2)) {
                    return CharSequences.comparator().compare(((CsmNamespace)o1).getName(), ((CsmNamespace)o2).getName());
                }
            }
            return 0;
        }
    }
}

