/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CharSourceRange;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.FileID;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.tok;
import org.clang.lex.Lexer;
import org.clang.lex.PPConditionalInfo;
import org.clang.lex.PTHManager;
import org.clang.lex.Preprocessor;
import org.clang.lex.PreprocessorLexer;
import org.clang.lex.Token;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm;

public final class PTHLexer
extends PreprocessorLexer
implements Destructors.ClassWithDestructor {
    public static final int INCOMPLETE_TOKEN_FLAG_BIT = Integer.MIN_VALUE;
    public static final int INCOMPLETE_TOKEN_FLAG_MASK = Integer.MAX_VALUE;
    private final int FileStartLoc;
    private final char.ptr TokBuf;
    private int CurPtr;
    private int LastHashTokPtr;
    private static final int INVALID = -1;
    private final char.ptr PPCond;
    private int CurPPCondPtr = -1;
    private boolean ExtendedTokenMode;
    private final PTHManager PTHMgr;
    private final Token EofToken;
    public static final int DISK_TOKEN_SIZE = 12;

    private PTHLexer(PTHLexer $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private void $assign(PTHLexer $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private void ReadToken(Token T) {
        throw new UnsupportedOperationException("ReadToken doesn't have implementation");
    }

    private boolean LexEndOfFile(Token Result) {
        if (this.ParsingPreprocessorDirective) {
            this.ParsingPreprocessorDirective = false;
            this.resetExtendedTokenMode();
            return true;
        }
        assert (!this.LexingRawMode);
        while (!this.ConditionalStack.empty()) {
            if (BasicClangGlobals.$noteq_SourceLocation((int)this.PP.getCodeCompletionFileLoc().getRawEncoding(), (int)this.FileStartLoc)) {
                this.PP.Diag(((PPConditionalInfo)this.ConditionalStack.back()).getIfLoc(), 837).$destroy();
            }
            this.ConditionalStack.pop_back();
        }
        return this.PP.HandleEndOfFile(Result);
    }

    protected PTHLexer(Preprocessor PP, FileID FID, char.ptr D, char.ptr ppcond, PTHManager PM) {
        this(PP, FID.$ID(), D, ppcond, PM);
    }

    protected PTHLexer(Preprocessor PP, int FID, char.ptr D, char.ptr ppcond, PTHManager PM) {
        super(PP, FID);
        this.TokBuf = Native.$toConst((char.ptr)D);
        this.CurPtr = 0;
        this.LastHashTokPtr = -1;
        this.PPCond = Native.$toConst((char.ptr)ppcond);
        this.CurPPCondPtr = ppcond == null ? -1 : 0;
        this.PTHMgr = PM;
        this.EofToken = new Token();
        this.FileStartLoc = PP.getSourceManager().getLocForStartOfFile(FID);
        this.resetExtendedTokenMode();
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public boolean isKeepWhitespaceMode() {
        return false;
    }

    @Override
    public void SetKeepWhitespaceMode(boolean Mode) {
        if (Mode) {
            throw new UnsupportedOperationException("PTHLexer doesn't support keep whitespace mode");
        }
        this.SetCommentRetentionState(false);
    }

    @Override
    public boolean inKeepCommentMode() {
        return this.ExtendedTokenMode;
    }

    @Override
    public void SetCommentRetentionState(boolean Mode) {
        this.ExtendedTokenMode = Mode;
    }

    @Override
    public void resetExtendedTokenMode() {
        assert (this.PP != null) : "Cannot reset token mode without a preprocessor";
        this.SetCommentRetentionState(this.PP.getCommentRetentionState());
    }

    public boolean Lex(Token Tok) {
        boolean commentTok;
        int TokenLoc;
        int Len;
        char TFlags;
        char TKind;
        int IdentifierID;
        do {
            int CurPtrShadow = this.CurPtr;
            assert (this.PPCond == null || this.PPCond.$index() - (this.TokBuf.$index() + CurPtrShadow) > NativeType.sizeof$uint32()) : "out of Tokens buffer:" + (this.TokBuf.$index() + CurPtrShadow) + " vs. " + this.PPCond.$index();
            int Word0 = llvm.support.endian.read_uint32((char.ptr)this.TokBuf, (int)CurPtrShadow, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
            IdentifierID = llvm.support.endian.read_uint32((char.ptr)this.TokBuf, (int)(CurPtrShadow += NativeType.sizeof$uint32()), (llvm.support.endianness)llvm.support.endianness.little, (int)0);
            int FileOffsetRaw = llvm.support.endian.read_uint32((char.ptr)this.TokBuf, (int)(CurPtrShadow += NativeType.sizeof$uint32()), (llvm.support.endianness)llvm.support.endianness.little, (int)0);
            CurPtrShadow += NativeType.sizeof$uint32();
            TKind = Unsigned.$int2ushort((int)(Word0 & 0xFF));
            TFlags = (char)(Word0 >> 8 & 0xFF);
            int FileOffset = FileOffsetRaw & Integer.MAX_VALUE;
            if (FileOffsetRaw != FileOffset) {
                TFlags = (char)(TFlags | 0x8000);
            }
            Len = Word0 >> 16 & 0xFFFF;
            TokenLoc = SourceLocation.$getLocWithOffset((int)this.FileStartLoc, (int)FileOffset);
            this.CurPtr = CurPtrShadow;
            boolean bl = commentTok = TKind == '\u0004';
            if (!commentTok) break;
            assert (this.PP != null);
            if (this.isLexingRawMode() || !this.PP.HandleComment(Tok, this.$CommentSourceRange(TokenLoc, SourceLocation.$getLocWithOffset((int)TokenLoc, (int)Len)))) continue;
            return true;
        } while (!this.inKeepCommentMode());
        Tok.startToken();
        Tok.setKind(TKind);
        Tok.setFlag(TFlags);
        Tok.setLocation(TokenLoc);
        Tok.setLength(Len);
        if (Tok.isLiteral()) {
            Tok.setLiteralData(this.PTHMgr.SpellingBase.$array(), this.PTHMgr.SpellingBase.$index() + IdentifierID);
            this.CheckLiteralToken(Tok, TKind, TokenLoc, Len);
        } else if (IdentifierID != 0) {
            this.MIOpt.ReadToken();
            IdentifierInfo II = this.PTHMgr.GetIdentifierInfo(IdentifierID - 1);
            Tok.setIdentifierInfo(II);
            Tok.setKind(II.getTokenID());
            if (!this.LexingRawMode && II.isHandleIdentifierCase()) {
                return this.PP.HandleIdentifier(Tok);
            }
            return true;
        }
        if (TKind == '\u0001') {
            this.EofToken.$assign(Tok);
            assert (!this.LexingRawMode);
            if (this.ParsingPreprocessorDirective) {
                assert (this.PreprocessorDirectiveHashLoc == Tok.$getLocation()) : "only incomplete file is expected";
                this.PreprocessorDirectiveEodLoc = this.PreprocessorDirectiveHashLoc;
                this.ParsingPreprocessorDirective = false;
                this.CurPtr -= 12;
                return true;
            }
            return this.LexEndOfFile(Tok);
        }
        if (TKind == 'A' && Tok.isAtStartOfLine()) {
            this.LastHashTokPtr = this.CurPtr - 12;
            this.PreprocessorDirectiveHashLoc = Tok.$getLocation();
            assert (!this.LexingRawMode);
            this.PP.HandleDirective(Tok);
            return false;
        }
        if (TKind == '\u0002') {
            assert (this.ParsingPreprocessorDirective);
            this.ParsingPreprocessorDirective = false;
            this.PreprocessorDirectiveEodLoc = Tok.$getLocation();
            this.resetExtendedTokenMode();
            return true;
        }
        if (!commentTok) {
            this.MIOpt.ReadToken();
        }
        return true;
    }

    public void getEOF(Token Tok) {
        assert (this.EofToken.is('\u0001'));
        Tok.$assign(this.EofToken);
    }

    protected void DiscardToEndOfLine() {
        assert (this.ParsingPreprocessorDirective && !this.ParsingFilename) : "Must be in a preprocessing directive!";
        this.ReadToEndOfLine(null);
    }

    @Override
    protected void ReadToEndOfLine(SmallString Result) {
        char Kind2;
        assert (this.ParsingPreprocessorDirective && !this.ParsingFilename) : "Must be in a preprocessing directive!";
        int p = this.CurPtr;
        int CurrentLoc = this.getCurCharSourceLocation();
        do {
            Kind2 = Unsigned.$uchar2ushort((byte)this.TokBuf.$at(p));
            assert (Kind2 != '\u0001') : "must be EOD before EOF at " + p;
            assert ((this.TokBuf.$at(p + NativeType.sizeof$uint8()) & 1) == 0) : "Can not have token with start-of-line at " + p + " before EOD";
            p += 12;
        } while (Kind2 != '\u0002');
        this.ParsingPreprocessorDirective = false;
        assert (Kind2 == '\u0002') : "Called not from pp-directive?";
        assert (this.TokBuf.$at(p - 12) == 2) : "incorrectly shifted after EOD?" + p;
        int FileOffset = llvm.support.endian.read_uint32((char.ptr)this.TokBuf, (int)(p - NativeType.sizeof$uint32()), (llvm.support.endianness)llvm.support.endianness.little, (int)0);
        this.PreprocessorDirectiveEodLoc = SourceLocation.$getLocWithOffset((int)this.FileStartLoc, (int)FileOffset);
        if (Result != null) {
            CharSourceRange Range = CharSourceRange.getCharRange((int)CurrentLoc, (int)this.PreprocessorDirectiveEodLoc);
            StringRef sourceText = Lexer.getSourceText(Range, this.PP.getSourceManager(), this.PP.getLangOpts());
            Result.append(sourceText);
        }
        this.CurPtr = p;
    }

    public int isNextPPTokenLParen() {
        char x = Unsigned.$uchar2ushort((byte)this.TokBuf.$at(this.CurPtr));
        return x == '\u0001' ? 2 : (x == '\u0015' ? 1 : 0);
    }

    @Override
    public void IndirectLex(Token Result) {
        this.Lex(Result);
    }

    @Override
    protected int getCurCharSourceLocation() {
        if (this.CurPtr == 0) {
            return this.FileStartLoc;
        }
        int OffsetPtr = this.CurPtr - 4;
        int LengthPtr = this.CurPtr - 12 + 1 + 1;
        int Offset = llvm.support.endian.read_uint32((char.ptr)this.TokBuf, (int)OffsetPtr, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
        int Len = llvm.support.endian.read_uint16((char.ptr)this.TokBuf, (int)LengthPtr, (llvm.support.endianness)llvm.support.endianness.little, (int)0) & 0xFF;
        return SourceLocation.$getLocWithOffset((int)this.FileStartLoc, (int)(Offset + Len));
    }

    @Override
    public int getFileLoc() {
        return this.FileStartLoc;
    }

    final boolean SkipBlock() {
        boolean isEndif;
        int TableIdx;
        int HashEntryI;
        assert (this.PPCond != null) : "No cached PP conditional information.";
        assert (this.CurPPCondPtr != -1) : "No cached PP conditional information.";
        assert (this.LastHashTokPtr != -1) : "No known '#' token.";
        do {
            int Offset = llvm.support.endian.read_uint32((char.ptr)this.PPCond, (int)this.CurPPCondPtr, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
            this.CurPPCondPtr += NativeType.sizeof$uint32();
            TableIdx = llvm.support.endian.read_uint32((char.ptr)this.PPCond, (int)this.CurPPCondPtr, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
            this.CurPPCondPtr += NativeType.sizeof$uint32();
            HashEntryI = Offset;
            if (HashEntryI >= this.LastHashTokPtr || TableIdx == 0) continue;
            int NextPPCondPtr = TableIdx * (NativeType.sizeof$uint32() * 2);
            assert (NextPPCondPtr >= this.CurPPCondPtr);
            int HashEntryJ = llvm.support.endian.read_uint32((char.ptr)this.PPCond, (int)NextPPCondPtr, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
            NextPPCondPtr += NativeType.sizeof$uint32();
            if (HashEntryJ > this.LastHashTokPtr) continue;
            HashEntryI = HashEntryJ;
            TableIdx = llvm.support.endian.read_uint32((char.ptr)this.PPCond, (int)NextPPCondPtr, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
            this.CurPPCondPtr = NextPPCondPtr += NativeType.sizeof$uint32();
        } while (HashEntryI < this.LastHashTokPtr);
        assert (HashEntryI == this.LastHashTokPtr) : "No PP-cond entry found for '#'";
        assert (TableIdx != 0) : "No jumping from #endifs.";
        int NextPPCondPtr = TableIdx * (NativeType.sizeof$uint32() * 2);
        assert (NextPPCondPtr >= this.CurPPCondPtr);
        this.CurPPCondPtr = NextPPCondPtr;
        HashEntryI = llvm.support.endian.read_uint32((char.ptr)this.PPCond, (int)NextPPCondPtr, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
        int NextIdx = llvm.support.endian.read_uint32((char.ptr)this.PPCond, (int)(NextPPCondPtr += NativeType.sizeof$uint32()), (llvm.support.endianness)llvm.support.endianness.little, (int)0);
        boolean bl = isEndif = NextIdx == 0;
        assert (!this.ParsingPreprocessorDirective);
        this.ParsingPreprocessorDirective = true;
        byte hashKind = this.TokBuf.$at(HashEntryI);
        assert (hashKind == 65 || hashKind == 1) : "only hash or EOF for unterminated conditional directive is expected " + tok.getTokenName((char)Unsigned.$uint2ushort((int)(hashKind & 0xFF)));
        int FileOffset = llvm.support.endian.read_uint32((char.ptr)this.TokBuf, (int)(HashEntryI + NativeType.sizeof$uint32() + NativeType.sizeof$uint32()), (llvm.support.endianness)llvm.support.endianness.little, (int)0);
        this.PreprocessorDirectiveHashLoc = SourceLocation.$getLocWithOffset((int)this.FileStartLoc, (int)FileOffset);
        if (hashKind == 1) {
            this.LastHashTokPtr = HashEntryI;
            this.CurPtr = HashEntryI;
            assert (isEndif) : "incomplete files expected to be finished with fake endif";
            return true;
        }
        if (this.CurPtr > HashEntryI) {
            assert (this.CurPtr == HashEntryI + 12);
            assert (false) : "investigate the usecase, but we are exactly after hash, so this is OK state";
            if (!isEndif) {
                this.LastHashTokPtr = HashEntryI;
            }
            return isEndif;
        }
        this.LastHashTokPtr = this.CurPtr = HashEntryI;
        assert ((short)(this.TokBuf.$at(this.CurPtr) & 0xFF) == 65);
        this.CurPtr += 12;
        if (isEndif) {
            // empty if block
        }
        return isEndif;
    }

    @Override
    protected void cutOffLexing() {
        char Kind2;
        int p = this.CurPtr;
        while ((Kind2 = Unsigned.$uchar2ushort((byte)this.TokBuf.$at(p))) != '\u0001') {
            p += 12;
        }
        this.CurPtr = p;
    }

    private void CheckLiteralToken(Token Tok, char TKind, int TokenLoc, int Len) {
        if (this.LexingRawMode) {
            return;
        }
        assert (Tok.getKind() == TKind) : tok.getTokenName((char)TKind) + " vs. " + Tok;
        assert (Tok.$getLocation() == TokenLoc) : SourceLocation.getFromRawEncoding((int)TokenLoc) + " vs. " + Tok;
        assert (Tok.getLength() == Len) : Len + " vs " + Tok;
        LangOptions LangOpts = this.PP.getLangOpts();
        if (tok.isCharLiteral((char)TKind)) {
            this.CheckCharConstantToken(LangOpts, TKind, TokenLoc, Tok, Len);
        } else if (tok.isStringLiteral((char)TKind)) {
            this.CheckStringLiteralToken(LangOpts, TKind, TokenLoc, Tok, Len);
        } else if (Tok.isIncomplete()) {
            NativeTrace.assertTrueInConsole((boolean)false, (String)"unexpected incomplete token", (Object)Tok);
        }
    }

    private void CheckCharConstantToken(LangOptions LangOpts, char TKind, int TokenLoc, Token Tok, int Len) {
        assert (!this.LexingRawMode);
        assert (Tok.getKind() == TKind) : tok.getTokenName((char)TKind) + " vs. " + Tok;
        assert (Tok.$getLocation() == TokenLoc) : SourceLocation.getFromRawEncoding((int)TokenLoc) + " vs. " + Tok;
        assert (Tok.getLength() == Len) : Len + " vs " + Tok;
        assert (LangOpts == this.PP.getLangOpts());
        if (!this.isLexingRawMode()) {
            if (TKind == '\u000b' || TKind == '\f') {
                this.PP.Diag(TokenLoc, LangOpts.CPlusPlus ? 962 : 945).$destroy();
            } else if (TKind == '\n') {
                this.PP.Diag(TokenLoc, 952).$destroy();
            }
        }
        if (Tok.isIncomplete() && !this.isLexingRawMode() && !LangOpts.AsmPreprocessor) {
            boolean empty = false;
            if (Tok.getLiteralData().$at(Len - 1) == 39) {
                int SglQuoteStartIdx;
                for (SglQuoteStartIdx = 0; SglQuoteStartIdx < Len - 1 && Tok.getLiteralData().$at(SglQuoteStartIdx) != 39; ++SglQuoteStartIdx) {
                }
                boolean bl = empty = SglQuoteStartIdx == Len - 2;
            }
            if (empty) {
                this.PP.Diag(TokenLoc, 866).$destroy();
            } else {
                BasicClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)this.PP.Diag(TokenLoc, 905), (int)0).$destroy();
            }
        }
    }

    private void CheckStringLiteralToken(LangOptions LangOpts, char Kind2, int TokenLoc, Token Tok, int Len) {
        assert (!this.LexingRawMode);
        assert (Tok.getKind() == Kind2) : tok.getTokenName((char)Kind2) + " vs. " + Tok;
        assert (Tok.$getLocation() == TokenLoc) : SourceLocation.getFromRawEncoding((int)TokenLoc) + " vs. " + Tok;
        assert (Tok.getLength() == Len) : Len + " vs " + Tok;
        assert (LangOpts == this.PP.getLangOpts());
        if (Kind2 == '\u0010' || Kind2 == '\u0011' || Kind2 == '\u0012') {
            this.PP.Diag(TokenLoc, LangOpts.CPlusPlus ? 962 : 945).$destroy();
        }
        if (Tok.isIncomplete() && !LangOpts.AsmPreprocessor) {
            BasicClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)this.PP.Diag(TokenLoc, 905), (int)1).$destroy();
        }
    }

    static {
        int expected = 12;
        assert (12 == expected) : "expected " + expected + " vs. " + 12;
    }
}

