/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.InsertRecordDialog;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class DataViewActionHandler {
    private final DataViewPageContext dataPage;
    private final SQLExecutionHelper execHelper;
    private final DataViewUI dataViewUI;
    private final DataView dataView;

    DataViewActionHandler(DataViewUI dataViewUI, DataView dataView, DataViewPageContext pageContext) {
        this.dataView = dataView;
        this.dataViewUI = dataViewUI;
        this.dataPage = pageContext;
        this.execHelper = dataView.getSQLExecutionHelper();
    }

    private boolean rejectModifications() {
        String msg;
        boolean doCalculation = true;
        if (this.dataViewUI.isCommitEnabled() && DataViewActionHandler.showYesAllDialog(msg = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_commit_changes"), NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_navigation")).equals(NotifyDescriptor.NO_OPTION)) {
            doCalculation = false;
        }
        return doCalculation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelEditPerformed(boolean selectedOnly) {
        DataView dataView = this.dataView;
        synchronized (dataView) {
            if (selectedOnly) {
                DataViewTableUI rsTable = this.dataViewUI.getDataViewTableUI();
                DataViewTableUIModel updatedRowCtx = this.dataPage.getModel();
                int[] rows = rsTable.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    int row = rsTable.convertRowIndexToModel(rows[i]);
                    updatedRowCtx.removeUpdateForSelectedRow(row, true);
                }
                if (updatedRowCtx.getUpdateKeys().isEmpty()) {
                    this.dataViewUI.setCancelEnabled(false);
                    this.dataViewUI.setCommitEnabled(false);
                }
            } else {
                this.dataPage.getModel().removeAllUpdates(true);
                this.dataViewUI.setCancelEnabled(false);
                this.dataViewUI.setCommitEnabled(false);
            }
        }
    }

    void updateActionPerformed() {
        if (this.rejectModifications()) {
            int pageSize = this.dataViewUI.getPageSize();
            this.dataPage.setPageSize(pageSize);
            org.netbeans.modules.db.dataview.api.DataViewPageContext.setStoredPageSize(pageSize);
            this.dataPage.first();
            this.execHelper.executeQueryOffEDT();
        }
    }

    void firstActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.first();
            this.execHelper.executeQueryOffEDT();
        }
    }

    void previousActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.previous();
            this.execHelper.executeQueryOffEDT();
        }
    }

    void nextActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.next();
            this.execHelper.executeQueryOffEDT();
        }
    }

    void commitActionPerformed(boolean selectedOnly) {
        assert (this.dataPage.getTableMetaData().getTableCount() == 1) : "Only one table allowed in resultset if update is invoked";
        if (this.dataViewUI.isDirty()) {
            this.execHelper.executeUpdateRow(this.dataPage.getTableMetaData().getTable(0), this.dataViewUI.getDataViewTableUI(), selectedOnly);
        }
    }

    void insertActionPerformed() {
        DBTable table = this.dataPage.getTableMetaData().getTable(0);
        InsertRecordDialog dialog = new InsertRecordDialog(this.dataView, this.dataPage, table);
        dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
    }

    void truncateActionPerformed() {
        assert (this.dataPage.getTableMetaData().getTableCount() == 1) : "Only one table allowed in resultset if delete is invoked";
        String confirmMsg = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_truncate_table") + this.dataPage.getTableMetaData().getTable(0).getDisplayName();
        if (DataViewActionHandler.showYesAllDialog(confirmMsg, confirmMsg).equals(NotifyDescriptor.YES_OPTION)) {
            this.execHelper.executeTruncate(this.dataPage, this.dataPage.getTableMetaData().getTable(0));
        }
    }

    void deleteRecordActionPerformed() {
        assert (this.dataPage.getTableMetaData().getTableCount() == 1) : "Only one table allowed in resultset if delete is invoked";
        DataViewTableUI rsTable = this.dataViewUI.getDataViewTableUI();
        if (rsTable.getSelectedRowCount() == 0) {
            String msg = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_select_delete_rows");
            this.dataView.setInfoStatusText(msg);
        } else {
            String msg = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_permanent_delete");
            if (DataViewActionHandler.showYesAllDialog(msg, NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_delete")).equals(NotifyDescriptor.YES_OPTION)) {
                DBTable table = this.dataPage.getTableMetaData().getTable(0);
                this.execHelper.executeDeleteRow(this.dataPage, table, rsTable);
            }
        }
    }

    void refreshActionPerformed() {
        this.execHelper.executeQueryOffEDT();
    }

    private static Object showYesAllDialog(Object msg, String title) {
        NotifyDescriptor nd = new NotifyDescriptor(msg, title, 0, 3, null, NotifyDescriptor.NO_OPTION);
        DialogDisplayer.getDefault().notify(nd);
        return nd.getValue();
    }
}

