/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ResultSetTableModel
extends AbstractTableModel {
    private boolean editable = false;
    private DBColumn[] columns;
    private final List<Object[]> data = new ArrayList<Object[]>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    protected static Class<? extends Object> getTypeClass(DBColumn col) {
        int colType = col.getJdbcType();
        if (colType == -7 && col.getPrecision() <= 1) {
            colType = 16;
        }
        switch (colType) {
            case 16: {
                return Boolean.class;
            }
            case 92: {
                return Time.class;
            }
            case 91: {
                return Date.class;
            }
            case -100: 
            case 93: {
                return Timestamp.class;
            }
            case -5: {
                return BigInteger.class;
            }
            case 8: {
                return Double.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -6: 
            case 4: 
            case 5: {
                return Long.class;
            }
            case -15: 
            case -9: 
            case -8: 
            case 1: 
            case 12: {
                return String.class;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return Blob.class;
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                return Clob.class;
            }
        }
        return Object.class;
    }

    public ResultSetTableModel(DBColumn[] columns) {
        this.columns = columns;
    }

    public void setColumns(DBColumn[] columns) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        this.data.clear();
        this.columns = columns;
        this.fireTableStructureChanged();
    }

    public DBColumn[] getColumns() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    public void setEditable(boolean editable) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        boolean old = this.editable;
        this.editable = editable;
        this.pcs.firePropertyChange("editable", old, editable);
    }

    public boolean isEditable() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        return this.editable;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        if (!this.editable) {
            return false;
        }
        DBColumn col = this.columns[column];
        return !col.isGenerated() && col.isEditable();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        Object oldVal = this.getValueAt(row, col);
        if (this.noUpdateRequired(oldVal, value)) {
            return;
        }
        try {
            if (!DataViewUtils.isSQLConstantString(value, this.columns[col])) {
                value = DBReadWriteHelper.validate(value, this.columns[col]);
            }
            this.data.get((int)row)[col] = value;
            this.fireTableCellUpdated(row, col);
        }
        catch (Exception dbe) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)dbe.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    public Class<? extends Object> getColumnClass(int columnIndex) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        if (this.columns[columnIndex] == null) {
            return super.getColumnClass(columnIndex);
        }
        return ResultSetTableModel.getTypeClass(this.columns[columnIndex]);
    }

    public DBColumn getColumn(int columnIndex) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        return this.columns[columnIndex];
    }

    @Override
    public int getColumnCount() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        return this.columns.length;
    }

    public String getColumnTooltip(int columnIndex) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        return DataViewUtils.getColumnToolTip(this.columns[columnIndex]);
    }

    @Override
    public String getColumnName(int columnIndex) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        String displayName = this.columns[columnIndex].getDisplayName();
        return displayName != null ? displayName : "COL_" + columnIndex;
    }

    protected boolean noUpdateRequired(Object oldVal, Object value) {
        if (oldVal == null && value == null) {
            return true;
        }
        if (oldVal != null) {
            return oldVal.equals(value);
        }
        return false;
    }

    @Override
    public int getRowCount() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        Object[] dataRow = this.data.get(rowIndex);
        return dataRow[columnIndex];
    }

    public Object[] getRowData(int rowIndex) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        Object[] dataRow = this.data.get(rowIndex);
        return Arrays.copyOf(dataRow, dataRow.length);
    }

    public void setData(List<Object[]> data) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        this.data.clear();
        for (Object[] dataRow : data) {
            this.data.add(Arrays.copyOf(dataRow, dataRow.length));
        }
        this.fireTableDataChanged();
    }

    public List<Object[]> getData() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Object[] dataRow : this.data) {
            result.add(Arrays.copyOf(dataRow, dataRow.length));
        }
        return result;
    }

    public void addRow(Object[] dataRow) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        int addedRowIndex = this.data.size();
        this.data.add(Arrays.copyOf(dataRow, dataRow.length));
        this.fireTableRowsInserted(addedRowIndex, addedRowIndex);
    }

    public void removeRow(int row) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        this.data.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void clear() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not on EDT";
        this.data.clear();
        this.fireTableDataChanged();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

