/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

public final class BitFieldsUtils {
    private BitFieldsUtils() {
    }

    public static int setLastBits32(int flagsField, int LastBits, int Value) {
        int LHSMask;
        assert (LastBits <= 32) : LastBits;
        int n = LHSMask = LastBits == 32 ? 0 : -1 << LastBits;
        assert ((Value & LHSMask) == 0) : "using more than " + LastBits + " in " + Integer.toBinaryString(Value);
        flagsField = BitFieldsUtils.setLastMaskedBits32(flagsField, LHSMask, Value);
        assert (BitFieldsUtils.getLastBits32(flagsField, LastBits) == Value) : Value + " vs " + BitFieldsUtils.getLastBits32(flagsField, LastBits);
        return flagsField;
    }

    public static long setLastBits64(long flagsField, int LastBits, long Value) {
        long LHSMask;
        assert (LastBits <= 64) : LastBits;
        long l = LHSMask = LastBits == 64 ? 0L : -1L << LastBits;
        assert ((Value & LHSMask) == 0L) : "using more than " + LastBits + " in " + Long.toBinaryString(Value);
        flagsField = BitFieldsUtils.setLastMaskedBits64(flagsField, LHSMask, Value);
        assert (BitFieldsUtils.getLastBits64(flagsField, LastBits) == Value) : Value + " vs " + BitFieldsUtils.getLastBits64(flagsField, LastBits);
        return flagsField;
    }

    public static int setLastMaskedBits32(int flagsField, int ClearOldValueMask, int Value) {
        assert ((Value & ClearOldValueMask) == 0) : "using more bits than in " + ClearOldValueMask + " for " + Integer.toBinaryString(Value);
        flagsField = flagsField & ClearOldValueMask | Value;
        assert (BitFieldsUtils.getLastMaskedBits32(flagsField, ~ClearOldValueMask) == Value) : Value + " vs " + BitFieldsUtils.getLastMaskedBits32(flagsField, ~ClearOldValueMask);
        return flagsField;
    }

    public static long setLastMaskedBits64(long flagsField, long ClearOldValueMask, long Value) {
        assert ((Value & ClearOldValueMask) == 0L) : "using more bits than in " + ClearOldValueMask + " for " + Long.toBinaryString(Value);
        flagsField = flagsField & ClearOldValueMask | Value;
        assert (BitFieldsUtils.getLastMaskedBits64(flagsField, ClearOldValueMask ^ 0xFFFFFFFFFFFFFFFFL) == Value) : Value + " vs " + BitFieldsUtils.getLastMaskedBits64(flagsField, ClearOldValueMask ^ 0xFFFFFFFFFFFFFFFFL);
        return flagsField;
    }

    public static int setMiddleBits32(int flagsField, int FirstBitIndex, int BitsNum, int Value) {
        int lastBits = FirstBitIndex - BitsNum;
        assert (lastBits >= 0) : " FirstBitIndex " + FirstBitIndex + " less than BitsNum " + BitsNum;
        int afterLastBitsValue = lastBits == 0 ? 0 : BitFieldsUtils.getLastBits32(flagsField, lastBits);
        flagsField = BitFieldsUtils.setLastBits32(flagsField, FirstBitIndex, Value << lastBits) | afterLastBitsValue;
        assert (BitFieldsUtils.getMiddleBits32(flagsField, FirstBitIndex, BitsNum) == Value) : Value + " vs " + BitFieldsUtils.getMiddleBits32(flagsField, FirstBitIndex, BitsNum);
        return flagsField;
    }

    public static long setMiddleBits64(long flagsField, int FirstBitIndex, int BitsNum, long Value) {
        int lastBits = FirstBitIndex - BitsNum;
        assert (lastBits >= 0) : " FirstBitIndex " + FirstBitIndex + " less than BitsNum " + BitsNum;
        long afterLastBitsValue = lastBits == 0 ? 0L : BitFieldsUtils.getLastBits64(flagsField, lastBits);
        flagsField = BitFieldsUtils.setLastBits64(flagsField, FirstBitIndex, Value << lastBits) | afterLastBitsValue;
        assert (BitFieldsUtils.getMiddleBits64(flagsField, FirstBitIndex, BitsNum) == Value) : Value + " vs " + BitFieldsUtils.getMiddleBits64(flagsField, FirstBitIndex, BitsNum);
        return flagsField;
    }

    public static int setBit32(int flagsField, int Bit, boolean val) {
        assert (Bit <= 32) : Bit;
        int Mask = 1 << Bit;
        flagsField = BitFieldsUtils.setMaskedBit32(flagsField, Mask, val);
        assert (BitFieldsUtils.getBit32(flagsField, Bit) == val) : val + " vs " + BitFieldsUtils.getBit32(flagsField, Bit);
        return flagsField;
    }

    public static long setBit64(long flagsField, int Bit, boolean val) {
        assert (Bit <= 64) : Bit;
        long Mask = 1L << Bit;
        flagsField = BitFieldsUtils.setMaskedBit64(flagsField, Mask, val);
        assert (BitFieldsUtils.getBit64(flagsField, Bit) == val) : val + " vs " + BitFieldsUtils.getBit64(flagsField, Bit);
        return flagsField;
    }

    public static int setMaskedBit32(int flagsField, int Mask, boolean val) {
        assert ((Mask & Mask - 1) == 0) : "must have only one bit" + Integer.toBinaryString(Mask);
        flagsField = val ? (flagsField |= Mask) : (flagsField &= ~Mask);
        assert (BitFieldsUtils.getMaskedBit32(flagsField, Mask) == val) : val + " vs " + BitFieldsUtils.getMaskedBit32(flagsField, Mask);
        return flagsField;
    }

    public static long setMaskedBit64(long flagsField, long Mask, boolean val) {
        assert ((Mask & Mask - 1L) == 0L) : "must have only one bit" + Long.toBinaryString(Mask);
        flagsField = val ? (flagsField |= Mask) : (flagsField &= Mask ^ 0xFFFFFFFFFFFFFFFFL);
        assert (BitFieldsUtils.getMaskedBit64(flagsField, Mask) == val) : val + " vs " + BitFieldsUtils.getMaskedBit64(flagsField, Mask);
        return flagsField;
    }

    public static int getLastBits32(int flagsField, int LastBits) {
        assert (LastBits <= 32) : LastBits;
        int Mask = LastBits == 32 ? -1 : (1 << LastBits) - 1;
        return BitFieldsUtils.getLastMaskedBits32(flagsField, Mask);
    }

    public static long getLastBits64(long flagsField, int LastBits) {
        assert (LastBits <= 64) : LastBits;
        long Mask = LastBits == 64 ? -1L : (1L << LastBits) - 1L;
        return BitFieldsUtils.getLastMaskedBits64(flagsField, Mask);
    }

    public static int getLastMaskedBits32(int flagsField, int MaskForLastBits) {
        return flagsField & MaskForLastBits;
    }

    public static long getLastMaskedBits64(long flagsField, long MaskForLastBits) {
        return flagsField & MaskForLastBits;
    }

    public static int getMiddleBits32(int flagsField, int FirstBitIndex, int BitsNum) {
        int BitsAfter = FirstBitIndex - BitsNum;
        assert (BitsAfter >= 0) : " FirstBitIndex " + FirstBitIndex + " less than BitsNum " + BitsNum;
        int Value = BitFieldsUtils.getLastBits32(flagsField >>> BitsAfter, BitsNum);
        return Value;
    }

    public static long getMiddleBits64(long flagsField, int FirstBitIndex, int BitsNum) {
        int BitsAfter = FirstBitIndex - BitsNum;
        assert (BitsAfter >= 0) : " FirstBitIndex " + FirstBitIndex + " less than BitsNum " + BitsNum;
        long Value = BitFieldsUtils.getLastBits64(flagsField >>> BitsAfter, BitsNum);
        return Value;
    }

    public static boolean getBit32(int flagsField, int Bit) {
        assert (Bit <= 32) : Bit;
        int Mask = 1 << Bit;
        return (flagsField & Mask) == Mask;
    }

    public static boolean getBit64(long flagsField, int Bit) {
        assert (Bit <= 64) : Bit;
        long Mask = 1L << Bit;
        return (flagsField & Mask) == Mask;
    }

    public static boolean getMaskedBit32(int flagsField, int Mask) {
        assert ((Mask & Mask - 1) == 0) : "must have only one bit" + Integer.toBinaryString(Mask);
        return (flagsField & Mask) == Mask;
    }

    public static boolean getMaskedBit64(long flagsField, long Mask) {
        assert ((Mask & Mask - 1L) == 0L) : "must have only one bit" + Long.toBinaryString(Mask);
        return (flagsField & Mask) == Mask;
    }
}

