/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.fs.DirEntryList;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemoteLinkBase;
import org.openide.filesystems.FileLock;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class RemoteLinkChild
extends RemoteLinkBase {
    private final RemoteFileObjectBase delegate;
    private static final boolean NO_CYCLIC_LINKS = RemoteFileSystemUtils.getBoolean("remote.block.cyclic.links", true);

    RemoteLinkChild(RemoteFileObject wrapper, RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteLinkBase parent, String remotePath, RemoteFileObjectBase delegate) {
        super(wrapper, fileSystem, execEnv, parent, remotePath);
        Parameters.notNull((CharSequence)"delegate", (Object)delegate);
        this.delegate = delegate;
    }

    @Override
    protected void initListeners(boolean add) {
        if (add) {
            if (NO_CYCLIC_LINKS && this.hasCycle()) {
                this.setFlag((byte)32, true);
            }
            this.delegate.addFileChangeListener(this);
        } else {
            this.delegate.removeFileChangeListener(this);
        }
    }

    private boolean hasCycle() {
        RemoteFileObjectBase dlg = this.getCanonicalDelegate();
        RemoteFileObjectBase p = this.getParent();
        while (p instanceof RemoteLinkChild) {
            if (p == dlg) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    @Override
    public RemoteFileObject[] getChildren() {
        if (this.getFlag((byte)32)) {
            return new RemoteFileObject[0];
        }
        return super.getChildren();
    }

    @Override
    public RemoteFileObject getFileObject(String relativePath, Set<String> antiLoop) {
        if (this.getFlag((byte)32)) {
            return null;
        }
        return super.getFileObject(relativePath, antiLoop);
    }

    @Override
    public RemoteFileObjectBase getCanonicalDelegate() {
        return this.delegate;
    }

    @Override
    protected RemoteFileObjectBase getDelegateImpl() {
        return this.delegate;
    }

    @Override
    protected String getDelegateNormalizedPath() {
        return this.delegate.getPath();
    }

    @Override
    public FileInfoProvider.StatInfo.FileType getType() {
        return this.delegate.getType();
    }

    @Override
    public boolean isValid() {
        if (this.isValidFastWithParents()) {
            return this.delegate.isValid();
        }
        return false;
    }

    @Override
    protected void postDeleteOrCreateChild(RemoteFileObject child, DirEntryList entryList) {
        RemoteFileObjectBase canonicalDelegate = this.getCanonicalDelegate();
        if (canonicalDelegate != null) {
            canonicalDelegate.postDeleteOrCreateChild(child, entryList);
        }
    }

    @Override
    protected DirEntryList deleteImpl(FileLock lock) throws IOException {
        RemoteFileObjectBase canonicalDelegate = this.getCanonicalDelegate();
        if (canonicalDelegate != null) {
            return canonicalDelegate.deleteImpl(lock);
        }
        throw new FileNotFoundException(this.getDisplayName() + " does not exist");
    }

    @Override
    protected void renameImpl(FileLock lock, String name, String ext, RemoteFileObjectBase orig) throws IOException {
        RemoteFileObjectBase dlg = this.getCanonicalDelegate();
        if (dlg == null) {
            throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteLinkChild.class, (String)"EXC_CanNotRenameFO", (Object)this.getDisplayName()));
        }
        dlg.renameImpl(lock, name, ext, orig);
    }
}

