/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;

public class MagicMethodDeclarationInfo
extends ASTNodeInfo<PHPDocMethodTag> {
    private final List<ParameterElement> parameters = new LinkedList<ParameterElement>();
    private String returnType;
    private String methodName;
    private int offset;
    private int typeOffset;

    MagicMethodDeclarationInfo(PHPDocMethodTag node) {
        super(node);
        String[] methodNames;
        String[] parts = node.getValue().trim().split("\\s+", 3);
        if (parts.length == 1 || parts.length > 0 && parts[0].trim().indexOf("(") > 0) {
            this.returnType = "void";
            methodNames = parts[0].split("[(, ]", 2);
            if (methodNames.length > 0) {
                this.methodName = methodNames[0];
                this.offset = ((PHPDocMethodTag)this.getOriginalNode()).getStartOffset() + PHPDocTag.Type.METHOD.toString().length() + 1 + node.getValue().indexOf(this.methodName);
            }
        } else if (parts.length >= 2) {
            methodNames = parts[1].split("[(, ]", 2);
            if (parts[0].length() > 0 && methodNames.length > 0) {
                this.returnType = parts[0];
                this.methodName = methodNames[0];
                this.offset = ((PHPDocMethodTag)this.getOriginalNode()).getStartOffset() + PHPDocTag.Type.METHOD.toString().length() + 1 + node.getValue().indexOf(this.methodName);
                this.typeOffset = ((PHPDocMethodTag)this.getOriginalNode()).getStartOffset() + PHPDocTag.Type.METHOD.toString().length() + 1 + node.getValue().indexOf(this.returnType);
            }
        }
        for (PHPDocVarTypeTag parameter : node.getParameters()) {
            LinkedList<QualifiedName> names = new LinkedList<QualifiedName>();
            for (PHPDocTypeNode type : parameter.getTypes()) {
                QualifiedName qualifiedName = QualifiedName.create(type.getValue());
                names.add(qualifiedName);
            }
            Set<TypeResolver> types = TypeResolverImpl.forNames(names);
            String name = parameter.getVariable().getValue();
            String[] split = parameter.getValue().split("=");
            String defaultValue = null;
            if (split.length > 1) {
                defaultValue = split[1].trim();
            }
            boolean isMandatory = defaultValue == null;
            boolean isReference = name.startsWith("&");
            boolean isVariadic = name.startsWith("...");
            this.parameters.add(new ParameterElementImpl(name, defaultValue, 0, types, isMandatory, true, isReference, isVariadic));
        }
    }

    @CheckForNull
    public static MagicMethodDeclarationInfo create(PHPDocMethodTag node) {
        MagicMethodDeclarationInfo retval = new MagicMethodDeclarationInfo(node);
        return retval.methodName != null && retval.returnType != null ? retval : null;
    }

    public ASTNodeInfo<PHPDocMethodTag> getClassInfo() {
        return new ASTNodeInfo<PHPDocMethodTag>((PHPDocMethodTag)this.getOriginalNode()){

            @Override
            public String getName() {
                return MagicMethodDeclarationInfo.this.getReturnType();
            }

            @Override
            public OffsetRange getRange() {
                return MagicMethodDeclarationInfo.this.getTypeRange();
            }

            @Override
            public ASTNodeInfo.Kind getKind() {
                return ASTNodeInfo.Kind.CLASS;
            }

            @Override
            public QualifiedName getQualifiedName() {
                return QualifiedName.create(this.getName());
            }

            @Override
            public PhpElementKind getPhpElementKind() {
                return PhpElementKind.CLASS;
            }
        };
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return ASTNodeInfo.Kind.METHOD;
    }

    @Override
    public String getName() {
        return this.getQualifiedName().toName().toString();
    }

    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.create(this.methodName).toName();
    }

    @Override
    public OffsetRange getRange() {
        return new OffsetRange(this.offset, this.offset + this.getName().length());
    }

    public OffsetRange getTypeRange() {
        return new OffsetRange(this.typeOffset, this.typeOffset + this.getReturnType().length());
    }

    public List<? extends ParameterElement> getParameters() {
        return new ArrayList<ParameterElement>(this.parameters);
    }

    public PhpModifiers getAccessModifiers() {
        return PhpModifiers.fromBitMask(1);
    }
}

