/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.options;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AnnotationExpression {
    private String urlExp;
    private String annotationExp;
    private final Pattern urlPattern;

    public AnnotationExpression(String urlExp, String annotationExp) {
        this.urlExp = urlExp;
        this.annotationExp = annotationExp;
        this.urlPattern = Pattern.compile(urlExp);
    }

    public String getUrlExp() {
        return this.urlExp;
    }

    public String getAnnotationExp() {
        return this.annotationExp;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationExpression other = (AnnotationExpression)obj;
        if (!(this.urlExp == other.urlExp || this.urlExp != null && this.urlExp.equals(other.urlExp))) {
            return false;
        }
        return this.annotationExp == other.annotationExp || this.annotationExp != null && this.annotationExp.equals(other.annotationExp);
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public Pattern getUrlPatern() {
        return this.urlPattern;
    }

    void setUrlExp(String urlExp) {
        this.urlExp = urlExp;
    }

    void setAnnotationExp(String annotationExp) {
        this.annotationExp = annotationExp;
    }

    public String getCopyName(String url) {
        Matcher m = this.getUrlPatern().matcher(url);
        if (m.matches()) {
            String ae = this.getAnnotationExp();
            StringBuilder copyName = new StringBuilder();
            StringBuilder groupStr = new StringBuilder();
            boolean inGroup = false;
            for (int i = 0; i < ae.length(); ++i) {
                char c = ae.charAt(i);
                if (c == '\\') {
                    inGroup = true;
                    continue;
                }
                if (inGroup) {
                    if (Character.isDigit(c)) {
                        groupStr.append(c);
                        continue;
                    }
                    if (groupStr.length() > 0) {
                        try {
                            int group = Integer.parseInt(groupStr.toString());
                            copyName.append(m.group(group));
                        }
                        catch (Exception e) {
                            copyName.append('\\');
                            copyName.append((CharSequence)groupStr);
                        }
                        groupStr = new StringBuilder();
                    } else {
                        copyName.append('\\');
                        copyName.append(c);
                    }
                    inGroup = false;
                    continue;
                }
                copyName.append(c);
            }
            if (groupStr.length() > 0) {
                try {
                    int group = Integer.parseInt(groupStr.toString());
                    copyName.append(m.group(group));
                }
                catch (Exception e) {
                    copyName.append('\\');
                    copyName.append((CharSequence)groupStr);
                }
            }
            return copyName.toString();
        }
        return null;
    }
}

