/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.wizards.repositorystep;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.WizardStepProgressSupport;
import org.netbeans.modules.subversion.remote.ui.repository.Repository;
import org.netbeans.modules.subversion.remote.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.remote.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.remote.ui.wizards.repositorystep.RepositoryStepPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RepositoryStep
extends AbstractStep
implements WizardDescriptor.AsynchronousValidatingPanel,
PropertyChangeListener {
    public static final String IMPORT_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.import";
    public static final String CHECKOUT_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.checkout";
    public static final String URL_PATTERN_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.urlPattern";
    private Repository repository;
    private RepositoryStepPanel panel;
    private RepositoryFile repositoryFile;
    private int repositoryModeMask;
    private WizardStepProgressSupport support;
    private final FileSystem fileSystem;
    private final String helpID;

    public RepositoryStep(FileSystem fileSystem, int repositoryModeMask, String helpID) {
        this.repositoryModeMask = repositoryModeMask;
        this.helpID = helpID;
        this.fileSystem = fileSystem;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(this.helpID);
    }

    @Override
    protected JComponent createComponent() {
        if (this.repository == null) {
            this.repositoryModeMask = this.repositoryModeMask | 2 | 4 | 0x20 | 0x40;
            String title = NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Location");
            this.repository = new Repository(this.fileSystem, this.repositoryModeMask, title);
            this.repository.addPropertyChangeListener(this);
            this.panel = new RepositoryStepPanel();
            this.panel.repositoryPanel.add(this.repository.getPanel());
            Dimension size = this.panel.getPreferredSize();
            this.panel.setPreferredSize(new Dimension(size.width, size.height + new JLabel((String)"A").getPreferredSize().height + new JButton((String)"A").getPreferredSize().height + 20));
            this.valid();
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateBeforeNext() {
        try {
            this.support = new RepositoryStepProgressSupport(this.panel.progressPanel);
            SVNUrl url = this.getUrl();
            if (url != null) {
                this.support.setRepositoryRoot(url);
                RequestProcessor rp = Subversion.getInstance().getRequestProcessor(url);
                RequestProcessor.Task task = this.support.start(rp, url, NbBundle.getMessage(RepositoryStep.class, (String)"BK2012"));
                task.waitFinished();
            }
        }
        finally {
            this.support = null;
        }
    }

    public void prepareValidation() {
    }

    private SVNUrl getUrl() {
        try {
            return this.getSelectedRepositoryConnection().getSvnUrl();
        }
        catch (MalformedURLException mue) {
            this.invalid(new AbstractStep.WizardMessage(mue.getLocalizedMessage(), false));
            return null;
        }
    }

    private void storeHistory() {
        RepositoryConnection rc = this.getSelectedRepositoryConnection();
        if (rc != null) {
            SvnModuleConfig.getDefault(this.fileSystem).insertRecentUrl(rc);
        }
    }

    public RepositoryFile getRepositoryFile() {
        return this.repositoryFile;
    }

    private RepositoryConnection getSelectedRepositoryConnection() {
        try {
            return this.repository.getSelectedRC();
        }
        catch (Exception ex) {
            this.invalid(new AbstractStep.WizardMessage(ex.getLocalizedMessage(), false));
            return null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("valid")) {
            if (this.repository.isValid()) {
                this.valid(new AbstractStep.WizardMessage(this.repository.getMessage(), false));
            } else {
                this.invalid(new AbstractStep.WizardMessage(this.repository.getMessage(), false));
            }
        }
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    static /* synthetic */ RepositoryConnection access$100(RepositoryStep x0) {
        return x0.getSelectedRepositoryConnection();
    }

    static /* synthetic */ void access$200(RepositoryStep x0) {
        x0.storeHistory();
    }

    static /* synthetic */ void access$300(RepositoryStep x0, AbstractStep.WizardMessage x1) {
        x0.invalid(x1);
    }

    static /* synthetic */ RepositoryFile access$402(RepositoryStep x0, RepositoryFile x1) {
        x0.repositoryFile = x1;
        return x0.repositoryFile;
    }

    static /* synthetic */ void access$600(RepositoryStep x0, AbstractStep.WizardMessage x1) {
        x0.valid(x1);
    }

    static /* synthetic */ void access$700(RepositoryStep x0) {
        x0.valid();
    }

    static /* synthetic */ void access$800(RepositoryStep x0, AbstractStep.WizardMessage x1) {
        x0.valid(x1);
    }

    private class RepositoryStepProgressSupport
    extends WizardStepProgressSupport {
        public RepositoryStepProgressSupport(JPanel panel) {
            super(RepositoryStep.this.fileSystem, panel);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void perform() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void setEditable(boolean editable) {
            RepositoryStep.this.repository.setEditable(editable);
        }
    }
}

