/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.basicstructure;

public class MethodDefinition {
    protected String method_name;
    protected String descriptor;
    protected int access_flags;
    protected int token = 255;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_ABSTRACT = 1024;
    protected boolean remoteFlag = false;

    public MethodDefinition() {
    }

    public MethodDefinition(MethodDefinition methodDefinition) {
        this.token = methodDefinition.token;
        this.method_name = methodDefinition.method_name;
        this.descriptor = methodDefinition.descriptor;
        this.access_flags = methodDefinition.access_flags;
        this.access_flags &= 0xFFFFFFBF;
    }

    public String getMethodName() {
        return this.method_name;
    }

    public void setMethodName(String string) {
        this.method_name = string;
    }

    public String getMethodDescriptor() {
        return this.descriptor;
    }

    public void setMethodDescriptor(String string) {
        this.descriptor = string;
    }

    public int getAccessFlags() {
        return this.access_flags;
    }

    public void setAccessFlags(int n) {
        this.access_flags = n &= 0xFFFFFFBF;
    }

    public int getMethodToken() {
        return this.token;
    }

    public void setMethodToken(int n) {
        this.token = n;
    }

    public String getMethodSignature() {
        return this.method_name + this.descriptor;
    }

    public void setMethodSignature(String string) {
        int n = string.indexOf(40);
        if (n == -1) {
            // empty if block
        }
        this.method_name = string.substring(0, n);
        this.descriptor = string.substring(n, string.length());
    }

    public boolean isPublic() {
        return (this.getAccessFlags() & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.getAccessFlags() & 2) != 0;
    }

    public boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public boolean isProtected() {
        return (this.getAccessFlags() & 4) != 0;
    }

    public boolean isStatic() {
        return (this.getAccessFlags() & 8) != 0;
    }

    public boolean isFinal() {
        return (this.getAccessFlags() & 0x10) != 0;
    }

    public boolean isAbstract() {
        return (this.getAccessFlags() & 0x400) != 0;
    }

    public boolean isRemote() {
        return this.remoteFlag;
    }

    public void setRemote(boolean bl) {
        this.remoteFlag = bl;
    }
}

