/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cli;

import com.sun.javacard.cli.SubCommand;
import com.sun.javacard.tools.util.JCToolsLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Tool {
    private static final String ERROR_MESSAGE_1 = "tool.error.1";
    private static final String ERROR_MESSAGE_2 = "tool.error.2";
    private Hashtable<String, Class<? extends SubCommand>> subCommandHandlers = new Hashtable();
    private Class<? extends SubCommand> selectedSubCommandClass = null;
    private ResourceBundle resourceBundle = null;
    protected JCToolsLogger toolsLogger = null;

    public Tool(String string) {
        this.resourceBundle = ResourceBundle.getBundle(string);
        String string2 = string.replace("/", ".");
        if (string2.indexOf(46) != -1) {
            string2 = string2.substring(0, string2.lastIndexOf("."));
        }
        this.toolsLogger = JCToolsLogger.getLogger(string2, string);
    }

    public final String getResourceString(String string) {
        return this.resourceBundle.getString(string);
    }

    public final String getFormattedResourceString(String string, Object ... objectArray) {
        String string2 = this.resourceBundle.getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    public final void registerSubCommand(String string, Class<? extends SubCommand> clazz) {
        this.subCommandHandlers.put(string, clazz);
    }

    public final void printLines(String string) {
        try {
            String string2 = null;
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                try {
                    string2 = this.getResourceString(string + "." + i);
                }
                catch (Exception exception) {
                    break;
                }
                string2 = string2.trim();
                if (string2.startsWith("\"")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith("\"")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                System.out.println(string2);
                System.out.flush();
            }
        }
        catch (Exception exception) {
            this.toolsLogger.severe("messages.properties file corrupted.", new Object[0]);
        }
    }

    public final int runTool(String[] stringArray, boolean bl) throws Exception {
        return this.executeTool(stringArray, bl);
    }

    public final int runTool(String[] stringArray) throws Exception {
        return this.executeTool(stringArray, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int executeTool(String[] stringArray, boolean bl) throws Exception {
        Object object;
        if (!bl) {
            this.printLines("header");
        }
        if (stringArray.length <= 0) {
            throw new Exception(this.getResourceString(ERROR_MESSAGE_1));
        }
        String string = stringArray[0];
        this.selectedSubCommandClass = this.subCommandHandlers.get(string);
        if (this.selectedSubCommandClass == null) {
            throw new Exception(this.getFormattedResourceString(ERROR_MESSAGE_2, string));
        }
        String[] stringArray2 = null;
        List<String> list = Arrays.asList(stringArray);
        if (list.contains("-C") || list.contains("--commandoptionsfile")) {
            if (stringArray.length != 3 || !stringArray[1].equals("-C") && !stringArray[1].equals("--commandoptionsfile")) throw new Exception(this.getFormattedResourceString("tool.error.3", new Object[0]));
            try {
                object = new FileInputStream(new File(stringArray[2]).getCanonicalPath());
                stringArray2 = this.getArgsFromFile((FileInputStream)object);
            }
            catch (Exception exception) {
                this.toolsLogger.severe(exception.getMessage(), new Object[0]);
                System.exit(1);
            }
        } else {
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        }
        object = this.selectedSubCommandClass.newInstance();
        ((SubCommand)object).setResourceBundle(this.resourceBundle);
        ((SubCommand)object).setLogger(this.toolsLogger);
        ((SubCommand)object).setup();
        ((SubCommand)object).parse(stringArray2);
        return ((SubCommand)object).execute();
    }

    public String[] getArgsFromFile(FileInputStream fileInputStream) {
        String[] stringArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.toolsLogger.severe(iOException.getMessage(), new Object[0]);
            System.exit(1);
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuilder.toString());
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            arrayList.add(stringArray);
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }
}

