/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.checkers;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfExportFile;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImportTokenTable;
import com.sun.javacard.jcfile.JcImportTokenTableEntry;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstant;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantSuperMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrInterfaceRef;
import com.sun.javacard.jcfile.instructions.JcInstrMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Vector;

public class ReferenceChecker {
    private static final int NO_LINE_NUMBER = -1;
    private JcPackage jc_package;
    private JcImportTokenTable token_table;
    private String this_package_name;
    private ExportFileManager ex_manager;
    private boolean check_export_only;

    public ReferenceChecker(JcPackage jcPackage, ExportFileManager exportFileManager, boolean bl) {
        this.jc_package = jcPackage;
        this.this_package_name = jcPackage.getPackageName();
        this.token_table = new JcImportTokenTable();
        this.ex_manager = exportFileManager;
        this.check_export_only = bl;
    }

    public void check() throws Exception {
        JcClass[] jcClassArray = this.jc_package.getClasses();
        for (JcClass jcClass : jcClassArray) {
            this.checkClass(jcClass);
        }
        Object[] objectArray = this.constructImportPackageInfos();
        if (objectArray.length > 128) {
            Notifier.error("subset.52");
            throw new ConverterException();
        }
        ReferenceChecker.checkPackageAIDs((PackageDefinition[])objectArray);
        this.token_table.setImportPackageInfos((PackageDefinition[])objectArray);
        this.jc_package.setImportTokenTable(this.token_table);
    }

    private void checkClass(JcClass jcClass) throws Exception {
        int n = jcClass.getAccessFlags();
        if (!this.check_export_only || Modifier.isPublic(n)) {
            int n2;
            Object[] objectArray;
            Object object;
            String string = jcClass.getSuperClassName();
            if (string != null) {
                if (Names.getPackageName(string).equals(this.this_package_name)) {
                    if (this.jc_package.getClass(string) == null) {
                        object = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.')};
                        Notifier.error("linking.3", (Object[])object);
                    } else if (!jcClass.isInterfaceType() && this.jc_package.getClass(string).isInterfaceType()) {
                        object = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.')};
                        Notifier.error("linking.23", (Object[])object);
                    }
                } else {
                    object = this.ex_manager.getClass(string);
                    if (object == null) {
                        objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
                        Notifier.error("linking.2", objectArray);
                    } else {
                        this.token_table.addClassEntry(string, ((ClassDefinition)object).getClassToken());
                    }
                }
            }
            if (Notifier.getErrorCount() > 0) {
                return;
            }
            this.checkSuperInterfaces(jcClass);
            object = jcClass.getFields();
            objectArray = object;
            int n3 = objectArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                JcField jcField = objectArray[n2];
                int n4 = jcField.getAccessFlags();
                if (this.check_export_only && !Modifier.isPublic(n4) && !Modifier.isProtected(n4)) continue;
                this.checkFieldDescriptor(jcClass, jcClass.getClassName(), jcField.getFieldName(), jcField.getFieldDescriptor(), -1);
            }
            Object[] objectArray2 = objectArray = jcClass.getMethods();
            n2 = objectArray2.length;
            for (int i = 0; i < n2; ++i) {
                Object object2 = objectArray2[i];
                int n5 = ((MethodDefinition)object2).getAccessFlags();
                if (!this.check_export_only || Modifier.isPublic(n5) || Modifier.isProtected(n5)) {
                    this.checkMethodDescriptor(jcClass, jcClass.getClassName(), ((MethodDefinition)object2).getMethodName(), ((MethodDefinition)object2).getMethodDescriptor(), -1);
                }
                if (this.check_export_only) continue;
                this.checkBytecode(jcClass, (JcMethod)object2);
                this.checkExceptionTable(jcClass, (JcMethod)object2);
            }
            for (Object object3 : objectArray2 = jcClass.getPublicMethodTable().getMethods()) {
                this.checkMethodDescriptor(jcClass, jcClass.getClassName(), ((MethodDefinition)object3).getMethodName(), ((MethodDefinition)object3).getMethodDescriptor(), -1);
            }
            for (Object object4 : objectArray2 = jcClass.getPackageMethodTable().getMethods()) {
                this.checkMethodDescriptor(jcClass, jcClass.getClassName(), ((MethodDefinition)object4).getMethodName(), ((MethodDefinition)object4).getMethodDescriptor(), -1);
            }
        }
    }

    private void checkSuperInterfaces(JcClass jcClass) throws Exception {
        String[] stringArray = this.check_export_only ? jcClass.getPublicSuperInterfaces() : jcClass.getSuperInterfaces();
        for (String string : stringArray) {
            Object[] objectArray;
            if (Names.getPackageName(string).equals(this.this_package_name)) {
                if (this.jc_package.getClass(string) == null) {
                    objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.')};
                    Notifier.error("linking.5", objectArray);
                    continue;
                }
                if (!jcClass.isInterfaceType() || this.jc_package.getClass(string).isInterfaceType()) continue;
                objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.')};
                Notifier.error("linking.24", objectArray);
                continue;
            }
            objectArray = this.ex_manager.getClass(string);
            if (objectArray == null) {
                Object[] objectArray2 = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
                Notifier.error("linking.4", objectArray2);
                continue;
            }
            this.token_table.addClassEntry(string, objectArray.getClassToken());
        }
    }

    private String checkField(JcClass jcClass, String string, String string2, String string3, int n) throws Exception {
        if (Names.getPackageName(string).equals(this.this_package_name)) {
            JcClass jcClass2 = this.jc_package.getClass(string);
            if (jcClass2 == null) {
                Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.')};
                Notifier.error(n, "linking.7", objectArray);
                Object[] objectArray2 = new String[]{jcClass.getClassName().replace('/', '.'), string2, string.replace('/', '.'), DataType.getTypeString(string3)};
                Notifier.error(n, "linking.13", objectArray2);
            } else if (this.jc_package.getField(string, string2, string3) == null) {
                Object object;
                boolean bl = false;
                boolean bl2 = false;
                String string4 = jcClass2.getClassName();
                while (!bl) {
                    if (this.jc_package.getClass(string4) != null) {
                        String string5 = this.jc_package.getClass(string4).getSuperClassName();
                        if (this.jc_package.getClass(string5) != null) {
                            string4 = string5;
                            if (this.jc_package.getField(string4, string2, string3) == null) continue;
                            bl = true;
                            return string4;
                        }
                        string4 = string5;
                        object = this.ex_manager.getClass(string4);
                        if (((EfClass)object).getField(string2, string3) != null) {
                            bl = true;
                            this.token_table.addFieldEntry(string4, this.ex_manager.getClass(string4).getClassToken(), string2, ((EfClass)object).getField(string2, string3).getFieldToken());
                            return string4;
                        }
                        String[] stringArray = ((EfClass)object).getSuperClassNames();
                        for (int i = 0; i < stringArray.length; ++i) {
                            object = this.ex_manager.getClass(stringArray[i]);
                            if (((EfClass)object).getField(string2, string3) == null) continue;
                            bl = true;
                            this.token_table.addFieldEntry(stringArray[i], this.ex_manager.getClass(stringArray[i]).getClassToken(), string2, ((EfClass)object).getField(string2, string3).getFieldToken());
                            return stringArray[i];
                        }
                        bl = true;
                        bl2 = true;
                        continue;
                    }
                    bl = true;
                    bl2 = true;
                }
                if (bl2) {
                    int n2 = jcClass2.getAccessFlags();
                    object = new String[]{jcClass.getClassName().replace('/', '.'), string2, string.replace('/', '.'), DataType.getTypeString(string3)};
                    if (Modifier.isInterface(n2)) {
                        Notifier.error(n, "linking.19", (Object[])object);
                    } else {
                        Notifier.error(n, "linking.13", (Object[])object);
                    }
                }
            }
        } else {
            EfClass efClass = this.ex_manager.getClass(string);
            if (efClass == null) {
                Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
                Notifier.error(n, "linking.6", objectArray);
                throw new ConverterException();
            }
            EfField efField = this.ex_manager.getField(string, string2, string3);
            if (efField == null) {
                boolean bl = false;
                EfClass efClass2 = this.ex_manager.getClass(string);
                String[] stringArray = efClass2.getSuperClassNames();
                for (int i = 0; !bl && i < stringArray.length; ++i) {
                    EfField efField2 = this.ex_manager.getField(stringArray[i], string2, string3);
                    if (efField2 == null) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    Object[] objectArray = new Object[]{jcClass.getClassName().replace('/', '.'), string2, string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
                    int n3 = efClass.getAccessFlags();
                    if (Modifier.isInterface(n3)) {
                        Notifier.error(n, "linking.18", objectArray);
                    } else {
                        Notifier.error(n, "linking.12", objectArray);
                    }
                }
            } else {
                this.token_table.addFieldEntry(string, efClass.getClassToken(), string2, efField.getFieldToken());
            }
        }
        return null;
    }

    private void checkFieldDescriptor(JcClass jcClass, String string, String string2, String string3, int n) throws Exception {
        String string4 = Names.getClassNameFromDescriptor(string3);
        if (string4 == null) {
            return;
        }
        if (Names.getPackageName(string4).equals(this.this_package_name)) {
            if (this.jc_package.getClass(string4) == null) {
                Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string4.replace('/', '.'), string.replace('/', '.') + "." + string2};
                Notifier.error(n, "linking.14", objectArray);
            }
        } else {
            EfClass efClass = this.ex_manager.getClass(string4);
            if (efClass == null) {
                Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string4.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string4))};
                Notifier.error(n, "linking.6", objectArray);
                Object[] objectArray2 = new String[]{jcClass.getClassName().replace('/', '.'), string4.replace('/', '.'), string.replace('/', '.') + "." + string2};
                Notifier.error(n, "linking.14", objectArray2);
            } else {
                this.token_table.addClassEntry(string4, efClass.getClassToken());
            }
        }
    }

    private String checkMethod(JcClass jcClass, String string, String string2, String string3, int n) throws Exception {
        String string4 = null;
        if (Names.getPackageName(string).equals(this.this_package_name)) {
            JcClass jcClass2 = this.jc_package.getClass(string);
            if (jcClass2 == null) {
                Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.')};
                Notifier.error(n, "linking.7", objectArray);
                Object[] objectArray2 = new Object[]{jcClass.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(string2, string3), string.replace('/', '.')};
                Notifier.error(n, "linking.9", objectArray2);
            } else if (this.jc_package.getMethod(string, string2, string3) == null) {
                if (!this.checkMethodTable(jcClass2, string2, string3)) {
                    Object[] objectArray = new Object[]{jcClass.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(string2, string3), string.replace('/', '.')};
                    int n2 = jcClass2.getAccessFlags();
                    if (Modifier.isInterface(n2)) {
                        Notifier.error(n, "linking.17", objectArray);
                    } else {
                        block22: {
                            MethodDefinition methodDefinition;
                            ClassDefinition classDefinition;
                            String string5 = jcClass2.getClassName();
                            while (true) {
                                if (Names.getPackageName(string5).equals(this.jc_package.getPackageName()) && this.jc_package.getClass(string5) != null) {
                                    classDefinition = this.jc_package.getClass(string5);
                                    string5 = classDefinition.getSuperClassName();
                                } else {
                                    classDefinition = this.ex_manager.getClass(string5);
                                    string5 = ((EfClass)classDefinition).getSuperClassName(this.ex_manager);
                                }
                                if (string5 == null) break block22;
                                if (Names.getPackageName(string5).equals(this.jc_package.getPackageName()) && this.jc_package.getClass(string5) != null) {
                                    classDefinition = this.jc_package.getClass(string5);
                                    methodDefinition = ((JcClass)classDefinition).getMethod(string2, string3);
                                    if (methodDefinition == null) continue;
                                    return string5;
                                }
                                classDefinition = this.ex_manager.getClass(string5);
                                methodDefinition = ((EfClass)classDefinition).getMethod(string2, string3);
                                if (methodDefinition != null) break;
                            }
                            int n3 = methodDefinition.getMethodToken();
                            this.token_table.addMethodEntry(string5, classDefinition.getClassToken(), string2, string3, n3);
                            return string5;
                        }
                        Notifier.error(n, "linking.9", objectArray);
                    }
                } else {
                    String string6 = jcClass2.getClassName();
                    ClassDefinition classDefinition = null;
                    while ((string6 = (classDefinition = Names.getPackageName(string6).equals(this.jc_package.getPackageName()) && this.jc_package.getClass(string6) != null ? this.jc_package.getClass(string6) : this.ex_manager.getClass(string6)).getSuperClassName()) != null) {
                        ClassDefinition classDefinition2;
                        if (Names.getPackageName(string6).equals(this.jc_package.getPackageName()) && this.jc_package.getClass(string6) != null) {
                            classDefinition2 = this.jc_package.getClass(string6);
                            JcMethod jcMethod = ((JcClass)classDefinition2).getMethod(string2, string3);
                            if (jcMethod == null) continue;
                            string4 = string6;
                        } else {
                            classDefinition2 = this.ex_manager.getClass(string6);
                            int n4 = ((EfClass)classDefinition2).getMethod(string2, string3).getMethodToken();
                            this.token_table.addMethodEntry(string6, classDefinition2.getClassToken(), string2, string3, n4);
                            string4 = string6;
                        }
                        break;
                    }
                }
            }
        } else {
            EfClass efClass = this.ex_manager.getClass(string);
            if (efClass == null) {
                Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
                Notifier.error(n, "linking.6", objectArray);
                Object[] objectArray3 = new String[]{jcClass.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(string2, string3), string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
                Notifier.error(n, "linking.8", objectArray3);
            } else {
                EfMethod efMethod = this.ex_manager.getMethod(string, string2, string3);
                if (efMethod == null) {
                    Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(string2, string3), string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
                    int n5 = efClass.getAccessFlags();
                    if (Modifier.isInterface(n5)) {
                        Notifier.error(n, "linking.16", objectArray);
                    } else {
                        Notifier.error(n, "linking.8", objectArray);
                    }
                } else {
                    this.token_table.addMethodEntry(string, efClass.getClassToken(), string2, string3, efMethod.getMethodToken());
                }
            }
        }
        return string4;
    }

    private boolean checkMethodTable(JcClass jcClass, String string, String string2) {
        MethodDefinition[] methodDefinitionArray;
        MethodDefinition[] methodDefinitionArray2 = methodDefinitionArray = jcClass.getPublicMethodTable().getMethods();
        int n = methodDefinitionArray2.length;
        for (int i = 0; i < n; ++i) {
            MethodDefinition methodDefinition = methodDefinitionArray2[i];
            if (!methodDefinition.getMethodName().equals(string) || !methodDefinition.getMethodDescriptor().equals(string2)) continue;
            return true;
        }
        for (MethodDefinition methodDefinition : methodDefinitionArray2 = jcClass.getPackageMethodTable().getMethods()) {
            if (!methodDefinition.getMethodName().equals(string) || !methodDefinition.getMethodDescriptor().equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void checkMethodDescriptor(JcClass jcClass, String string, String string2, String string3, int n) throws Exception {
        Object[] objectArray;
        String[] stringArray;
        for (String string4 : stringArray = MethodDescriptor.getParamDescriptors(string3)) {
            Object[] objectArray2;
            objectArray = Names.getClassNameFromDescriptor(string4);
            if (objectArray == null) continue;
            if (Names.getPackageName((String)objectArray).equals(this.this_package_name)) {
                if (this.jc_package.getClass((String)objectArray) != null) continue;
                objectArray2 = new String[]{jcClass.getClassName().replace('/', '.'), objectArray.replace('/', '.'), string.replace('/', '.') + "." + Names.getMethodNameInJavaStyle(string2, string3)};
                Notifier.error(n, "linking.10", objectArray2);
                continue;
            }
            objectArray2 = this.ex_manager.getClass((String)objectArray);
            if (objectArray2 == null) {
                Object[] objectArray3 = new String[]{jcClass.getClassName().replace('/', '.'), objectArray.replace('/', '.'), Names.getExportFileName(Names.getPackageName((String)objectArray))};
                Notifier.error(n, "linking.6", objectArray3);
                Object[] objectArray4 = new String[]{jcClass.getClassName().replace('/', '.'), objectArray.replace('/', '.'), string.replace('/', '.') + "." + Names.getMethodNameInJavaStyle(string2, string3)};
                Notifier.error(n, "linking.10", objectArray4);
                continue;
            }
            this.token_table.addClassEntry((String)objectArray, objectArray2.getClassToken());
        }
        String string5 = MethodDescriptor.getReturnDescriptor(string3);
        String string6 = Names.getClassNameFromDescriptor(string5);
        if (string6 != null) {
            if (Names.getPackageName(string6).equals(this.this_package_name)) {
                if (this.jc_package.getClass(string6) == null) {
                    Object[] efClass = new Object[]{jcClass.getClassName().replace('/', '.'), string6.replace('/', '.'), string.replace('/', '.') + "." + Names.getMethodNameInJavaStyle(string2, string3)};
                    Notifier.error(n, "linking.11", efClass);
                }
            } else {
                EfClass efClass = this.ex_manager.getClass(string6);
                if (efClass == null) {
                    Object[] objectArray5 = new String[]{jcClass.getClassName().replace('/', '.'), string6.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string6))};
                    Notifier.error(n, "linking.6", objectArray5);
                    objectArray = new Object[]{jcClass.getClassName().replace('/', '.'), string6.replace('/', '.'), string.replace('/', '.') + "." + Names.getMethodNameInJavaStyle(string2, string3)};
                    Notifier.error(n, "linking.11", objectArray);
                } else {
                    this.token_table.addClassEntry(string6, efClass.getClassToken());
                }
            }
        }
    }

    private void checkBytecode(JcClass jcClass, JcMethod jcMethod) throws Exception {
        for (JcInstruction jcInstruction = jcMethod.getCode(); jcInstruction != null; jcInstruction = jcInstruction.getNextInstr()) {
            String string;
            Object[] objectArray;
            Object object;
            String string2;
            JcConstant jcConstant;
            int n = jcInstruction.getSourceLineNumber();
            if (jcInstruction instanceof JcInstrClassRef && (jcConstant = ((JcInstrClassRef)jcInstruction).getClassRef()) != null) {
                string2 = ((JcConstantClassRef)jcConstant).getClassName();
                if (Names.getPackageName(string2).equals(this.this_package_name)) {
                    if (this.jc_package.getClass(string2) == null) {
                        object = new String[]{jcClass.getClassName().replace('/', '.'), string2.replace('/', '.')};
                        if (jcInstruction instanceof JcInstrInterfaceRef) {
                            Notifier.error(n, "linking.21", object);
                        } else {
                            Notifier.error(n, "linking.7", object);
                        }
                    }
                } else {
                    object = this.ex_manager.getClass(string2);
                    if (object == null) {
                        objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string2.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string2))};
                        if (jcInstruction instanceof JcInstrInterfaceRef) {
                            Notifier.error(n, "linking.20", objectArray);
                        } else {
                            Notifier.error(n, "linking.6", objectArray);
                        }
                    } else {
                        this.token_table.addClassEntry(string2, object.getClassToken());
                    }
                }
            }
            if (jcInstruction instanceof JcInstrFieldRef) {
                jcConstant = ((JcInstrFieldRef)jcInstruction).getFieldRef();
                string2 = ((JcConstantFieldRef)jcConstant).getClassName();
                string = this.checkField(jcClass, string2, (String)(object = ((JcConstantFieldRef)jcConstant).getFieldName()), (String)(objectArray = ((JcConstantFieldRef)jcConstant).getDescriptor()), n);
                if (string != null) {
                    string2 = string;
                    ((JcConstantFieldRef)jcConstant).setClassName(string2);
                }
                this.checkFieldDescriptor(jcClass, string2, (String)object, (String)objectArray, n);
            }
            if (!(jcInstruction instanceof JcInstrMethodRef)) continue;
            jcConstant = ((JcInstrMethodRef)jcInstruction).getMethodRef();
            string2 = ((JcConstantMethodRef)jcConstant).getClassName();
            object = ((JcConstantMethodRef)jcConstant).getMethodName();
            objectArray = ((JcConstantMethodRef)jcConstant).getDescriptor();
            if (jcConstant instanceof JcConstantSuperMethodRef) continue;
            string = this.checkMethod(jcClass, string2, (String)object, (String)objectArray, n);
            if (string != null) {
                string2 = string;
                ((JcConstantMethodRef)jcConstant).setClassName(string);
            }
            this.checkMethodDescriptor(jcClass, string2, (String)object, (String)objectArray, n);
        }
    }

    private void checkExceptionTable(JcClass jcClass, JcMethod jcMethod) throws Exception {
        JcException[] jcExceptionArray;
        for (JcException jcException : jcExceptionArray = jcMethod.getExceptions()) {
            Object[] objectArray;
            String string = jcException.getCatchTypeClassRef().getClassName();
            if (string.equals("finally")) continue;
            if (Names.getPackageName(string).equals(this.this_package_name)) {
                if (this.jc_package.getClass(string) != null) continue;
                objectArray = new Object[]{jcClass.getClassName().replace('/', '.'), string.replace('/', ',')};
                Notifier.error(-1, "linking.15", objectArray);
                continue;
            }
            objectArray = this.ex_manager.getClass(string);
            if (objectArray == null) {
                Object[] objectArray2 = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', ','), Names.getExportFileName(Names.getPackageName(string))};
                Notifier.error("linking.6", objectArray2);
                Object[] objectArray3 = new Object[]{jcClass.getClassName().replace('/', '.'), string.replace('/', ',')};
                Notifier.error(-1, "linking.15", objectArray3);
                continue;
            }
            this.token_table.addClassEntry(string, objectArray.getClassToken());
        }
    }

    private PackageDefinition[] constructImportPackageInfos() throws Exception {
        JcImportTokenTableEntry[] jcImportTokenTableEntryArray = this.token_table.getEntries();
        Vector<EfExportFile> vector = new Vector<EfExportFile>(20);
        for (JcImportTokenTableEntry jcImportTokenTableEntry : jcImportTokenTableEntryArray) {
            if (jcImportTokenTableEntry.getType() != 0) continue;
            EfExportFile efExportFile = this.ex_manager.getExportFile(jcImportTokenTableEntry.getName());
            vector.addElement(efExportFile);
        }
        Object[] objectArray = new PackageDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void checkPackageAIDs(PackageDefinition[] packageDefinitionArray) throws ConverterException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < packageDefinitionArray.length; ++i) {
            byte[] byArray = packageDefinitionArray[i].getAID();
            String string = Strings.toHexString(byArray, ":");
            if (hashSet.contains(string)) {
                Object[] objectArray = new Object[]{string};
                Notifier.error("binary.57", objectArray);
                throw new ConverterException();
            }
            hashSet.add(string);
        }
    }
}

