/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadT0;
import com.sun.javacard.apduio.ServerT0Protocol;
import com.sun.javacard.apduio.T0ServerClosed;
import com.sun.javacard.apduio.T0ServerState;
import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.apduio.TLP224Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class T0ServerActive
extends T0ServerState {
    protected static T0ServerActive _instance;

    private T0ServerActive() {
    }

    static T0ServerActive instance() {
        if (_instance == null) {
            _instance = new T0ServerActive();
        }
        return _instance;
    }

    int t0SndStatusRcvCommand(ServerT0Protocol protocol, byte[] command, short sw1sw2) throws IOException, TLP224Exception {
        CadT0 cad = protocol.cad;
        TLP224Message tlp224Msg = protocol.tlp224Msg;
        byte[] msgData = tlp224Msg.getData();
        msgData[0] = 96;
        msgData[1] = 3;
        int le = 0;
        if (tlp224Msg.dataOut != null) {
            byte[] dataOut = tlp224Msg.dataOut.toByteArray();
            le = dataOut.length;
            if (le == 0) {
                msgData[2] = -27;
            } else {
                msgData[2] = sw1sw2 == -28672 ? 0 : -25;
                msgData[1] = (byte)(msgData[1] + le);
                System.arraycopy(dataOut, 0, msgData, 3, le);
            }
        } else {
            msgData[2] = tlp224Msg.dataIn != null ? (tlp224Msg.dataIn.available() > 0 ? -27 : (sw1sw2 == -28672 ? 0 : -25)) : (sw1sw2 == -28672 ? 0 : -25);
        }
        msgData[3 + le] = (byte)(sw1sw2 >> 8);
        msgData[4 + le] = (byte)sw1sw2;
        msgData[5 + le] = (byte)tlp224Msg.computeLRC(5 + le);
        tlp224Msg.setLength(6 + le);
        cad.sendTLP224Message(tlp224Msg);
        block6: while (true) {
            tlp224Msg.dataIn = null;
            tlp224Msg.dataOut = null;
            cad.receiveTLP224Message(tlp224Msg);
            msgData = tlp224Msg.getData();
            switch (msgData[2] & 0xFF) {
                case 110: {
                    if (msgData[1] != 4) {
                        cad.statusResponse(3);
                        break;
                    }
                    cad.statusResponse(0);
                    break;
                }
                case 77: {
                    cad.statusResponse(0);
                    this.changeState(protocol, T0ServerClosed.instance());
                    return 1;
                }
                case 218: {
                    if ((msgData[4] & 0xF0) == 96 || (msgData[4] & 0xF0) == 144) {
                        cad.statusResponse(17);
                        break;
                    }
                    if (msgData[7] != (byte)(tlp224Msg.getLength() - 9)) {
                        cad.statusResponse(26);
                        break;
                    }
                    System.arraycopy(msgData, 3, command, 0, 5);
                    if ((msgData[7] & 0xFF) <= 0) break block6;
                    tlp224Msg.dataIn = new ByteArrayInputStream(msgData, 8, msgData[7] & 0xFF);
                    break block6;
                }
                case 219: {
                    if ((msgData[4] & 0xF0) == 96 || (msgData[4] & 0xF0) == 144) {
                        cad.statusResponse(17);
                        break;
                    }
                    if (tlp224Msg.getLength() != 9) {
                        cad.statusResponse(3);
                        break;
                    }
                    System.arraycopy(msgData, 3, command, 0, 5);
                    int length = msgData[7] & 0xFF;
                    if (length == 0) {
                        length = 256;
                    }
                    tlp224Msg.dataOut = new ByteArrayOutputStream(length);
                    break block6;
                }
                default: {
                    protocol.cad.statusResponse(4);
                    break;
                }
            }
        }
        return 0;
    }

    int t0RcvData(ServerT0Protocol protocol, byte[] data, short offset, short length, byte procByte) throws IOException, TLP224Exception {
        int ack = procByte & 0xFF;
        if (length == 0 && ack == 96) {
            return 0;
        }
        TLP224Message tlp224Msg = protocol.tlp224Msg;
        if (tlp224Msg.dataIn == null) {
            System.err.println(T0ServerState._messages.getString("active.t0RcvData"));
            return 1;
        }
        byte[] msg = tlp224Msg.getData();
        int ins = msg[4] & 0xFF;
        int p3 = msg[7] & 0xFF;
        if (!(((ack ^ ins) & 0xFF) == 0 && length <= p3 || ((ack ^ ins) & 0xFF) == 1 && length <= p3 || ((ack ^ ins) & 0xFF) == 254 && length == 1 || ((ack ^ ins) & 0xFF) == 255 && length == 1)) {
            System.err.println(T0ServerState._messages.getString("active.t0RcvDataProcByte"));
            return 1;
        }
        tlp224Msg.dataIn.read(data, offset, length);
        return 0;
    }

    int t0SndData(ServerT0Protocol protocol, byte[] data, short offset, short length, byte procByte) throws IOException, TLP224Exception {
        int ack = procByte & 0xFF;
        if (length == 0 && ack == 96) {
            return 0;
        }
        TLP224Message tlp224Msg = protocol.tlp224Msg;
        if (tlp224Msg.dataOut == null) {
            System.err.println(T0ServerState._messages.getString("active.t0SndData"));
            return 1;
        }
        byte[] msg = tlp224Msg.getData();
        int ins = msg[4] & 0xFF;
        int p3 = msg[7] & 0xFF;
        if (p3 == 0) {
            p3 = 256;
        }
        if (!((ack & 0xFE) == (ins & 0xFE) && length <= p3 || ((ack ^ ins) & 0xFF) == 1 && length <= p3 || ((ack ^ ins) & 0xFF) == 254 && length == 1 || ((ack ^ ins) & 0xFF) == 255 && length == 1)) {
            System.err.println(T0ServerState._messages.getString("active.t0SndDataProcByte"));
            return 1;
        }
        tlp224Msg.dataOut.write(data, offset, length);
        return 0;
    }

    int t0SndData(ServerT0Protocol protocol, byte[] data, short offset, short length) throws IOException, TLP224Exception {
        TLP224Message tlp224Msg = protocol.tlp224Msg;
        if (tlp224Msg.dataOut == null) {
            System.err.println(T0ServerState._messages.getString("active.t0SndData"));
            return 1;
        }
        tlp224Msg.dataOut.write(data, offset, length);
        return 0;
    }

    public String toString() {
        return T0ServerState._messages.getString("state.active");
    }
}

