/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.api.Bundle;
import org.openide.util.NbPreferences;

public final class ProfilerIDESettings
implements GlobalProfilingSettings {
    public static final String DO_NOT_SHOW_ATTACH_SETTINGS = "dns-attach-settings";
    public static final String DO_NOT_SHOW_JDK_DIALOG = "dns-jdk-dialog";
    public static final String DO_NOT_SHOW_PID_WINDOWS = "dns-pid-windows4";
    public static final int CPU_ENTIRE_APP = 0;
    public static final int CPU_PART_APP = 1;
    public static final int CPU_STARTUP = 2;
    public static final int CPU_PROFILING_POINTS = 3;
    public static final int OOME_DETECTION_NONE = 0;
    public static final int OOME_DETECTION_PROJECTDIR = 1;
    public static final int OOME_DETECTION_TEMPDIR = 2;
    public static final int OOME_DETECTION_CUSTOMDIR = 3;
    public static final int SNAPSHOT_WINDOW_OPEN_NEVER = 0;
    public static final int SNAPSHOT_WINDOW_OPEN_PROFILER = 1;
    public static final int SNAPSHOT_WINDOW_SHOW_PROFILER = 2;
    public static final int SNAPSHOT_WINDOW_OPEN_FIRST = 3;
    public static final int SNAPSHOT_WINDOW_OPEN_EACH = 4;
    public static final int SNAPSHOT_WINDOW_CLOSE_NEVER = 0;
    public static final int SNAPSHOT_WINDOW_CLOSE_PROFILER = 1;
    public static final int SNAPSHOT_WINDOW_HIDE_PROFILER = 2;
    public static final int OPEN_ALWAYS = 1;
    public static final int OPEN_MONITORING = 2;
    public static final int OPEN_NEVER = 3;
    private static final ProfilerIDESettings defaultInstance = new ProfilerIDESettings();
    private Map<String, String> dnsaMap;
    private final String AUTO_OPEN_SNAPSHOT_KEY_55 = "autoOpenSnapshot";
    private final String AUTO_SAVE_SNAPSHOT_KEY_55 = "autoSaveSnapshot";
    private final String CALIBRATION_PORT_NO_KEY_55 = "calibrationPortNo";
    private final String CPU_TASK_KEY_55 = "cpuTaskDefault";
    private final String LIVE_CPU_KEY_55 = "displayLiveResultsCPU";
    private final String LIVE_FRAGMENT_KEY_55 = "displayLiveResultsFragment";
    private final String LIVE_MEMORY_KEY_55 = "displayLiveResultsMemory";
    private final String MEMORY_TASK_ALLOCATIONS_KEY_55 = "memoryTaskAllocationsDefault";
    private final String PLATFORM_NAME_KEY_55 = "javaPlatformForProfiling";
    private final String PORT_NO_KEY_55 = "portNo";
    private final String RECORD_STACK_TRACES_KEY_55 = "recordStackTracesDefault";
    private final String THREADS_MONITORING_KEY_55 = "threadsMonitoringDefault";
    private final String TO_BEHAVIOR_KEY_55 = "telemetryOverviewBehavior";
    private final String TRACK_EVERY_KEY_55 = "trackEveryDefault";
    private final String TV_BEHAVIOR_KEY_55 = "threadsViewBehavior";
    private final String AUTO_OPEN_SNAPSHOT_KEY = "AUTO_OPEN_SNAPSHOT";
    private final String AUTO_SAVE_SNAPSHOT_KEY = "AUTO_SAVE_SNAPSHOT";
    private final String CALIBRATION_PORT_NO_KEY = "CALIBRATION_PORT_NO";
    private final String CPU_TASK_KEY = "CPU_TASK";
    private final String CUSTOM_HEAPDUMP_PATH_KEY = "CUSTOM_HEAPDUMP_PATH";
    private final String DNSA_SETTINGS_KEY = "DNSA_SETTINGS";
    private final String HEAPWALKER_ANALYSIS_ENABLED_KEY = "HEAPWALKER_ANALYSIS_ENABLED";
    private final String INSTR_FILTER_KEY = "INSTR_FILTER";
    private final String LIVE_CPU_KEY = "LIVE_CPU";
    private final String LIVE_FRAGMENT_KEY = "LIVE_FRAGMENT";
    private final String LIVE_MEMORY_KEY = "LIVE_MEMORY";
    private final String MEMORY_TASK_ALLOCATIONS_KEY = "MEMORY_TASK_ALLOCATIONS";
    private final String OOME_DETECTION_MODE_KEY = "OOME_DETECTION_MODE";
    private final String PLATFORM_NAME_KEY = "PLATFORM_NAME";
    private final String PORT_NO_KEY = "PORT_NO";
    private final String PPOINTS_DEPENDENCIES_INCLUDE_KEY = "PPOINTS_DEPENDENCIES_INCLUDE";
    private final String RECORD_STACK_TRACES_KEY = "RECORD_STACK_TRACES";
    private final String THREADS_MONITORING_KEY = "THREADS_MONITORING";
    private final String TO_BEHAVIOR_KEY = "TO_BEHAVIOR";
    private final String TRACK_EVERY_KEY = "TRACK_EVERY";
    private final String TV_BEHAVIOR_KEY = "TV_BEHAVIOR";
    private final String LCV_BEHAVIOR_KEY = "LCV_BEHAVIOR";
    private final String NO_DATA_HINT_KEY = "NO_DATA_HINT";
    private final String SNAPSHOT_WINDOW_OPEN_POLICY_KEY = "SNAPSHOT_WINDOW_OPEN_POLICY";
    private final String SNAPSHOT_WINDOW_CLOSE_POLICY_KEY = "SNAPSHOT_WINDOW_CLOSE_POLICY";
    private final String ENABLE_EXPERT_SETTINGS_KEY = "ENABLE_EXPERT_SETTINGS";
    private final String LOG_PROFILER_STATUS_KEY = "LOG_PROFILER_STATUS";
    private final String REOPEN_SNAPSHOTS_KEY = "REOPEN_SNAPSHOTS_KEY";
    private final String REOPEN_HDUMPS_KEY = "REOPEN_HDUMPS_KEY";
    private final String SOURCES_COLORING_KEY = "SOURCES_COLORING_KEY";
    private final String CUSTOM_HEAPDUMP_PATH_DEFAULT = "";
    private final String PLATFORM_NAME_DEFAULT = "PLATFORM_NAME_DEFAULT";
    private final String INSTR_FILTER_DEFAULT = "###";
    private final boolean AUTO_OPEN_SNAPSHOT_DEFAULT = true;
    private final boolean AUTO_SAVE_SNAPSHOT_DEFAULT = false;
    private final boolean HEAPWALKER_ANALYSIS_ENABLED_DEFAULT = false;
    private final boolean LIVE_CPU_DEFAULT = false;
    private final boolean LIVE_FRAGMENT_DEFAULT = false;
    private final boolean LIVE_MEMORY_DEFAULT = false;
    private final boolean MEMORY_TASK_ALLOCATIONS_DEFAULT = true;
    private final boolean PPOINTS_DEPENDENCIES_INCLUDE_DEFAULT = true;
    private final boolean RECORD_STACK_TRACES_DEFAULT = false;
    private final boolean THREADS_MONITORING_DEFAULT = true;
    private final int CALIBRATION_PORT_NO_DEFAULT = -1;
    private final int CPU_TASK_DEFAULT = 0;
    private final int OOME_DETECTION_MODE_DEFAULT = 1;
    private final int PORT_NO_DEFAULT = 5140;
    private final int TO_BEHAVIOR_DEFAULT = 2;
    private final int TRACK_EVERY_DEFAULT = 10;
    private final int TV_BEHAVIOR_DEFAULT = 1;
    private final int LCV_BEHAVIOR_DEFAULT = 1;
    private final boolean NO_DATA_HINT_DEFAULT = true;
    private final int SNAPSHOT_WINDOW_OPEN_DEFAULT = 3;
    private final int SNAPSHOT_WINDOW_CLOSE_DEFAULT = 0;
    private final boolean ENABLE_EXPERT_SETTINGS_DEFAULT = false;
    private final boolean LOG_PROFILER_STATUS_DEFAULT = false;
    private final boolean REOPEN_SNAPSHOTS_DEFAULT = false;
    private final boolean REOPEN_HDUMPS_DEFAULT = false;
    private final boolean SOURCES_COLORING_DEFAULT = false;
    private ProfilingSettings pSettings;
    private Boolean sourcesColoringEnabled;

    public static ProfilerIDESettings getInstance() {
        return defaultInstance;
    }

    private ProfilerIDESettings() {
    }

    public ProfilingSettings getDefaultProfilingSettings() {
        if (this.pSettings == null) {
            this.pSettings = this.loadProfilingSettings();
        }
        return this.pSettings;
    }

    public void saveDefaultProfilingSettings() {
        if (this.pSettings != null) {
            this.storeProfilingSettings(this.pSettings);
        }
    }

    public ProfilingSettings createDefaultProfilingSettings() {
        ProfilingSettings defaultSettings = new ProfilingSettings();
        this.getDefaultProfilingSettings().copySettingsInto(defaultSettings);
        return defaultSettings;
    }

    private ProfilingSettings loadProfilingSettings() {
        Preferences pref = this.getPreferences();
        ProfilingSettings settings = new ProfilingSettings();
        settings.setSamplingFrequency(pref.getInt("profiler.settings.cpu.sampling.frequency", 10));
        settings.setCPUProfilingType(pref.getInt("profiler.settings.cpu.profiling.type", 0));
        settings.setSamplingInterval(pref.getInt("profiler.settings.sampling.interval", -10));
        settings.setExcludeWaitTime(pref.getBoolean("profiler.settings.cpu.exclude.wait.time", true));
        settings.setInstrumentSpawnedThreads(pref.getBoolean("profiler.settings.instrument.spawned.threads", false));
        settings.setNProfiledThreadsLimit(pref.getInt("profiler.settings.n.profiled.threads.limit", 128));
        settings.setInstrScheme(pref.getInt("profiler.settings.instr.scheme", 1));
        settings.setInstrumentMethodInvoke(pref.getBoolean("profiler.settings.instrument.method.invoke", true));
        settings.setInstrumentGetterSetterMethods(pref.getBoolean("profiler.settings.istrument.getter.setter.methods", false));
        settings.setInstrumentEmptyMethods(pref.getBoolean("profiler.settings.instrument.empty.methods", false));
        settings.setAllocTrackEvery(pref.getInt("profiler.settings.obj.alloc.stack.sampling.interval", 1));
        settings.setRunGCOnGetResultsInMemoryProfiling(pref.getBoolean("profiler.settings.run.gc.on.get.results.in.memory.profiling", false));
        settings.setThreadsSamplingEnabled(pref.getBoolean("profiler.settings.threads.sampling.enabled", false));
        return settings;
    }

    private void storeProfilingSettings(ProfilingSettings settings) {
        Preferences pref = this.getPreferences();
        pref.putInt("profiler.settings.cpu.sampling.frequency", settings.getSamplingFrequency());
        pref.putInt("profiler.settings.cpu.profiling.type", settings.getCPUProfilingType());
        pref.putInt("profiler.settings.sampling.interval", settings.getSamplingInterval());
        pref.putBoolean("profiler.settings.cpu.exclude.wait.time", settings.getExcludeWaitTime());
        pref.putBoolean("profiler.settings.instrument.spawned.threads", settings.getInstrumentSpawnedThreads());
        pref.putInt("profiler.settings.n.profiled.threads.limit", settings.getNProfiledThreadsLimit());
        pref.putInt("profiler.settings.instr.scheme", settings.getInstrScheme());
        pref.putBoolean("profiler.settings.instrument.method.invoke", settings.getInstrumentMethodInvoke());
        pref.putBoolean("profiler.settings.istrument.getter.setter.methods", settings.getInstrumentGetterSetterMethods());
        pref.putBoolean("profiler.settings.instrument.empty.methods", settings.getInstrumentEmptyMethods());
        pref.putInt("profiler.settings.obj.alloc.stack.sampling.interval", settings.getAllocTrackEvery());
        pref.putBoolean("profiler.settings.run.gc.on.get.results.in.memory.profiling", settings.getRunGCOnGetResultsInMemoryProfiling());
        pref.putBoolean("profiler.settings.threads.sampling.enabled", settings.getThreadsSamplingEnabled());
    }

    public void setAutoOpenSnapshot(boolean value) {
        this.getPreferences().putBoolean("AUTO_OPEN_SNAPSHOT", value);
    }

    public boolean getAutoOpenSnapshot() {
        return this.getPreferences().getBoolean("AUTO_OPEN_SNAPSHOT", true);
    }

    public void setAutoSaveSnapshot(boolean value) {
        this.getPreferences().putBoolean("AUTO_SAVE_SNAPSHOT", value);
    }

    public boolean getAutoSaveSnapshot() {
        return this.getPreferences().getBoolean("AUTO_SAVE_SNAPSHOT", false);
    }

    public void setCalibrationPortNo(int value) {
        this.getPreferences().putInt("CALIBRATION_PORT_NO", value);
    }

    public int getCalibrationPortNo() {
        int calibrationPort = this.getPreferences().getInt("CALIBRATION_PORT_NO", -1);
        if (calibrationPort == -1) {
            return this.getPortNo() + 1;
        }
        return calibrationPort;
    }

    public void setCpuTaskDefault(int value) {
        this.getPreferences().putInt("CPU_TASK", value);
    }

    public int getCpuTaskDefault() {
        return this.getPreferences().getInt("CPU_TASK", 0);
    }

    public void setCustomHeapdumpPath(String heapDumpCustomDir) {
        this.getPreferences().put("CUSTOM_HEAPDUMP_PATH", heapDumpCustomDir);
    }

    public String getCustomHeapdumpPath() {
        return this.getPreferences().get("CUSTOM_HEAPDUMP_PATH", "");
    }

    public void setDisplayLiveResultsCPU(boolean value) {
        this.getPreferences().putBoolean("LIVE_CPU", value);
    }

    public boolean getDisplayLiveResultsCPU() {
        return this.getPreferences().getBoolean("LIVE_CPU", false);
    }

    public void setDisplayLiveResultsFragment(boolean value) {
        this.getPreferences().putBoolean("LIVE_FRAGMENT", value);
    }

    public boolean getDisplayLiveResultsFragment() {
        return this.getPreferences().getBoolean("LIVE_FRAGMENT", false);
    }

    public void setDisplayLiveResultsMemory(boolean value) {
        this.getPreferences().putBoolean("LIVE_MEMORY", value);
    }

    public boolean getDisplayLiveResultsMemory() {
        return this.getPreferences().getBoolean("LIVE_MEMORY", false);
    }

    public void setShowNoDataHint(boolean value) {
        this.getPreferences().putBoolean("NO_DATA_HINT", value);
    }

    public boolean getShowNoDataHint() {
        return this.getPreferences().getBoolean("NO_DATA_HINT", true);
    }

    public void setSnapshotWindowOpenPolicy(int policy) {
        this.getPreferences().putInt("SNAPSHOT_WINDOW_OPEN_POLICY", policy);
    }

    public int getSnapshotWindowOpenPolicy() {
        return this.getPreferences().getInt("SNAPSHOT_WINDOW_OPEN_POLICY", 3);
    }

    public void setSnapshotWindowClosePolicy(int policy) {
        this.getPreferences().putInt("SNAPSHOT_WINDOW_CLOSE_POLICY", policy);
    }

    public int getSnapshotWindowClosePolicy() {
        return this.getPreferences().getInt("SNAPSHOT_WINDOW_CLOSE_POLICY", 0);
    }

    public void setEnableExpertSettings(boolean value) {
        this.getPreferences().putBoolean("ENABLE_EXPERT_SETTINGS", value);
    }

    public boolean getEnableExpertSettings() {
        return this.getPreferences().getBoolean("ENABLE_EXPERT_SETTINGS", false);
    }

    public void setLogProfilerStatus(boolean value) {
        this.getPreferences().putBoolean("LOG_PROFILER_STATUS", value);
    }

    public boolean getLogProfilerStatus() {
        return this.getPreferences().getBoolean("LOG_PROFILER_STATUS", false);
    }

    public void setReopenSnapshots(boolean value) {
        this.getPreferences().putBoolean("REOPEN_SNAPSHOTS_KEY", value);
    }

    public boolean getReopenSnapshots() {
        return this.getPreferences().getBoolean("REOPEN_SNAPSHOTS_KEY", false);
    }

    public void setReopenHeapDumps(boolean value) {
        this.getPreferences().putBoolean("REOPEN_HDUMPS_KEY", value);
    }

    public boolean getReopenHeapDumps() {
        return this.getPreferences().getBoolean("REOPEN_HDUMPS_KEY", false);
    }

    public void setSourcesColoringEnabled(boolean value) {
        this.getPreferences().putBoolean("SOURCES_COLORING_KEY", value);
        this.sourcesColoringEnabled = value;
    }

    public boolean isSourcesColoringEnabled() {
        if (this.sourcesColoringEnabled == null) {
            this.sourcesColoringEnabled = this.getPreferences().getBoolean("SOURCES_COLORING_KEY", false);
        }
        return this.sourcesColoringEnabled;
    }

    public void setDoNotShowAgain(String key, String value) {
        if (value != null) {
            this.getDNSAMap().put(key, value);
        } else {
            this.getDNSAMap().remove(key);
        }
        this.storeDNSAMap();
    }

    public String getDoNotShowAgain(String key) {
        return this.getDNSAMap().get(key);
    }

    public void setHeapWalkerAnalysisEnabled(boolean value) {
        this.getPreferences().putBoolean("HEAPWALKER_ANALYSIS_ENABLED", value);
    }

    public boolean getHeapWalkerAnalysisEnabled() {
        return this.getPreferences().getBoolean("HEAPWALKER_ANALYSIS_ENABLED", false);
    }

    public void setIncludeProfilingPointsDependencies(boolean value) {
        this.getPreferences().putBoolean("PPOINTS_DEPENDENCIES_INCLUDE", value);
    }

    public boolean getIncludeProfilingPointsDependencies() {
        return this.getPreferences().getBoolean("PPOINTS_DEPENDENCIES_INCLUDE", true);
    }

    public void setInstrFilterDefault(String value) {
        this.getPreferences().put("INSTR_FILTER", value);
    }

    public String getInstrFilterDefault() {
        return this.getPreferences().get("INSTR_FILTER", "###");
    }

    public void setJavaPlatformForProfiling(String value) {
        this.getPreferences().put("PLATFORM_NAME", value == null ? "PLATFORM_NAME_DEFAULT" : value);
    }

    public String getJavaPlatformForProfiling() {
        String platformName = this.getPreferences().get("PLATFORM_NAME", "PLATFORM_NAME_DEFAULT");
        return "PLATFORM_NAME_DEFAULT".equals(platformName) ? null : platformName;
    }

    public void setMemoryTaskAllocationsDefault(boolean value) {
        this.getPreferences().putBoolean("MEMORY_TASK_ALLOCATIONS", value);
    }

    public boolean getMemoryTaskAllocationsDefault() {
        return this.getPreferences().getBoolean("MEMORY_TASK_ALLOCATIONS", true);
    }

    public boolean isOOMDetectionEnabled() {
        return this.getOOMDetectionMode() != 0;
    }

    public void setOOMDetectionMode(int oomeDetectionMode) {
        this.getPreferences().putInt("OOME_DETECTION_MODE", oomeDetectionMode);
    }

    public int getOOMDetectionMode() {
        return this.getPreferences().getInt("OOME_DETECTION_MODE", 1);
    }

    public void setPortNo(int value) {
        this.getPreferences().putInt("PORT_NO", value);
    }

    public int getPortNo() {
        return this.getPreferences().getInt("PORT_NO", 5140);
    }

    public void setRecordStackTracesDefault(boolean value) {
        this.getPreferences().putBoolean("RECORD_STACK_TRACES", value);
    }

    public boolean getRecordStackTracesDefault() {
        return this.getPreferences().getBoolean("RECORD_STACK_TRACES", false);
    }

    public void setTelemetryOverviewBehavior(int value) {
        this.getPreferences().putInt("TO_BEHAVIOR", value);
    }

    public int getTelemetryOverviewBehavior() {
        return this.getPreferences().getInt("TO_BEHAVIOR", 2);
    }

    public void setThreadsMonitoringDefault(boolean value) {
        this.getPreferences().putBoolean("THREADS_MONITORING", value);
    }

    public boolean getThreadsMonitoringDefault() {
        return this.getPreferences().getBoolean("THREADS_MONITORING", true);
    }

    public void setThreadsViewBehavior(int value) {
        this.getPreferences().putInt("TV_BEHAVIOR", value);
    }

    public int getThreadsViewBehavior() {
        return this.getPreferences().getInt("TV_BEHAVIOR", 1);
    }

    public void setLockContentionViewBehavior(int value) {
        this.getPreferences().putInt("LCV_BEHAVIOR", value);
    }

    public int getLockContentionViewBehavior() {
        return this.getPreferences().getInt("LCV_BEHAVIOR", 1);
    }

    public void setTrackEveryDefault(int value) {
        this.getPreferences().putInt("TRACK_EVERY", value);
    }

    public int getTrackEveryDefault() {
        return this.getPreferences().getInt("TRACK_EVERY", 10);
    }

    public void clearDoNotShowAgainMap() {
        this.getDNSAMap().clear();
        this.storeDNSAMap();
    }

    public String displayName() {
        return Bundle.ProfilerIDESettings_Name();
    }

    private Map<String, String> getDNSAMap() {
        if (this.dnsaMap != null) {
            return this.dnsaMap;
        }
        this.dnsaMap = new HashMap<String, String>();
        String allPairs = this.getPreferences().get("DNSA_SETTINGS", null);
        if (allPairs != null) {
            String[] pairs = allPairs.split(":");
            for (int i = 0; i < pairs.length; ++i) {
                String[] elems = pairs[i].split(",");
                assert (elems.length == 2);
                this.dnsaMap.put(elems[0], elems[1]);
            }
        }
        return this.dnsaMap;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(ProfilerIDESettings.class);
    }

    private void storeDNSAMap() {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> it = this.getDNSAMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            sb.append((Object)e.getKey()).append(",").append((Object)e.getValue());
            if (!it.hasNext()) continue;
            sb.append(":");
        }
        String toStore = sb.toString();
        if (toStore.length() > 0) {
            this.getPreferences().put("DNSA_SETTINGS", toStore);
        } else {
            this.getPreferences().remove("DNSA_SETTINGS");
        }
    }
}

