/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JB7Deployer;
import org.netbeans.modules.j2ee.jboss4.JBDeployer;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentFactory;
import org.netbeans.modules.j2ee.jboss4.JBRemoteAction;
import org.netbeans.modules.j2ee.jboss4.JBoss5ProfileServiceProxy;
import org.netbeans.modules.j2ee.jboss4.WrappedTargetModuleID;
import org.netbeans.modules.j2ee.jboss4.ide.JBJ2eePlatformFactory;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.openide.util.RequestProcessor;

public class JBDeploymentManager
implements DeploymentManager {
    private static final Logger LOGGER = Logger.getLogger(JBDeploymentManager.class.getName());
    private final RequestProcessor rp = new RequestProcessor("JBoss Background Processor", 1);
    private final String realUri;
    private final String jbUri;
    private final DeploymentFactory df;
    private final Object executionLock = new Object();
    private DeploymentManager manager;
    private int debuggingPort = 8787;
    private InstanceProperties instanceProperties;
    private boolean needsRestart;
    private volatile Boolean as7;
    private JBJ2eePlatformFactory.J2eePlatformImplImpl jbPlatform;
    private static final Map<InstanceProperties, Boolean> propertiesToIsRunning = Collections.synchronizedMap(new WeakHashMap());

    public JBDeploymentManager(DeploymentFactory df, String realUri, String jbUri, String username, String password) {
        this.realUri = realUri;
        this.jbUri = jbUri;
        this.df = df;
    }

    public String getHost() {
        String host = InstanceProperties.getInstanceProperties((String)this.realUri).getProperty("host");
        return host;
    }

    public int getPort() {
        String port = InstanceProperties.getInstanceProperties((String)this.realUri).getProperty("port");
        return new Integer(port);
    }

    public int getDebuggingPort() {
        return this.debuggingPort;
    }

    public String getUrl() {
        return this.realUri;
    }

    public synchronized InstanceProperties getInstanceProperties() {
        if (this.instanceProperties == null) {
            this.instanceProperties = InstanceProperties.getInstanceProperties((String)this.realUri);
        }
        return this.instanceProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeAction(final Action<T> action) throws Exception {
        if (!Thread.currentThread().isDaemon()) {
            return (T)this.rp.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return JBDeploymentManager.this.executeAction(action);
                }
            }).get();
        }
        Object object = this.executionLock;
        synchronized (object) {
            return this.invokeLocalAction(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    Object t;
                    block7: {
                        DeploymentManager manager = null;
                        try {
                            manager = JBDeploymentManager.this.getDeploymentManager(JBDeploymentManager.this.jbUri, JBDeploymentManager.this.getInstanceProperties().getProperty("username"), JBDeploymentManager.this.getInstanceProperties().getProperty("password"));
                            t = action.execute(manager);
                            if (!LOGGER.isLoggable(Level.FINE)) break block7;
                        }
                        catch (DeploymentManagerCreationException ex) {
                            try {
                                throw new ExecutionException(ex);
                            }
                            catch (Throwable throwable) {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    for (Thread t2 : Thread.getAllStackTraces().keySet()) {
                                        if (!t2.getName().startsWith("Remoting")) continue;
                                        LOGGER.log(Level.FINE, "Remoting thread: {0}; deamon: {1}", new Object[]{t2.getName(), t2.isDaemon()});
                                    }
                                }
                                throw throwable;
                            }
                        }
                        for (Thread t3 : Thread.getAllStackTraces().keySet()) {
                            if (!t3.getName().startsWith("Remoting")) continue;
                            LOGGER.log(Level.FINE, "Remoting thread: {0}; deamon: {1}", new Object[]{t3.getName(), t3.isDaemon()});
                        }
                    }
                    return t;
                }
            });
        }
    }

    private synchronized DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        if (this.manager != null) {
            try {
                Field f = this.manager.getClass().getDeclaredField("isConnected");
                f.setAccessible(true);
                Object o = f.get(this.manager);
                if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                    return this.manager;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            try {
                Target[] targets = this.manager.getTargets();
                if (targets != null) {
                    JBDeploymentManager.closeTargets(targets);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            this.manager.release();
        }
        try {
            this.manager = this.df.getDeploymentManager(uri, username, password);
            return this.manager;
        }
        catch (NoClassDefFoundError e) {
            DeploymentManagerCreationException dmce = new DeploymentManagerCreationException("Classpath is incomplete");
            dmce.initCause((Throwable)e);
            throw dmce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T invokeLocalAction(Callable<T> action) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            InstanceProperties ip = this.getInstanceProperties();
            JBDeploymentFactory.JBClassLoader loader = JBDeploymentFactory.getInstance().getJBClassLoader(ip);
            Thread.currentThread().setContextClassLoader(loader);
            T t = action.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T invokeRemoteAction(JBRemoteAction<T> action) throws ExecutionException {
        Object object = this.executionLock;
        synchronized (object) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            InitialContext ctx = null;
            JMXConnector conn = null;
            Set<Thread> threads = this.getThreads();
            try {
                InstanceProperties ip = this.getInstanceProperties();
                JBDeploymentFactory.JBClassLoader loader = JBDeploymentFactory.getInstance().getJBClassLoader(ip);
                Thread.currentThread().setContextClassLoader(loader);
                JBProperties props = this.getProperties();
                Properties env = new Properties();
                String jnpPort = Integer.toString(JBPluginUtils.getJnpPortNumber(ip.getProperty("server-dir")));
                env.put("java.naming.factory.initial", "org.jboss.naming.NamingContextFactory");
                env.put("java.naming.provider.url", "jnp://localhost:" + jnpPort);
                env.put("java.naming.factory.object", "org.jboss.naming");
                env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                env.put("jnp.disableDiscovery", Boolean.TRUE);
                String JAVA_SEC_AUTH_LOGIN_CONF = "java.security.auth.login.config";
                String oldAuthConf = System.getProperty("java.security.auth.login.config");
                env.put("java.naming.security.principal", props.getUsername());
                env.put("java.naming.security.credentials", props.getPassword());
                env.put("jmx.remote.credentials", new String[]{props.getUsername(), props.getPassword()});
                File securityConf = new File(props.getRootDir(), "/client/auth.conf");
                if (securityConf.exists()) {
                    env.put("java.naming.factory.initial", "org.jboss.security.jndi.LoginInitialContextFactory");
                    System.setProperty("java.security.auth.login.config", securityConf.getAbsolutePath());
                }
                if (!props.isVersion(JBPluginUtils.JBOSS_7_0_0)) {
                    ctx = new InitialContext(env);
                }
                if (oldAuthConf != null) {
                    System.setProperty("java.security.auth.login.config", oldAuthConf);
                } else {
                    System.clearProperty("java.security.auth.login.config");
                }
                MBeanServerConnection rmiServer = null;
                try {
                    int port = JBPluginUtils.getJmxPortNumber(props, ip);
                    JMXServiceURL url = props.isVersion(JBPluginUtils.JBOSS_7_0_0) ? new JMXServiceURL(System.getProperty("jmx.service.url", "service:jmx:remoting-jmx://localhost:" + port)) : new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi");
                    conn = JMXConnectorFactory.connect(url);
                    rmiServer = conn.getMBeanServerConnection();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
                if (rmiServer == null && ctx != null) {
                    rmiServer = (MBeanServerConnection)ctx.lookup("/jmx/invoker/RMIAdaptor");
                }
                JBoss5ProfileServiceProxy profileService = null;
                try {
                    Object service;
                    if (ctx != null && (service = ctx.lookup("ProfileService")) != null) {
                        profileService = new JBoss5ProfileServiceProxy(service);
                    }
                }
                catch (NameNotFoundException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
                if (rmiServer != null) {
                    T t = action.action(rmiServer, profileService);
                    return t;
                }
                throw new IllegalStateException("No rmi server acquired for " + this.realUri);
            }
            catch (NameNotFoundException ex) {
                LOGGER.log(Level.FINE, null, ex);
                throw new ExecutionException(ex);
            }
            catch (NamingException ex) {
                LOGGER.log(Level.FINE, null, ex);
                throw new ExecutionException(ex);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, null, ex);
                this.killRemotingThreads(threads);
                throw new ExecutionException(ex);
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }

    private Set<Thread> getThreads() {
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        int attempts = 3;
        HashSet<Thread> threadSet = new HashSet<Thread>();
        while (attempts > 0) {
            int count = g.activeCount() + 8;
            Thread[] threads = new Thread[count];
            if (g.enumerate(threads) >= count) continue;
            threadSet.addAll(Arrays.asList(threads));
            break;
        }
        if (attempts == 0) {
            return null;
        }
        return threadSet;
    }

    private void killRemotingThreads(Set<Thread> threads) {
        Set<Thread> newThreads;
        if (threads != null && (newThreads = this.getThreads()) != null) {
            newThreads.removeAll(threads);
            for (Thread t : newThreads) {
                if (!t.getName().contains("Remoting \"endpoint\"")) continue;
                try {
                    LOGGER.log(Level.INFO, "Going to shutdown pool containing thread \"{0}\"", t.getName());
                    Field f = t.getClass().getDeclaredField("worker");
                    f.setAccessible(true);
                    Object worker = f.get(t);
                    if (worker == null) continue;
                    Method m = worker.getClass().getMethod("shutdown", null);
                    m.setAccessible(true);
                    m.invoke(worker, (Object[])null);
                    LOGGER.log(Level.INFO, "Shutdown succesfull");
                }
                catch (NoSuchFieldException ex1) {
                    LOGGER.log(Level.FINE, null, ex1);
                }
                catch (SecurityException ex1) {
                    LOGGER.log(Level.FINE, null, ex1);
                }
                catch (IllegalAccessException ex1) {
                    LOGGER.log(Level.FINE, null, ex1);
                }
                catch (NoSuchMethodException ex1) {
                    LOGGER.log(Level.FINE, null, ex1);
                }
                catch (InvocationTargetException ex1) {
                    LOGGER.log(Level.FINE, null, ex1);
                }
            }
        }
    }

    public static boolean isRunningLastCheck(InstanceProperties ip) {
        boolean isRunning = propertiesToIsRunning.containsKey(ip) && propertiesToIsRunning.get(ip).equals(Boolean.TRUE);
        return isRunning;
    }

    public static void setRunningLastCheck(InstanceProperties ip, Boolean isRunning) {
        assert (ip != null);
        propertiesToIsRunning.put(ip, isRunning);
    }

    public boolean isAs7() {
        if (this.as7 == null) {
            this.as7 = this.getProperties().isVersion(JBPluginUtils.JBOSS_7_0_0);
        }
        return this.as7;
    }

    public ProgressObject distribute(Target[] target, File file, File file2) throws IllegalStateException {
        if (this.isAs7()) {
            return new JB7Deployer(this.realUri, this).deploy(target, file, file2, this.getHost(), this.getPort());
        }
        return new JBDeployer(this.realUri, this).deploy(target, file, file2, this.getHost(), this.getPort());
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        throw new RuntimeException("This method should never be called.");
    }

    public ProgressObject redeploy(final TargetModuleID[] targetModuleID, final InputStream inputStream, final InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<ProgressObject>(){

                @Override
                public ProgressObject execute(DeploymentManager manager) throws ExecutionException {
                    if (JBDeploymentManager.this.isAs7()) {
                        return manager.redeploy(JBDeploymentManager.this.translateForUndeploy(targetModuleID), inputStream, inputStream2);
                    }
                    return manager.redeploy(targetModuleID, inputStream, inputStream2);
                }
            });
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalStateException) {
                throw (IllegalStateException)ex.getCause();
            }
            throw new IllegalStateException(ex.getCause());
        }
    }

    public ProgressObject distribute(Target[] target, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public ProgressObject distribute(Target[] target, ModuleType moduleType, InputStream inputStream, InputStream inputStream0) throws IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public ProgressObject undeploy(final TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<ProgressObject>(){

                @Override
                public ProgressObject execute(DeploymentManager manager) throws ExecutionException {
                    if (JBDeploymentManager.this.isAs7()) {
                        return manager.undeploy(JBDeploymentManager.this.translateForUndeploy(targetModuleID));
                    }
                    return manager.undeploy(targetModuleID);
                }
            });
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalStateException) {
                throw (IllegalStateException)ex.getCause();
            }
            throw new IllegalStateException(ex.getCause());
        }
    }

    public ProgressObject stop(final TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<ProgressObject>(){

                @Override
                public ProgressObject execute(DeploymentManager manager) throws ExecutionException {
                    return manager.stop(targetModuleID);
                }
            });
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalStateException) {
                throw (IllegalStateException)ex.getCause();
            }
            throw new IllegalStateException(ex.getCause());
        }
    }

    public ProgressObject start(final TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<ProgressObject>(){

                @Override
                public ProgressObject execute(DeploymentManager manager) throws ExecutionException {
                    if (JBDeploymentManager.this.isAs7()) {
                        return manager.start(JBDeploymentManager.unwrap(targetModuleID));
                    }
                    return manager.start(targetModuleID);
                }
            });
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalStateException) {
                throw (IllegalStateException)ex.getCause();
            }
            throw new IllegalStateException(ex.getCause());
        }
    }

    public TargetModuleID[] getAvailableModules(final ModuleType moduleType, final Target[] target) throws TargetException, IllegalStateException {
        if (this.isAs7()) {
            if (this.df == null) {
                throw new IllegalStateException("Deployment manager is disconnected");
            }
            try {
                return this.executeAction(new Action<TargetModuleID[]>(){

                    @Override
                    public TargetModuleID[] execute(DeploymentManager manager) throws ExecutionException {
                        try {
                            TargetModuleID[] ids = manager.getAvailableModules(moduleType, target);
                            if (ids != null) {
                                return ids;
                            }
                            return new TargetModuleID[0];
                        }
                        catch (TargetException ex) {
                            throw new ExecutionException(ex);
                        }
                        catch (IllegalStateException ex) {
                            throw new ExecutionException(ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof TargetException) {
                    throw (TargetException)ex.getCause();
                }
                if (ex.getCause() instanceof IllegalStateException) {
                    throw (IllegalStateException)ex.getCause();
                }
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getNonRunningModules(final ModuleType moduleType, final Target[] target) throws TargetException, IllegalStateException {
        if (this.isAs7()) {
            if (this.df == null) {
                throw new IllegalStateException("Deployment manager is disconnected");
            }
            try {
                return this.executeAction(new Action<TargetModuleID[]>(){

                    @Override
                    public TargetModuleID[] execute(DeploymentManager manager) throws ExecutionException {
                        try {
                            TargetModuleID[] ids = manager.getNonRunningModules(moduleType, target);
                            if (ids != null) {
                                return ids;
                            }
                            return new TargetModuleID[0];
                        }
                        catch (TargetException ex) {
                            throw new ExecutionException(ex);
                        }
                        catch (IllegalStateException ex) {
                            throw new ExecutionException(ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof TargetException) {
                    throw (TargetException)ex.getCause();
                }
                if (ex.getCause() instanceof IllegalStateException) {
                    throw (IllegalStateException)ex.getCause();
                }
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getRunningModules(final ModuleType moduleType, final Target[] target) throws TargetException, IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<TargetModuleID[]>(){

                @Override
                public TargetModuleID[] execute(DeploymentManager manager) throws ExecutionException {
                    try {
                        TargetModuleID[] ids = manager.getRunningModules(moduleType, target);
                        if (ids != null) {
                            return ids;
                        }
                        return new TargetModuleID[0];
                    }
                    catch (TargetException ex) {
                        throw new ExecutionException(ex);
                    }
                    catch (IllegalStateException ex) {
                        throw new ExecutionException(ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof TargetException) {
                throw (TargetException)ex.getCause();
            }
            if (ex.getCause() instanceof IllegalStateException) {
                throw (IllegalStateException)ex.getCause();
            }
            LOGGER.log(Level.INFO, null, ex);
            return new TargetModuleID[0];
        }
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        if (this.isAs7()) {
            return new JB7Deployer(this.realUri, this).redeploy(targetModuleID, file, file2);
        }
        return new JBDeployer(this.realUri, this).redeploy(targetModuleID, file, file2);
    }

    public void release() {
    }

    public boolean isRedeploySupported() {
        try {
            return this.executeAction(new Action<Boolean>(){

                @Override
                public Boolean execute(DeploymentManager manager) throws ExecutionException {
                    try {
                        return manager.isRedeploySupported();
                    }
                    catch (IllegalStateException ex) {
                        throw new ExecutionException(ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex);
            return false;
        }
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isLocaleSupported(Locale locale) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale getCurrentLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale getDefaultLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale[] getSupportedLocales() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Target[] getTargets() throws IllegalStateException {
        if (this.df == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<Target[]>(){

                @Override
                public Target[] execute(DeploymentManager manager) throws ExecutionException {
                    try {
                        return manager.getTargets();
                    }
                    catch (IllegalStateException ex) {
                        throw new ExecutionException(ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalStateException) {
                throw (IllegalStateException)ex.getCause();
            }
            LOGGER.log(Level.INFO, null, ex);
            return new Target[0];
        }
    }

    public JBJ2eePlatformFactory.J2eePlatformImplImpl getJBPlatform() {
        if (this.jbPlatform == null) {
            this.jbPlatform = (JBJ2eePlatformFactory.J2eePlatformImplImpl)new JBJ2eePlatformFactory().getJ2eePlatformImpl(this);
        }
        return this.jbPlatform;
    }

    public JBProperties getProperties() {
        return new JBProperties(this);
    }

    public synchronized void setNeedsRestart(boolean needsRestart) {
        this.needsRestart = needsRestart;
    }

    public synchronized boolean getNeedsRestart() {
        return this.needsRestart;
    }

    private TargetModuleID[] translateForUndeploy(TargetModuleID[] ids) {
        String deployDir = this.getInstanceProperties().getProperty("deploy-dir");
        if (deployDir != null) {
            TargetModuleID[] ret = new TargetModuleID[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                File testFile = new File(deployDir, ids[i].getModuleID());
                try {
                    ret[i] = new WrappedTargetModuleID(ids[i], null, testFile.toURI().toURL().toString(), null);
                    continue;
                }
                catch (MalformedURLException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                    ret[i] = ids[i];
                }
            }
            return ret;
        }
        return ids;
    }

    private static TargetModuleID[] unwrap(TargetModuleID[] ids) {
        if (ids == null || ids.length == 0) {
            return ids;
        }
        TargetModuleID[] ret = new TargetModuleID[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ret[i] = ids[i] instanceof WrappedTargetModuleID ? ((WrappedTargetModuleID)ids[i]).getOriginal() : ids[i];
        }
        return ret;
    }

    private static void closeTargets(Target[] targets) {
        if (targets == null) {
            return;
        }
        for (Target target : targets) {
            try {
                Field f = target.getClass().getDeclaredField("modelControllerClient");
                f.setAccessible(true);
                Object value = f.get(target);
                if (value == null) continue;
                Method m = value.getClass().getDeclaredMethod("close", null);
                m.invoke(value, null);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
    }

    private static interface Action<T> {
        public T execute(DeploymentManager var1) throws ExecutionException;
    }
}

