/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.htmlui;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import net.java.html.boot.fx.FXBrowsers;
import org.openide.util.NbBundle;

final class NbBrowsers {
    NbBrowsers() {
    }

    public static void load(WebView view, URL page, Runnable onPageLoad, ClassLoader loader, Object ... args) {
        final Stage stage = null;
        view.setContextMenuEnabled(false);
        view.getEngine().setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> t) {
                Stage dialogStage = new Stage();
                dialogStage.initModality(Modality.WINDOW_MODAL);
                dialogStage.initOwner((Window)stage);
                ResourceBundle r = NbBundle.getBundle(NbBrowsers.class);
                dialogStage.setTitle(r.getString("AlertTitle"));
                Button button = new Button(r.getString("AlertCloseButton"));
                Text text = new Text((String)t.getData());
                VBox box = new VBox();
                box.setAlignment(Pos.CENTER);
                box.setSpacing(10.0);
                box.setPadding(new Insets(10.0));
                box.getChildren().addAll((Object[])new Node[]{text, button});
                dialogStage.setScene(new Scene((Parent)box));
                button.setCancelButton(true);
                button.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, null));
                dialogStage.centerOnScreen();
                dialogStage.showAndWait();
            }
        });
        view.getEngine().setConfirmHandler((Callback)new Callback<String, Boolean>(){

            public Boolean call(String question) {
                Stage dialogStage = new Stage();
                dialogStage.initModality(Modality.WINDOW_MODAL);
                dialogStage.initOwner((Window)stage);
                ResourceBundle r = NbBundle.getBundle(NbBrowsers.class);
                dialogStage.setTitle(r.getString("ConfirmTitle"));
                Button ok = new Button(r.getString("ConfirmOKButton"));
                Button cancel = new Button(r.getString("ConfirmCancelButton"));
                Text text = new Text(question);
                Insets ins = new Insets(10.0);
                VBox box = new VBox();
                box.setAlignment(Pos.CENTER);
                box.setSpacing(10.0);
                box.setPadding(ins);
                HBox buttons = new HBox(10.0);
                buttons.getChildren().addAll((Object[])new Node[]{ok, cancel});
                buttons.setAlignment(Pos.CENTER);
                buttons.setPadding(ins);
                box.getChildren().addAll((Object[])new Node[]{text, buttons});
                dialogStage.setScene(new Scene((Parent)box));
                ok.setCancelButton(false);
                boolean[] res = new boolean[1];
                ok.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, res));
                cancel.setCancelButton(true);
                cancel.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, null));
                dialogStage.centerOnScreen();
                dialogStage.showAndWait();
                return res[0];
            }
        });
        view.getEngine().setPromptHandler((Callback)new Callback<PromptData, String>(){

            public String call(PromptData prompt) {
                Stage dialogStage = new Stage();
                dialogStage.initModality(Modality.WINDOW_MODAL);
                dialogStage.initOwner((Window)stage);
                ResourceBundle r = NbBundle.getBundle(NbBrowsers.class);
                dialogStage.setTitle(r.getString("PromptTitle"));
                Button ok = new Button(r.getString("PromptOKButton"));
                Button cancel = new Button(r.getString("PromptCancelButton"));
                Text text = new Text(prompt.getMessage());
                TextField line = new TextField();
                if (prompt.getDefaultValue() != null) {
                    line.setText(prompt.getDefaultValue());
                }
                Insets ins = new Insets(10.0);
                VBox box = new VBox();
                box.setAlignment(Pos.CENTER);
                box.setSpacing(10.0);
                box.setPadding(ins);
                HBox buttons = new HBox(10.0);
                buttons.getChildren().addAll((Object[])new Node[]{ok, cancel});
                buttons.setAlignment(Pos.CENTER);
                buttons.setPadding(ins);
                box.getChildren().addAll((Object[])new Node[]{text, line, buttons});
                dialogStage.setScene(new Scene((Parent)box));
                ok.setCancelButton(false);
                boolean[] res = new boolean[1];
                ok.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, res));
                cancel.setCancelButton(true);
                cancel.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, null));
                dialogStage.centerOnScreen();
                dialogStage.showAndWait();
                return res[0] ? line.getText() : null;
            }
        });
        FXBrowsers.load((WebView)view, (URL)page, (Runnable)onPageLoad, (ClassLoader)loader, (Object[])args);
    }

    private static final class CloseDialogHandler
    implements EventHandler<ActionEvent> {
        private final Stage dialogStage;
        private final boolean[] res;

        public CloseDialogHandler(Stage dialogStage, boolean[] res) {
            this.dialogStage = dialogStage;
            this.res = res;
        }

        public void handle(ActionEvent t) {
            this.dialogStage.close();
            if (this.res != null) {
                this.res[0] = true;
            }
        }
    }
}

