/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.build2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.build2.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class BuildOptionsVisual
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String buildContext;
    private JButton dockerfileButton;
    private JLabel dockerfileLabel;
    private JTextField dockerfileTextField;
    private JCheckBox noCacheCheckBox;
    private JCheckBox pullCheckBox;

    public BuildOptionsVisual() {
        this.initComponents();
        this.dockerfileTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BuildOptionsVisual.this.changeSupport.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BuildOptionsVisual.this.changeSupport.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BuildOptionsVisual.this.changeSupport.fireChange();
            }
        });
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void setBuildContext(String buildContext) {
        this.buildContext = buildContext;
    }

    public String getDockerfile() {
        return UiUtils.getValue(this.dockerfileTextField);
    }

    public void setDockerfile(String dockerfile) {
        this.dockerfileTextField.setText(dockerfile);
    }

    public boolean isPull() {
        return this.pullCheckBox.isSelected();
    }

    public void setPull(boolean pull) {
        this.pullCheckBox.setSelected(pull);
    }

    public boolean isNoCache() {
        return this.noCacheCheckBox.isSelected();
    }

    public void setNoCache(boolean noCache) {
        this.noCacheCheckBox.setSelected(noCache);
    }

    @Override
    public String getName() {
        return Bundle.LBL_BuildOptions();
    }

    private void initComponents() {
        this.dockerfileLabel = new JLabel();
        this.dockerfileTextField = new JTextField();
        this.dockerfileButton = new JButton();
        this.pullCheckBox = new JCheckBox();
        this.noCacheCheckBox = new JCheckBox();
        this.dockerfileLabel.setLabelFor(this.dockerfileTextField);
        Mnemonics.setLocalizedText((JLabel)this.dockerfileLabel, (String)NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.dockerfileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.dockerfileButton, (String)NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.dockerfileButton.text"));
        this.dockerfileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildOptionsVisual.this.dockerfileButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pullCheckBox, (String)NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.pullCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.noCacheCheckBox, (String)NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.noCacheCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.dockerfileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dockerfileTextField, -1, 244, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dockerfileButton)).addComponent(this.pullCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.noCacheCheckBox, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dockerfileLabel).addComponent(this.dockerfileTextField, -2, -1, -2).addComponent(this.dockerfileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pullCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.noCacheCheckBox)));
    }

    private void dockerfileButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        String dockerText = UiUtils.getValue(this.dockerfileTextField);
        if (dockerText != null) {
            File file = new File(dockerText);
            if (!file.isAbsolute()) {
                file = new File(this.buildContext, dockerText);
            }
            chooser.setSelectedFile(file);
        }
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.dockerfileTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }
}

