/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.run;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerImageDetail;
import org.netbeans.modules.docker.ui.Validations;
import org.netbeans.modules.docker.ui.run.RunContainerPropertiesVisual;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public class RunContainerPropertiesPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DockerImageDetail info;
    private RunContainerPropertiesVisual component;
    private WizardDescriptor wizard;

    public RunContainerPropertiesPanel(DockerImageDetail info) {
        this.info = info;
    }

    public RunContainerPropertiesVisual getComponent() {
        if (this.component == null) {
            this.component = new RunContainerPropertiesVisual();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isFinishPanel() {
        return true;
    }

    public boolean isValid() {
        String message;
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        this.wizard.putProperty("WizardPanel_infoMessage", null);
        this.wizard.putProperty("WizardPanel_warningMessage", null);
        String name = this.component.getContainerName();
        if (name != null && (message = Validations.validateContainer(name)) != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor wiz) {
        if (this.wizard == null) {
            this.wizard = wiz;
        }
        this.component.setContainerName((String)wiz.getProperty("name"));
        this.component.setCommand((String)wiz.getProperty("command"));
        this.component.setUser((String)wiz.getProperty("user"));
        Boolean interactive = (Boolean)wiz.getProperty("interactive");
        this.component.setInteractive(interactive != null ? interactive : false);
        Boolean tty = (Boolean)wiz.getProperty("tty");
        this.component.setTty(tty != null ? tty : false);
        this.changeSupport.fireChange();
    }

    public void storeSettings(WizardDescriptor wiz) {
        wiz.putProperty("name", (Object)this.component.getContainerName());
        wiz.putProperty("command", (Object)this.component.getCommand());
        wiz.putProperty("user", (Object)this.component.getUser());
        wiz.putProperty("interactive", (Object)this.component.isInteractive());
        wiz.putProperty("tty", (Object)this.component.hasTty());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }
}

