/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.diff;

import java.awt.EventQueue;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.diff.Bundle;
import org.netbeans.modules.git.remote.ui.diff.DiffAction;
import org.netbeans.modules.git.remote.ui.diff.DiffCurrentToTrackedAction;
import org.netbeans.modules.git.remote.ui.fetch.FetchUtils;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.repository.Revision;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class DiffCurrentToRepositoryAction
extends GitAction {
    @Override
    protected boolean enable(Node[] activatedNodes) {
        VCSContext context = this.getCurrentContext(activatedNodes);
        return GitUtils.getRepositoryRoots(context).size() == 1;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = this.getCurrentContext(nodes);
        this.diffToRepositoryHead(context);
    }

    public void diffToRepositoryHead(final VCSContext context) {
        if (GitUtils.getRepositoryRoots(context).size() == 1) {
            final VCSFileProxy repository = GitUtils.getRootFile(context);
            new GitProgressSupport(){

                @Override
                protected void perform() {
                    RepositoryInfo info = RepositoryInfo.getInstance(repository);
                    GitBranch branch = info.getActiveBranch();
                    try {
                        final Revision fetchedHead = FetchUtils.fetchToTemp(this.getClient(), this.getProgressMonitor(), branch);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (fetchedHead == null) {
                                    ((DiffCurrentToTrackedAction)SystemAction.get(DiffCurrentToTrackedAction.class)).diffToTracked(context);
                                    return;
                                }
                                ((DiffAction)SystemAction.get(DiffAction.class)).diff(context, new Revision.BranchReference(Bundle.CTL_RemoteRepository_HEAD(fetchedHead.getRevision()), fetchedHead.getCommitId()), Revision.HEAD);
                            }
                        });
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                        return;
                    }
                }
            }.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_DiffCurrentToRepositoryAction_progress());
        }
    }
}

