/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.fetch;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRemoteConfig;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.remote.ui.fetch.Bundle;
import org.netbeans.modules.git.remote.ui.fetch.FetchAction;
import org.netbeans.modules.git.remote.ui.fetch.FetchUtils;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class FetchFromUpstreamAction
extends MultipleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/remote/resources/icons/fetch.png";

    public FetchFromUpstreamAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected RequestProcessor.Task performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        return this.fetch(repository);
    }

    private RequestProcessor.Task fetch(final VCSFileProxy repository) {
        final RequestProcessor.Task[] t = new RequestProcessor.Task[1];
        GitProgressSupport.NoOutputLogging supp = new GitProgressSupport.NoOutputLogging(){

            @Override
            protected void perform() {
                GitRemoteConfig cfg;
                RepositoryInfo info = RepositoryInfo.getInstance(repository);
                try {
                    info.refreshRemotes();
                }
                catch (GitException ex) {
                    Logger.getLogger(FetchFromUpstreamAction.class.getName()).log(Level.INFO, null, ex);
                }
                GitBranch trackedBranch = GitUtils.getTrackedBranch(info, null);
                String errorLabel = Bundle.LBL_Fetch_fetchFromUpstreamFailed();
                if (trackedBranch == null) {
                    cfg = info.getRemotes().get("origin");
                    if (cfg == null) {
                        GitUtils.notifyError(errorLabel, Bundle.MSG_FetchFromUpstreamAction_error_noRemote(repository.getName()));
                    }
                } else {
                    cfg = FetchUtils.getRemoteConfigForActiveBranch(trackedBranch, info, errorLabel);
                }
                if (cfg == null) {
                    return;
                }
                String uri = (String)cfg.getUris().get(0);
                Utils.logVCSExternalRepository((String)"GIT", (String)uri);
                if (!this.isCanceled()) {
                    t[0] = ((FetchAction)SystemAction.get(FetchAction.class)).fetch(repository, uri, cfg.getFetchRefSpecs(), null);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_FetchFromUpstreamAction_preparing()).waitFinished();
        return t[0];
    }
}

