/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.utils;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.FileStatusCache;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.GitStatusNode;
import org.netbeans.modules.git.remote.VersionsCache;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRemoteConfig;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.GitURI;
import org.netbeans.modules.git.remote.cli.RefUtils;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.client.CredentialsCallback;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.ui.blame.AnnotateAction;
import org.netbeans.modules.git.remote.ui.commit.CommitAction;
import org.netbeans.modules.git.remote.ui.ignore.IgnoreAction;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.status.StatusAction;
import org.netbeans.modules.git.remote.utils.Bundle;
import org.netbeans.modules.remotefs.versioning.api.FileObjectIndexingBridgeProvider;
import org.netbeans.modules.remotefs.versioning.api.FileSelector;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.QuickSearch;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public final class GitUtils {
    public static final String DOT_GIT = ".git";
    public static final String INDEX_LOCK = "index.lock";
    private static final Pattern METADATA_PATTERN = Pattern.compile(".*\\/(\\.)git(\\/.*|$)");
    private static final String FILENAME_GITIGNORE = ".gitignore";
    public static final String HEAD = "HEAD";
    public static final String INDEX = "INDEX";
    public static final String CURRENT = "CURRENT";
    public static final String PREFIX_R_HEADS = "refs/heads/";
    public static final String PREFIX_R_TAGS = "refs/tags/";
    public static final String PREFIX_R_REMOTES = "refs/remotes/";
    public static final ProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    public static final String MASTER = "master";
    private static final Set<VCSFileProxy> loggedRepositories = new HashSet<VCSFileProxy>();
    public static final String REMOTE_ORIGIN = "origin";
    public static final String ORIGIN = "origin";
    private static final Map<VCSFileProxy, Set<String>> notSharable = Collections.synchronizedMap(new HashMap(5));
    private static final String REF_SPEC_PATTERN = "+refs/heads/{0}:refs/remotes/{1}/{0}";
    private static final String REF_SPEC_GLOBAL_PATTERN = "+refs/heads/*:refs/remotes/{0}/*";
    public static final String REF_SPEC_DEL_PREFIX = ":refs/remotes/";
    private static final String REF_PUSHSPEC_PATTERN = "refs/heads/{0}:refs/heads/{1}";
    public static final String REF_PUSHSPEC_DEL_PREFIX = ":refs/heads/";
    private static final String REF_TAG_PUSHSPEC_PATTERN = "refs/tags/{0}:refs/tags/{0}";
    private static final String REF_TAG_PUSHSPEC_PATTERN_FORCE = "+refs/tags/{0}:refs/tags/{0}";
    static ThreadLocal<Set<VCSFileProxy>> indexingFiles = new ThreadLocal();

    public static boolean isPartOfGitMetadata(VCSFileProxy file) {
        return METADATA_PATTERN.matcher(file.getPath()).matches();
    }

    public static boolean isAdministrative(VCSFileProxy file) {
        String name = file.getName();
        return GitUtils.isAdministrative(name) && file.isDirectory();
    }

    public static boolean isAdministrative(String fileName) {
        return fileName.equals(DOT_GIT);
    }

    public static boolean repositoryExistsFor(VCSFileProxy file) {
        return VCSFileProxy.createFileProxy((VCSFileProxy)file, (String)DOT_GIT).exists();
    }

    public static VCSFileProxy getGitFolderForRoot(VCSFileProxy repositoryRoot) {
        return VCSFileProxy.createFileProxy((VCSFileProxy)repositoryRoot, (String)DOT_GIT).normalizeFile();
    }

    public static boolean prepareRootFiles(VCSFileProxy repository, Collection<VCSFileProxy> filesUnderRoot, VCSFileProxy file) {
        boolean added = false;
        HashSet<VCSFileProxy> filesToRemove = new HashSet<VCSFileProxy>();
        for (VCSFileProxy fileUnderRoot : filesUnderRoot) {
            if (file.equals((Object)fileUnderRoot) || fileUnderRoot.equals((Object)repository)) {
                added = true;
                break;
            }
            if (file.equals((Object)repository)) {
                filesUnderRoot.clear();
                break;
            }
            if (file.getPath().length() < fileUnderRoot.getPath().length()) {
                if (!VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)file, (VCSFileProxy)fileUnderRoot)) continue;
                filesToRemove.add(fileUnderRoot);
                continue;
            }
            if (!VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)fileUnderRoot, (VCSFileProxy)file)) continue;
            added = true;
            break;
        }
        filesUnderRoot.removeAll(filesToRemove);
        if (!added) {
            filesUnderRoot.add(file);
        }
        return added;
    }

    public static boolean isIgnored(VCSFileProxy file, boolean checkSharability) {
        if (file == null) {
            return false;
        }
        String path = file.getPath();
        VCSFileProxy topFile = Git.getInstance().getRepositoryRoot(file);
        if (topFile == null || topFile.equals((Object)file)) {
            return false;
        }
        if (GitUtils.isNotSharable(path, topFile)) {
            return true;
        }
        VCSFileProxy parentFile = file.getParentFile();
        if (!parentFile.equals((Object)topFile) && GitUtils.isIgnored(parentFile, false)) {
            return true;
        }
        if (FILENAME_GITIGNORE.equals(file.getName())) {
            return false;
        }
        if (checkSharability && SharabilityQuery.getSharability((URI)VCSFileProxySupport.toURI((VCSFileProxy)file.normalizeFile())) == SharabilityQuery.Sharability.NOT_SHARABLE) {
            if (GitModuleConfig.getDefault().getAutoIgnoreFiles()) {
                GitUtils.ignoreNotSharableAncestor(topFile, file);
            } else {
                GitUtils.addNotSharable(topFile, path);
            }
            return true;
        }
        return false;
    }

    public static GitBranch getTrackedBranch(RepositoryInfo info, String errorLabel) {
        GitBranch activeBranch = info.getActiveBranch();
        if (activeBranch == null) {
            return null;
        }
        GitBranch trackedBranch = activeBranch.getTrackedBranch();
        if (trackedBranch == null) {
            if (errorLabel != null) {
                GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noTrackedBranch(activeBranch.getName()));
            }
            return null;
        }
        if (!trackedBranch.isRemote()) {
            if (errorLabel != null) {
                GitUtils.notifyError(errorLabel, Bundle.MSG_Err_trackedBranchLocal(trackedBranch.getName()));
            }
            return null;
        }
        return trackedBranch;
    }

    public static void notifyError(String errorLabel, String errorMessage) {
        NotifyDescriptor nd = new NotifyDescriptor((Object)errorMessage, errorLabel, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
    }

    public static String parseRemoteHeadFromFetch(String fetchRefSpec) {
        int pos;
        if (fetchRefSpec.startsWith("+")) {
            fetchRefSpec = fetchRefSpec.substring(1);
        }
        if ((pos = fetchRefSpec.indexOf(58)) > 0) {
            return fetchRefSpec.substring(0, pos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNotSharable(VCSFileProxy topFile, String ignoredPath) {
        Map<VCSFileProxy, Set<String>> map = notSharable;
        synchronized (map) {
            Set<String> ignores = notSharable.get(topFile);
            if (ignores == null) {
                ignores = new HashSet<String>();
            }
            String patternCandidate = ignoredPath;
            Iterator<String> it = ignores.iterator();
            while (it.hasNext()) {
                String storedPattern = it.next();
                if (storedPattern.equals(ignoredPath) || ignoredPath.startsWith(storedPattern + '/')) {
                    patternCandidate = null;
                    break;
                }
                if (!storedPattern.startsWith(ignoredPath + '/')) continue;
                it.remove();
            }
            if (patternCandidate != null) {
                ignores.add(patternCandidate);
            }
            notSharable.put(topFile, ignores);
        }
    }

    private static boolean isNotSharable(String path, VCSFileProxy topFile) {
        boolean retval = false;
        Set<String> notSharablePaths = notSharable.get(topFile);
        if (notSharablePaths == null) {
            notSharablePaths = Collections.emptySet();
        }
        retval = notSharablePaths.contains(path);
        return retval;
    }

    private static void ignoreNotSharableAncestor(VCSFileProxy topFile, VCSFileProxy notSharableFile) {
        VCSFileProxy parent;
        if (topFile.equals((Object)notSharableFile)) {
            throw new IllegalStateException("Trying to ignore " + notSharableFile + " in " + topFile);
        }
        while (!topFile.equals((Object)(parent = notSharableFile.getParentFile())) && SharabilityQuery.getSharability((URI)VCSFileProxySupport.toURI((VCSFileProxy)parent.normalizeFile())) == SharabilityQuery.Sharability.NOT_SHARABLE) {
            notSharableFile = parent;
        }
        GitUtils.addNotSharable(topFile, notSharableFile.getPath());
        if (notSharableFile.isDirectory()) {
            for (VCSFileProxy f : Git.getInstance().getCreatedFolders()) {
                if (!VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)f, (VCSFileProxy)notSharableFile)) continue;
                ((IgnoreAction)SystemAction.get(IgnoreAction.class)).ignoreFolders(topFile, new VCSFileProxy[]{notSharableFile});
            }
        }
    }

    public static boolean isFromGitRepository(VCSContext context) {
        return GitUtils.getRootFile(context) != null;
    }

    public static VCSFileProxy getRootFile(VCSContext context) {
        if (context == null) {
            return null;
        }
        Git git = Git.getInstance();
        VCSFileProxy[] files = context.getRootFiles().toArray(new VCSFileProxy[context.getRootFiles().size()]);
        if (files == null || files.length == 0) {
            return null;
        }
        VCSFileProxy root = git.getRepositoryRoot(files[0]);
        return root;
    }

    public static Set<VCSFileProxy> getRepositoryRoots(VCSContext context) {
        Set rootsSet = context.getRootFiles();
        return GitUtils.getRepositoryRoots(rootsSet);
    }

    public static Set<VCSFileProxy> getRepositoryRoots(Collection<VCSFileProxy> roots) {
        HashSet<VCSFileProxy> ret = new HashSet<VCSFileProxy>();
        for (VCSFileProxy file : roots) {
            VCSFileProxy repoRoot;
            if (!Git.getInstance().isManaged(file) || (repoRoot = Git.getInstance().getRepositoryRoot(file)) == null) continue;
            ret.add(repoRoot);
        }
        return ret;
    }

    public static AbstractMap.SimpleImmutableEntry<VCSFileProxy, VCSFileProxy[]> getActionRoots(VCSContext ctx) {
        List l;
        Set rootsSet = ctx.getRootFiles();
        HashMap<VCSFileProxy, LinkedList<VCSFileProxy>> map = new HashMap<VCSFileProxy, LinkedList<VCSFileProxy>>();
        for (VCSFileProxy file : rootsSet) {
            VCSFileProxy repoRoot;
            if (!Git.getInstance().isManaged(file) || (repoRoot = Git.getInstance().getRepositoryRoot(file)) == null) continue;
            l = (LinkedList<VCSFileProxy>)map.get(repoRoot);
            if (l == null) {
                l = new LinkedList<VCSFileProxy>();
                map.put(repoRoot, (LinkedList<VCSFileProxy>)l);
            }
            l.add(file);
        }
        Set repoRoots = map.keySet();
        if (map.size() > 1) {
            FileSelector fs = new FileSelector(NbBundle.getMessage(GitUtils.class, (String)"LBL_FileSelector_Title"), NbBundle.getMessage(GitUtils.class, (String)"FileSelector.jLabel1.text"), new HelpCtx("org.netbeans.modules.git.remote.FileSelector"), GitModuleConfig.getDefault().getPreferences());
            if (fs.show(repoRoots.toArray(new VCSFileProxy[repoRoots.size()]))) {
                VCSFileProxy selection = fs.getSelectedFile();
                l = (List)map.get(selection);
                return new AbstractMap.SimpleImmutableEntry<VCSFileProxy, VCSFileProxy[]>(selection, l.toArray(new VCSFileProxy[l.size()]));
            }
            return null;
        }
        if (map.isEmpty()) {
            return null;
        }
        VCSFileProxy root = (VCSFileProxy)map.keySet().iterator().next();
        List l2 = (List)map.get(root);
        return new AbstractMap.SimpleImmutableEntry<VCSFileProxy, VCSFileProxy[]>(root, l2.toArray(new VCSFileProxy[l2.size()]));
    }

    public static VCSFileProxy[] filterForRepository(VCSContext ctx, VCSFileProxy repository) {
        VCSFileProxy[] files = null;
        if (ctx != null) {
            Set s = ctx.getRootFiles();
            files = s.toArray(new VCSFileProxy[s.size()]);
        }
        if (files != null) {
            LinkedList<VCSFileProxy> l = new LinkedList<VCSFileProxy>();
            for (VCSFileProxy file : files) {
                VCSFileProxy r = Git.getInstance().getRepositoryRoot(file);
                if (r == null || !r.equals((Object)repository)) continue;
                l.add(file);
            }
            files = l.toArray(new VCSFileProxy[l.size()]);
        }
        return files;
    }

    public static VCSFileProxy[] flatten(VCSFileProxy[] files, Set<FileInformation.Status> statuses) {
        LinkedList<VCSFileProxy> ret = new LinkedList<VCSFileProxy>();
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        for (int i = 0; i < files.length; ++i) {
            VCSFileProxy dir = files[i];
            FileInformation info = cache.getStatus(dir);
            if (info.containsStatus(statuses)) {
                ret.add(dir);
            }
            VCSFileProxy[] entries = cache.listFiles(dir);
            for (int e = 0; e < entries.length; ++e) {
                VCSFileProxy entry = entries[e];
                info = cache.getStatus(entry);
                if (!info.containsStatus(statuses)) continue;
                ret.add(entry);
            }
        }
        return ret.toArray(new VCSFileProxy[ret.size()]);
    }

    public static VCSFileProxy[] listFiles(VCSFileProxy[] roots, EnumSet<FileInformation.Status> includedStatuses) {
        VCSFileProxy[][] split = VCSFileProxySupport.splitFlatOthers((VCSFileProxy[])roots);
        ArrayList<VCSFileProxy> fileList = new ArrayList<VCSFileProxy>();
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        for (int c = 0; c < split.length; ++c) {
            VCSFileProxy[] splitRoots = split[c];
            if (c == 1) {
                fileList.addAll(Arrays.asList(cache.listFiles(splitRoots, includedStatuses)));
                continue;
            }
            fileList.addAll(Arrays.asList(GitUtils.flatten(splitRoots, includedStatuses)));
        }
        return fileList.toArray(new VCSFileProxy[fileList.size()]);
    }

    public static VCSContext getCurrentContext(Node[] nodes) {
        if (nodes == null) {
            nodes = TopComponent.getRegistry().getActivatedNodes();
        }
        return VCSContext.forNodes((Node[])nodes);
    }

    public static String getMimeType(VCSFileProxy file) {
        String foMime;
        FileObject fo = file.toFileObject();
        boolean hasMime = false;
        if (fo == null) {
            foMime = "content/unknown";
        } else {
            foMime = fo.getMIMEType();
            if ("content/unknown".equals(foMime)) {
                foMime = "text/plain";
            } else {
                hasMime = true;
            }
        }
        if (!hasMime) {
            return GitUtils.isFileContentBinary(file) ? "application/octet-stream" : foMime;
        }
        return foMime;
    }

    public static boolean isFileContentBinary(VCSFileProxy file) {
        FileObject fo = file.toFileObject();
        if (fo == null) {
            return false;
        }
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            return dao.getCookie(EditorCookie.class) == null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static boolean isFromInternalView(VCSContext context) {
        return context.getElements().lookup(GitStatusNode.class) != null;
    }

    public static List<String> getRelativePaths(VCSFileProxy workDir, VCSFileProxy[] roots) {
        ArrayList<String> paths = new ArrayList<String>(roots.length);
        for (VCSFileProxy root : roots) {
            if (workDir.equals((Object)root)) {
                paths.clear();
                break;
            }
            paths.add(GitUtils.getRelativePath(workDir, root));
        }
        return paths;
    }

    public static String getRelativePath(VCSFileProxy repo, VCSFileProxy file) {
        StringBuilder relativePath = new StringBuilder("");
        VCSFileProxy parent = file;
        if (!parent.equals((Object)repo)) {
            while (parent != null && !parent.equals((Object)repo)) {
                relativePath.insert(0, "/").insert(0, parent.getName());
                parent = parent.getParentFile();
            }
            if (parent == null) {
                throw new IllegalArgumentException(file.getPath() + " is not under " + repo.getPath());
            }
            relativePath.deleteCharAt(relativePath.length() - 1);
        }
        return relativePath.toString();
    }

    public static void openInVersioningView(Collection<VCSFileProxy> files, VCSFileProxy repository, ProgressMonitor pm) {
        LinkedList<AbstractNode> nodes = new LinkedList<AbstractNode>();
        for (VCSFileProxy file : files) {
            AbstractNode node = new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{file}));
            nodes.add(node);
        }
        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, files), pm);
        if (!pm.isCanceled()) {
            final VCSContext context = VCSContext.forNodes((Node[])nodes.toArray(new Node[nodes.size()]));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((StatusAction)SystemAction.get(StatusAction.class)).performContextAction(context);
                }
            });
        }
    }

    public static void printInfo(StringBuilder sb, GitRevisionInfo info) {
        GitUtils.printInfo(sb, info, true);
    }

    public static void printInfo(StringBuilder sb, GitRevisionInfo info, boolean endWithNewLine) {
        String lbrevision = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.revision");
        String lbauthor = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.author");
        String lbcommitter = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.committer");
        String lbdate = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.date");
        String lbsummary = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.summary");
        String author = info.getAuthor().toString();
        String committer = info.getCommitter().toString();
        sb.append(NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.title")).append("\n");
        sb.append(lbrevision);
        sb.append(info.getRevision());
        sb.append('\n');
        sb.append(lbauthor);
        sb.append(author);
        sb.append('\n');
        if (!author.equals(committer)) {
            sb.append(lbcommitter);
            sb.append(committer);
            sb.append('\n');
        }
        sb.append(lbdate);
        sb.append(DateFormat.getDateTimeInstance().format(new Date(info.getCommitTime())));
        sb.append('\n');
        sb.append(lbsummary);
        int prefixLen = lbsummary.length();
        sb.append(GitUtils.formatMultiLine(prefixLen, info.getFullMessage()));
        if (endWithNewLine) {
            sb.append('\n');
        }
    }

    private static String formatMultiLine(int prefixLen, String message) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < prefixLen; ++i) {
            sb.append(" ");
        }
        String prefix = sb.toString();
        String[] lines = message.split("\n");
        sb = new StringBuilder(lines.length > 0 ? lines[0] : "");
        for (int i = 1; i < lines.length; ++i) {
            sb.append("\n").append(prefix).append(lines[i]);
        }
        return sb.toString();
    }

    public static void headChanged(VCSFileProxy ... repositories) {
        Set openFiles = VCSFileProxySupport.getOpenFiles();
        HashSet<VCSFileProxy> repositorySet = new HashSet<VCSFileProxy>(Arrays.asList(repositories));
        Iterator it = openFiles.iterator();
        while (it.hasNext()) {
            VCSFileProxy file = (VCSFileProxy)it.next();
            if (repositorySet.contains(Git.getInstance().getRepositoryRoot(file))) continue;
            it.remove();
        }
        if (!openFiles.isEmpty()) {
            Git.getInstance().headChanged(openFiles);
            Git.getInstance().getHistoryProvider().fireHistoryChange(openFiles.toArray(new VCSFileProxy[openFiles.size()]));
        }
    }

    public static boolean isRepositoryLocked(VCSFileProxy repository) {
        return VCSFileProxy.createFileProxy((VCSFileProxy)GitUtils.getGitFolderForRoot(repository), (String)INDEX_LOCK).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openInRevision(VCSFileProxy originalFile, String revision1, int lineNumber, String revisionToOpen, boolean showAnnotations, ProgressMonitor pm) throws IOException {
        VCSFileProxy file1 = VersionsCache.getInstance().getFileRevision(originalFile, revision1, pm);
        if (file1 == null) {
            file1 = VCSFileProxySupport.createTempFile((VCSFileProxy)originalFile, (String)"tmp", (String)("-" + originalFile.getName()), (boolean)true);
        }
        if (pm.isCanceled()) {
            return;
        }
        VCSFileProxy file = VersionsCache.getInstance().getFileRevision(originalFile, revisionToOpen, pm);
        if (file == null) {
            file = VCSFileProxySupport.createTempFile((VCSFileProxy)originalFile, (String)"tmp", (String)("-" + originalFile.getName()), (boolean)true);
        }
        if (pm.isCanceled()) {
            return;
        }
        BufferedReader r1 = null;
        BufferedReader r2 = null;
        FileObject fo = originalFile.toFileObject();
        Charset encoding = null;
        if (fo != null) {
            encoding = FileEncodingQuery.getEncoding((FileObject)fo);
        }
        if (encoding == null) {
            encoding = FileEncodingQuery.getDefaultEncoding();
        }
        try {
            r1 = new BufferedReader(new InputStreamReader(file1.getInputStream(false), encoding));
            r2 = new BufferedReader(new InputStreamReader(file.getInputStream(false), encoding));
            int matchingLine = DiffUtils.getMatchingLine((Reader)r1, (Reader)r2, (int)lineNumber);
            GitUtils.openInRevision(file, originalFile, matchingLine, revisionToOpen, showAnnotations, pm);
        }
        finally {
            if (r1 != null) {
                r1.close();
            }
            if (r2 != null) {
                r2.close();
            }
        }
    }

    public static void openInRevision(VCSFileProxy originalFile, int lineNumber, String revision, boolean showAnnotations, ProgressMonitor pm) throws IOException {
        VCSFileProxy file = VersionsCache.getInstance().getFileRevision(originalFile, revision, pm);
        if (pm.isCanceled()) {
            return;
        }
        if (file == null) {
            file = VCSFileProxySupport.createTempFile((VCSFileProxy)originalFile, (String)"tmp", (String)("-" + originalFile.getName()), (boolean)true);
        }
        GitUtils.openInRevision(file, originalFile, lineNumber, revision, showAnnotations, pm);
    }

    private static void openInRevision(VCSFileProxy fileToOpen, final VCSFileProxy originalFile, final int lineNumber, final String revision, boolean showAnnotations, ProgressMonitor pm) throws IOException {
        FileObject fo = fileToOpen.normalizeFile().toFileObject();
        EditorCookie ec = null;
        OpenCookie oc = null;
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
        }
        catch (DataObjectNotFoundException ex) {
            Logger.getLogger(GitUtils.class.getName()).log(Level.FINE, null, ex);
        }
        if (ec == null && oc != null) {
            oc.open();
        } else {
            CloneableEditorSupport ces = Utils.openFile((FileObject)fo, (String)revision.substring(0, 7));
            if (showAnnotations && ces != null && !pm.isCanceled()) {
                final CloneableEditorSupport support = ces;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPane[] panes = support.getOpenedPanes();
                        if (panes != null) {
                            if (lineNumber >= 0 && lineNumber < support.getLineSet().getLines().size()) {
                                support.getLineSet().getCurrent(lineNumber).show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.FRONT);
                            }
                            ((AnnotateAction)SystemAction.get(AnnotateAction.class)).showAnnotations(panes[0], originalFile, revision);
                        }
                    }
                });
            }
        }
    }

    public static Map<VCSFileProxy, Set<VCSFileProxy>> sortByRepository(Collection<VCSFileProxy> files) {
        HashMap<VCSFileProxy, Set<VCSFileProxy>> sorted = new HashMap<VCSFileProxy, Set<VCSFileProxy>>(5);
        for (VCSFileProxy f : files) {
            VCSFileProxy repository = Git.getInstance().getRepositoryRoot(f);
            if (repository == null) continue;
            HashSet<VCSFileProxy> repoFiles = (HashSet<VCSFileProxy>)sorted.get(repository);
            if (repoFiles == null) {
                repoFiles = new HashSet<VCSFileProxy>();
                sorted.put(repository, repoFiles);
            }
            repoFiles.add(f);
        }
        return sorted;
    }

    public static boolean contains(Collection<VCSFileProxy> roots, VCSFileProxy file) {
        for (VCSFileProxy root : roots) {
            if (!VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)root, (VCSFileProxy)file)) continue;
            return true;
        }
        return false;
    }

    public static String getGlobalRefSpec(String remoteName) {
        return MessageFormat.format(REF_SPEC_GLOBAL_PATTERN, remoteName);
    }

    public static String getRefSpec(GitBranch branch, String remoteName) {
        return MessageFormat.format(REF_SPEC_PATTERN, branch.getName(), remoteName);
    }

    public static String getDeletedRefSpec(GitBranch branch) {
        return REF_SPEC_DEL_PREFIX + branch.getName();
    }

    public static String getRefSpec(String branchName, String remoteName) {
        return MessageFormat.format(REF_SPEC_PATTERN, branchName, remoteName);
    }

    public static String getPushRefSpec(String branchName, String remoteRepositoryBranchName) {
        return MessageFormat.format(REF_PUSHSPEC_PATTERN, branchName, remoteRepositoryBranchName);
    }

    public static String getPushDeletedRefSpec(String remoteRepositoryBranchName) {
        return REF_PUSHSPEC_DEL_PREFIX + remoteRepositoryBranchName;
    }

    public static String getPushTagRefSpec(String tagName, boolean forceUpdate) {
        return MessageFormat.format(forceUpdate ? REF_TAG_PUSHSPEC_PATTERN_FORCE : REF_TAG_PUSHSPEC_PATTERN, tagName);
    }

    public static <T> T runWithoutIndexing(Callable<T> callable, List<VCSFileProxy> files) throws GitException {
        return GitUtils.runWithoutIndexing(callable, files.toArray(new VCSFileProxy[files.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T runWithoutIndexing(Callable<T> callable, VCSFileProxy ... files) throws GitException {
        try {
            Set<VCSFileProxy> recursiveRoots = indexingFiles.get();
            if (recursiveRoots != null) {
                if ($assertionsDisabled) return callable.call();
                if (GitUtils.indexingFilesSubtree(recursiveRoots, files)) return callable.call();
                throw new AssertionError((Object)("Recursive call does not permit different roots: " + recursiveRoots + " vs. " + Arrays.asList(files)));
            }
            try {
                if (Git.LOG.isLoggable(Level.FINER)) {
                    Git.LOG.log(Level.FINER, "Running block in indexing bridge: on {0}", Arrays.asList(files));
                }
                indexingFiles.set(new HashSet<VCSFileProxy>(Arrays.asList(files)));
                Object object = FileObjectIndexingBridgeProvider.getInstance().runWithoutIndexing(callable, files);
                return (T)object;
            }
            finally {
                indexingFiles.remove();
            }
        }
        catch (GitException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GitException("Cannot run without indexing due to: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static String getColorString(Color c) {
        return "#" + GitUtils.getHex(c.getRed()) + GitUtils.getHex(c.getGreen()) + GitUtils.getHex(c.getBlue());
    }

    private static String getHex(int i) {
        String hex = Integer.toHexString(i & 0xFF);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    private static boolean indexingFilesSubtree(Set<VCSFileProxy> recursiveRoots, VCSFileProxy[] files) {
        for (VCSFileProxy f : files) {
            if (recursiveRoots.contains(f)) continue;
            boolean contained = false;
            for (VCSFileProxy root : recursiveRoots) {
                if (!VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)root, (VCSFileProxy)f)) continue;
                contained = true;
                break;
            }
            if (contained) continue;
            return false;
        }
        return true;
    }

    public static GitRemoteConfig prepareConfig(GitRemoteConfig original, String remoteName, String remoteUri, List<String> fetchRefSpecs) {
        List<String> refSpecs;
        List<Object> remoteUris;
        String username = new CredentialsCallback().getUsername(remoteUri, "");
        GitURI uriToSave = null;
        try {
            uriToSave = new GitURI(remoteUri);
            if (username != null && !username.isEmpty()) {
                uriToSave = uriToSave.setUser(username);
            }
            remoteUri = uriToSave.toPrivateString();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(GitUtils.class.getName()).log(Level.INFO, null, ex);
        }
        if (original != null) {
            remoteUris = new ArrayList(original.getUris());
            boolean added = false;
            ListIterator<Object> it = remoteUris.listIterator();
            while (it.hasNext()) {
                String oldUri = (String)it.next();
                if (!GitUtils.equal(uriToSave, remoteUri, oldUri)) continue;
                it.set(remoteUri);
                added = true;
                break;
            }
            if (!added) {
                remoteUris.add(0, remoteUri);
            }
        } else {
            remoteUris = Arrays.asList(remoteUri);
        }
        if (original != null) {
            refSpecs = new LinkedList<String>(original.getFetchRefSpecs());
            if (!refSpecs.contains(GitUtils.getRefSpec("*", remoteName))) {
                for (String refSpec : fetchRefSpecs) {
                    if (refSpecs.contains(refSpec)) continue;
                    refSpecs.add(refSpec);
                }
            }
        } else {
            refSpecs = fetchRefSpecs;
        }
        return new GitRemoteConfig(remoteName, remoteUris, original == null ? Collections.emptyList() : original.getPushUris(), refSpecs, original == null ? Collections.emptyList() : original.getPushRefSpecs());
    }

    private static boolean equal(GitURI uri, String uriString, String otherUriString) {
        if (uri != null) {
            try {
                GitURI otherUri = new GitURI(otherUriString);
                return otherUri.setUser(null).toString().equals(uri.setUser(null).toString());
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(GitUtils.class.getName()).log(Level.INFO, null, ex);
                return uri.toString().equals(otherUriString) || uriString.equals(otherUriString);
            }
        }
        return uriString.equals(otherUriString);
    }

    public static void logRemoteRepositoryAccess(final VCSFileProxy repositoryRoot) {
        if (loggedRepositories.add(repositoryRoot)) {
            Git.getInstance().getRequestProcessor(repositoryRoot).post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashSet urls = new HashSet();
                    GitClient client = null;
                    try {
                        client = Git.getInstance().getClient(repositoryRoot);
                        Map<String, GitRemoteConfig> cfgs = client.getRemotes(NULL_PROGRESS_MONITOR);
                        for (Map.Entry<String, GitRemoteConfig> e : cfgs.entrySet()) {
                            GitRemoteConfig cfg = e.getValue();
                            for (List uris : Arrays.asList(cfg.getUris(), cfg.getPushUris())) {
                                if (uris.isEmpty()) continue;
                                urls.addAll(uris);
                            }
                        }
                    }
                    catch (GitException gitException) {
                    }
                    finally {
                        if (client != null) {
                            client.release();
                        }
                    }
                    if (urls.isEmpty()) {
                        Utils.logVCSExternalRepository((String)"GIT", null);
                    }
                    for (String url : urls) {
                        if (url.trim().isEmpty()) continue;
                        Utils.logVCSExternalRepository((String)"GIT", (String)url);
                    }
                }
            });
        }
    }

    public static <T> QuickSearch attachQuickSearch(List<T> items, JPanel panel, JList listComponent, DefaultListModel model, SearchCallback<T> searchCallback) {
        final QuickSearchCallback<T> callback = new QuickSearchCallback<T>(items, listComponent, model, searchCallback);
        final QuickSearch qs = QuickSearch.attach((JComponent)panel, (Object)"South", callback);
        qs.setAlwaysShown(true);
        listComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                qs.processKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 10 && (e.getKeyCode() != 27 || callback.quickSearchActive)) {
                    qs.processKeyEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                qs.processKeyEvent(e);
            }
        });
        return qs;
    }

    public static boolean isValidRefName(String refName) {
        return RefUtils.isValidRefName((String)refName);
    }

    public static boolean isValidTagName(String tagName) {
        return GitUtils.isValidRefName(PREFIX_R_TAGS + tagName);
    }

    public static boolean isValidBranchName(String branchName) {
        return GitUtils.isValidRefName(PREFIX_R_HEADS + branchName);
    }

    public static VCSContext getContextForFile(VCSFileProxy root) {
        return GitUtils.getContextForFiles(new VCSFileProxy[]{root});
    }

    public static VCSContext getContextForFiles(VCSFileProxy[] roots) {
        Node[] nodes = new Node[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            final VCSFileProxy root = roots[i];
            nodes[i] = new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{root})){

                public String getName() {
                    return root.getName();
                }
            };
        }
        return VCSContext.forNodes((Node[])nodes);
    }

    private GitUtils() {
    }

    private static class NullProgressMonitor
    extends ProgressMonitor {
        private NullProgressMonitor() {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCancelDelegate(Cancellable c) {
        }

        public boolean cancel() {
            return false;
        }

        public void started(String command) {
        }

        public void finished() {
        }

        public void preparationsFailed(String message) {
        }

        public void notifyError(String message) {
        }

        public void notifyWarning(String message) {
        }
    }

    private static class QuickSearchCallback<T>
    implements QuickSearch.Callback,
    ListSelectionListener {
        private boolean quickSearchActive;
        private int currentPosition;
        private final List<T> results;
        private final List<T> items;
        private final JList component;
        private final DefaultListModel model;
        private final SearchCallback<T> callback;
        private boolean internal;

        public QuickSearchCallback(List<T> items, JList component, DefaultListModel model, SearchCallback<T> callback) {
            this.items = new ArrayList<T>(items);
            this.results = new ArrayList<T>(items);
            this.component = component;
            this.model = model;
            this.callback = callback;
            this.currentPosition = component.getSelectedIndex();
            component.addListSelectionListener(this);
        }

        public void quickSearchUpdate(String searchText) {
            this.quickSearchActive = true;
            T selected = this.items.get(0);
            if (this.currentPosition > -1) {
                selected = this.results.get(this.currentPosition);
            }
            this.results.clear();
            this.results.addAll(this.items);
            if (!searchText.isEmpty()) {
                ListIterator<T> it = this.results.listIterator();
                while (it.hasNext()) {
                    T item = it.next();
                    if (this.callback.contains(item, searchText)) continue;
                    it.remove();
                }
            }
            this.currentPosition = this.results.indexOf(selected);
            if (this.currentPosition == -1 && !this.results.isEmpty()) {
                this.currentPosition = 0;
            }
            this.updateView();
        }

        public void showNextSelection(boolean forward) {
            if (this.currentPosition != -1) {
                this.currentPosition += forward ? 1 : -1;
                if (this.currentPosition < 0) {
                    this.currentPosition = this.results.size() - 1;
                } else if (this.currentPosition == this.results.size()) {
                    this.currentPosition = 0;
                }
                this.updateSelection();
            }
        }

        public String findMaxPrefix(String prefix) {
            return prefix;
        }

        public void quickSearchConfirmed() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QuickSearchCallback.this.component.requestFocusInWindow();
                }
            });
        }

        public void quickSearchCanceled() {
            this.quickSearchUpdate("");
            this.quickSearchActive = false;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QuickSearchCallback.this.component.requestFocusInWindow();
                }
            });
        }

        private void updateView() {
            this.internal = true;
            try {
                this.model.removeAllElements();
                for (T r : this.results) {
                    this.model.addElement(r);
                }
                this.updateSelection();
            }
            finally {
                this.internal = false;
            }
        }

        private void updateSelection() {
            if (this.currentPosition > -1 && this.currentPosition < this.results.size()) {
                T rev = this.results.get(this.currentPosition);
                boolean oldInternal = this.internal;
                this.internal = true;
                try {
                    this.component.setSelectedValue(rev, true);
                }
                finally {
                    this.internal = oldInternal;
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!this.internal && !e.getValueIsAdjusting()) {
                this.currentPosition = this.component.getSelectedIndex();
            }
        }
    }

    public static interface SearchCallback<T> {
        public boolean contains(T var1, String var2);
    }
}

