/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.ReplaceConstructorWithBuilderRefactoring;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.java.ui.ReplaceConstructorWithBuilderPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ReplaceConstructorWithBuilderUI
implements RefactoringUI,
JavaRefactoringUIFactory {
    private ReplaceConstructorWithBuilderRefactoring refactoring;
    private String builderFQN;
    private ReplaceConstructorWithBuilderPanel panel;
    private String name;
    private List<String> paramaterNames;
    private List<String> parameterTypes;
    private List<Boolean> parameterTypeVars;

    private ReplaceConstructorWithBuilderUI(TreePathHandle constructor, CompilationInfo info) {
        this.refactoring = new ReplaceConstructorWithBuilderRefactoring(constructor);
        ExecutableElement contructorElement = (ExecutableElement)constructor.resolveElement(info);
        this.name = contructorElement.getSimpleName().toString();
        MethodTree constTree = (MethodTree)constructor.resolve(info).getLeaf();
        this.paramaterNames = new ArrayList<String>();
        this.parameterTypes = new ArrayList<String>();
        this.parameterTypeVars = new ArrayList<Boolean>();
        boolean varargs = contructorElement.isVarArgs();
        List<? extends VariableElement> parameterElements = contructorElement.getParameters();
        List<? extends VariableTree> parameters = constTree.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            VariableTree var = parameters.get(i);
            this.paramaterNames.add(var.getName().toString());
            String type = contructorElement.getParameters().get(i).asType().toString();
            if (varargs && i + 1 == parameters.size() && var.getType().getKind() == Tree.Kind.ARRAY_TYPE) {
                ArrayTypeTree att = (ArrayTypeTree)var.getType();
                type = att.getType().toString();
                type = type + "...";
            }
            this.parameterTypes.add(type);
            this.parameterTypeVars.add(parameterElements.get(i).asType().getKind() == TypeKind.TYPEVAR);
        }
        TypeElement typeEl = (TypeElement)contructorElement.getEnclosingElement();
        if (typeEl.getNestingKind() != NestingKind.TOP_LEVEL) {
            PackageElement packageOf = info.getElements().getPackageOf(typeEl);
            this.builderFQN = packageOf.toString() + "." + typeEl.getSimpleName().toString();
        } else {
            this.builderFQN = typeEl.getQualifiedName().toString();
        }
    }

    private ReplaceConstructorWithBuilderUI() {
    }

    public String getName() {
        return NbBundle.getMessage(ReplaceConstructorWithBuilderUI.class, (String)"ReplaceConstructorWithBuilderName");
    }

    public String getDescription() {
        return NbBundle.getMessage(ReplaceConstructorWithBuilderUI.class, (String)"ReplaceConstructorWithBuilderDescription", (Object)this.name, (Object)this.builderFQN);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new ReplaceConstructorWithBuilderPanel(parent, this.builderFQN + "Builder", this.paramaterNames, this.parameterTypes, this.parameterTypeVars);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.refactoring.setSetters(this.panel.getSetters());
        this.refactoring.setBuilderName(this.panel.getBuilderName());
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.refactoring.setSetters(this.panel.getSetters());
        this.refactoring.setBuilderName(this.panel.getBuilderName());
        return this.refactoring.fastCheckParameters();
    }

    public boolean hasParameters() {
        return true;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ReplaceConstructorWithBuilderUI.class);
    }

    @Override
    public RefactoringUI create(CompilationInfo info, TreePathHandle[] handles, FileObject[] files, NonRecursiveFolder[] packages) {
        Element selected;
        TreePath path;
        assert (handles.length == 1);
        EnumSet<Tree.Kind> treeKinds = EnumSet.of(Tree.Kind.NEW_CLASS, Tree.Kind.METHOD);
        for (path = handles[0].resolve(info); path != null && !treeKinds.contains((Object)path.getLeaf().getKind()); path = path.getParentPath()) {
        }
        if (path != null && treeKinds.contains((Object)path.getLeaf().getKind()) && (selected = info.getTrees().getElement(path)) != null && selected.getKind() == ElementKind.CONSTRUCTOR && selected.getEnclosingElement().getKind() != ElementKind.ENUM) {
            return new ReplaceConstructorWithBuilderUI(TreePathHandle.create((Element)selected, (CompilationInfo)info), info);
        }
        return null;
    }

    public static JavaRefactoringUIFactory factory() {
        return new ReplaceConstructorWithBuilderUI();
    }
}

