/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.commands.Bundle;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Parameters;

public final class RebaseCommand
extends HgCommand<Result> {
    private static final String HG_REBASE_EXT_CMD = "extensions.rebase=";
    private static final String HG_REBASE_OPT_ABORT = "--abort";
    private static final String HG_REBASE_OPT_CONTINUE = "--continue";
    private static final String HG_REBASE_OPT_BASE = "--base";
    private static final String HG_REBASE_OPT_SOURCE = "--source";
    private static final String HG_REBASE_OPT_DEST = "--dest";
    private final VCSFileProxy repository;
    private final Operation operation;
    private final OutputLogger logger;
    private String revisionBase;
    private String revisionSource;
    private String revisionDest;
    private List<String> output;

    public RebaseCommand(VCSFileProxy repository, Operation operation, OutputLogger logger) {
        Parameters.notNull((CharSequence)"repository", (Object)repository);
        Parameters.notNull((CharSequence)"operation", (Object)((Object)operation));
        this.repository = repository;
        this.operation = operation;
        this.logger = logger;
    }

    public RebaseCommand setRevisionBase(String revisionBase) {
        this.revisionBase = revisionBase;
        return this;
    }

    public RebaseCommand setRevisionSource(String revisionSource) {
        this.revisionSource = revisionSource;
        return this;
    }

    public RebaseCommand setRevisionDest(String revisionDest) {
        this.revisionDest = revisionDest;
        return this;
    }

    @Override
    public Result call() throws HgException {
        HgCommand.CommandParameters args = new HgCommand.CommandParameters("rebase");
        switch (this.operation) {
            case ABORT: {
                args.add(HG_REBASE_OPT_ABORT);
                break;
            }
            case CONTINUE: {
                args.add(HG_REBASE_OPT_CONTINUE);
                break;
            }
            case START: {
                if (this.revisionBase != null) {
                    args.add(HG_REBASE_OPT_BASE);
                    args.add(this.revisionBase);
                }
                if (this.revisionSource != null) {
                    args.add(HG_REBASE_OPT_SOURCE);
                    args.add(this.revisionSource);
                }
                if (this.revisionDest == null) break;
                args.add(HG_REBASE_OPT_DEST);
                args.add(this.revisionDest);
            }
        }
        args.addVerboseOption().addConfigOption(HG_REBASE_EXT_CMD).addConfigOption("ui.merge=internal:merge").addRepositoryLocation(this.repository.getPath());
        List<String> command = args.toCommand();
        this.output = RebaseCommand.exec(this.repository, command);
        if (!this.output.isEmpty() && RebaseCommand.isErrorAbort(this.output.get(0))) {
            RebaseCommand.handleError(command, this.output, Bundle.MSG_HgCommand_Rebase_failed(), this.logger);
        }
        return Result.build(this.repository, this.output);
    }

    public List<String> getOutput() {
        return this.output;
    }

    public static class Result {
        private static final String SAVED_BACKUP_BUNDLE_TO = "saved backup bundle to ";
        private VCSFileProxy bundleFile;
        private final List<String> output;
        private final Set<VCSFileProxy> touchedFiles;
        private final List<VCSFileProxy> conflicts;
        private State state;

        private Result(List<String> output) {
            this.output = output;
            this.touchedFiles = new LinkedHashSet<VCSFileProxy>();
            this.conflicts = new ArrayList<VCSFileProxy>();
        }

        public static Result build(VCSFileProxy repo, List<String> output) {
            Result res = new Result(output);
            res.state = State.OK;
            for (String line : output) {
                boolean removed = false;
                boolean merging = false;
                if (line.startsWith("getting ") || (merging = line.startsWith("merging ")) || (removed = line.startsWith("removing "))) {
                    String name = line.substring(removed ? 9 : 8);
                    if (merging && name.endsWith(" failed!")) {
                        name = name.substring(0, name.length() - 8);
                        res.conflicts.add(VCSFileProxy.createFileProxy((VCSFileProxy)repo, (String)name));
                        continue;
                    }
                    res.touchedFiles.add(VCSFileProxy.createFileProxy((VCSFileProxy)repo, (String)name));
                    continue;
                }
                if (line.startsWith("abort: unresolved conflicts")) {
                    res.state = State.MERGING;
                    continue;
                }
                if (line.equals("rebase aborted")) {
                    res.state = State.ABORTED;
                    continue;
                }
                if (!line.startsWith(SAVED_BACKUP_BUNDLE_TO)) continue;
                res.bundleFile = VCSFileProxySupport.getResource((VCSFileProxy)repo, (String)line.substring(SAVED_BACKUP_BUNDLE_TO.length()));
            }
            return res;
        }

        public VCSFileProxy getBundleFile() {
            return this.bundleFile;
        }

        public Collection<VCSFileProxy> getConflicts() {
            return this.conflicts;
        }

        public State getState() {
            return this.state;
        }

        public Collection<VCSFileProxy> getTouchedFiles() {
            return this.touchedFiles;
        }

        public List<String> getOutput() {
            return this.output;
        }

        public static enum State {
            OK,
            ABORTED,
            MERGING;

        }
    }

    public static enum Operation {
        CONTINUE,
        ABORT,
        START;

    }
}

