/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.log;

import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.ui.log.SearchHistoryPanel;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class SearchCriteriaPanel
extends JPanel {
    final JButton btnSelectBranch = new JButton();
    private JLabel fromInfoLabel;
    private JLabel fromLabel;
    private JCheckBox showMergesChkBox;
    final JTextField tfBranch = new JTextField();
    final JTextField tfFrom = new JTextField();
    final JTextField tfLimit = new JTextField();
    final JTextField tfTo = new JTextField();
    private JLabel toInfoLabel;
    private JLabel toLabel;
    private JLabel toLabel1;
    private JLabel toLabel2;

    public SearchCriteriaPanel(VCSFileProxy[] roots) {
        this.initComponents();
        this.showMergesChkBox.setSelected(HgModuleConfig.getDefault(roots[0]).getShowHistoryMerges());
        this.tfLimit.setText(Integer.toString(10));
    }

    public String getFrom() {
        String s = this.tfFrom.getText().trim();
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    public String getTo() {
        String s = this.tfTo.getText().trim();
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    public int getLimit() {
        String s = this.tfLimit.getText().trim();
        Integer retval = -1;
        try {
            retval = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            retval = -1;
        }
        if (retval <= 0) {
            retval = -1;
        }
        return retval;
    }

    void setForIncoming() {
        this.fromInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.toInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.fromLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingFrom"));
        this.toLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingTo"));
        this.showMergesChkBox.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingShowMerges"));
        this.tfFrom.setText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TTF_IncomingFrom"));
        this.tfFrom.setEnabled(false);
    }

    void setForOut() {
        this.fromInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.toInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.fromLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutFrom"));
        this.toLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutTo"));
        this.showMergesChkBox.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutShowMerges"));
        this.tfFrom.setText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TTF_OutFrom"));
        this.tfFrom.setEnabled(false);
    }

    public void setFrom(String from) {
        if (from == null) {
            from = "";
        }
        this.tfFrom.setText(from);
    }

    public void setTo(String to) {
        if (to == null) {
            to = "";
        }
        this.tfTo.setText(to);
    }

    void setLimit(int limit) {
        if (limit > 0) {
            this.tfLimit.setText(Integer.toString(limit));
        } else {
            this.tfLimit.setText("");
        }
    }

    public String getBranch() {
        return this.tfBranch.getText().trim();
    }

    public void setBranch(String branchName) {
        this.tfBranch.setText(branchName);
    }

    boolean isIncludeMerges() {
        return this.showMergesChkBox.isSelected();
    }

    private void initComponents() {
        this.fromLabel = new JLabel();
        this.fromInfoLabel = new JLabel();
        this.toLabel = new JLabel();
        this.toInfoLabel = new JLabel();
        this.toLabel1 = new JLabel();
        this.toLabel2 = new JLabel();
        this.showMergesChkBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(8, 12, 0, 11));
        this.fromLabel.setLabelFor(this.tfFrom);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/mercurial/remote/ui/log/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.fromLabel, (String)bundle.getString("CTL_UseFrom"));
        this.fromLabel.setToolTipText(bundle.getString("TT_From"));
        this.tfFrom.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.fromInfoLabel, (String)bundle.getString("CTL_FromToHint"));
        this.toLabel.setLabelFor(this.tfTo);
        Mnemonics.setLocalizedText((JLabel)this.toLabel, (String)bundle.getString("CTL_UseTo"));
        this.toLabel.setToolTipText(bundle.getString("TT_To"));
        this.tfTo.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.toInfoLabel, (String)bundle.getString("CTL_FromToHint"));
        this.toLabel1.setLabelFor(this.tfLimit);
        Mnemonics.setLocalizedText((JLabel)this.toLabel1, (String)bundle.getString("CTL_UseLimit"));
        this.toLabel1.setToolTipText(bundle.getString("TT_Limit"));
        this.tfLimit.setColumns(10);
        this.toLabel2.setLabelFor(this.tfBranch);
        Mnemonics.setLocalizedText((JLabel)this.toLabel2, (String)bundle.getString("CTL_UseBranch"));
        this.toLabel2.setToolTipText(bundle.getString("TT_Branch"));
        this.tfBranch.setColumns(10);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectBranch, (String)NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_SelectBranch"));
        this.btnSelectBranch.setToolTipText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"TT_SelectBranch"));
        this.showMergesChkBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.showMergesChkBox, (String)NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_ShowMerge"));
        this.showMergesChkBox.setToolTipText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"TT_ShowMerges"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.toLabel1, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.tfLimit, -1, 118, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showMergesChkBox)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.tfBranch).addGap(18, 18, 18).addComponent(this.btnSelectBranch))).addGap(30, 30, 30).addComponent(this.fromLabel)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.toLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toInfoLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfFrom).addComponent(this.fromInfoLabel).addComponent(this.tfTo))).addGap(14, 14, 14)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fromLabel).addComponent(this.tfFrom, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromInfoLabel).addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfTo, -2, -1, -2).addComponent(this.toLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toInfoLabel).addContainerGap(28, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.toLabel2).addComponent(this.btnSelectBranch).addComponent(this.tfBranch, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.showMergesChkBox, -2, 27, -2).addComponent(this.toLabel1).addComponent(this.tfLimit, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
    }
}

