/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentContext;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentManager2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.WebTargetModuleID;
import org.netbeans.modules.j2ee.weblogic9.ProgressObjectSupport;
import org.netbeans.modules.j2ee.weblogic9.ServerLogManager;
import org.netbeans.modules.j2ee.weblogic9.URLWait;
import org.netbeans.modules.j2ee.weblogic9.VersionBridge;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.WLProductProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.CommandBasedDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentStatus;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLProgressObject;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLSharedState;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLTarget;
import org.netbeans.modules.j2ee.weblogic9.j2ee.WLJ2eePlatformFactory;
import org.netbeans.modules.j2ee.weblogic9.optional.NonProxyHostsHelper;
import org.netbeans.modules.weblogic.common.api.WebLogicConfiguration;
import org.netbeans.modules.weblogic.common.api.WebLogicDeployer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class WLDeploymentManager
implements DeploymentManager2 {
    public static final int MANAGER_TIMEOUT = 60000;
    private static final Logger LOGGER = Logger.getLogger(WLDeploymentManager.class.getName());
    private static final boolean DEBUG_JSR88 = Boolean.getBoolean(WLDeploymentManager.class.getName() + ".debugJsr88");
    private static final Map<ServerProgressObject, DeploymentStatus> OBJECTS_TO_POLL = new HashMap<ServerProgressObject, DeploymentStatus>();
    private static final RequestProcessor OBJECT_POLL_RP = new RequestProcessor("ProgressObject Poll", 1);
    private static final RequestProcessor URL_RESOLVE_RP = new RequestProcessor("URL Resolve", 1);
    private static final InstanceProperties EMPTY_PROPERTIES = new InstanceProperties(){

        public void setProperties(Properties props) throws IllegalStateException {
            throw new IllegalStateException("Already removed InstanceProperties");
        }

        public void setProperty(String propname, String value) throws IllegalStateException {
            throw new IllegalStateException("Already removed InstanceProperties");
        }

        public String getProperty(String propname) throws IllegalStateException {
            throw new IllegalStateException("Already removed InstanceProperties");
        }

        public Enumeration propertyNames() throws IllegalStateException {
            throw new IllegalStateException("Already removed InstanceProperties");
        }

        public DeploymentManager getDeploymentManager() {
            throw new IllegalStateException("Already removed InstanceProperties");
        }

        public void refreshServerInstance() {
            throw new IllegalStateException("Already removed InstanceProperties");
        }
    };
    private static final Callable<String> NON_PROXY = new Callable<String>(){

        @Override
        public String call() throws Exception {
            return NonProxyHostsHelper.getNonProxyHosts();
        }
    };
    private final String uri;
    private final String host;
    private final String port;
    private final WLProductProperties productProperties = new WLProductProperties(this);
    private final WLSharedState mutableState;
    private final WebLogicConfiguration config;
    private final boolean disconnected;
    private WeakReference<InstanceProperties> instanceProperties;
    private DeploymentManager manager;
    private WLJ2eePlatformFactory.J2eePlatformImplImpl j2eePlatformImpl;
    private WLConnectionSupport connectionSupport;
    private ServerLogManager logManager;
    private Version serverVersion;
    private Version domainVersion;
    private boolean initialized;
    private boolean proxyMisconfigured;
    private Boolean remote;

    public WLDeploymentManager(String uri, String host, String port, boolean disconnected, WLSharedState mutableState) {
        this.uri = uri;
        this.host = host;
        this.port = port;
        this.disconnected = disconnected;
        this.mutableState = mutableState;
        this.config = this.createConfiguration();
    }

    public WebLogicConfiguration getCommonConfiguration() {
        return this.config;
    }

    public synchronized ServerLogManager getLogManager() {
        if (this.logManager == null) {
            this.logManager = new ServerLogManager(this);
        }
        return this.logManager;
    }

    public String getUri() {
        return this.uri;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public synchronized boolean isRemote() {
        if (this.remote == null) {
            this.remote = Boolean.valueOf(this.getInstanceProperties().getProperty("remote"));
        }
        return this.remote;
    }

    @CheckForNull
    public synchronized Version getServerVersion() {
        this.init();
        return this.serverVersion;
    }

    @CheckForNull
    public synchronized Version getDomainVersion() {
        this.init();
        return this.domainVersion;
    }

    public synchronized boolean isProxyMisconfigured() {
        return this.proxyMisconfigured;
    }

    public synchronized void setProxyMisconfigured(boolean proxyMisconfigured) {
        this.proxyMisconfigured = proxyMisconfigured;
    }

    public synchronized InstanceProperties getInstanceProperties() {
        InstanceProperties ip;
        if (this.instanceProperties == null) {
            this.instanceProperties = new WeakReference<InstanceProperties>(InstanceProperties.getInstanceProperties((String)this.uri));
        }
        if ((ip = (InstanceProperties)this.instanceProperties.get()) == null) {
            ip = EMPTY_PROPERTIES;
        }
        return ip;
    }

    @CheckForNull
    public synchronized InstanceProperties getRealInstanceProperties() {
        if (this.instanceProperties == null) {
            this.instanceProperties = new WeakReference<InstanceProperties>(InstanceProperties.getInstanceProperties((String)this.uri));
        }
        return (InstanceProperties)this.instanceProperties.get();
    }

    @NonNull
    public synchronized WLJ2eePlatformFactory.J2eePlatformImplImpl getJ2eePlatformImpl() {
        if (this.j2eePlatformImpl == null) {
            this.j2eePlatformImpl = new WLJ2eePlatformFactory.J2eePlatformImplImpl(this);
        }
        return this.j2eePlatformImpl;
    }

    @NonNull
    public synchronized WLConnectionSupport getConnectionSupport() {
        if (this.connectionSupport == null) {
            this.connectionSupport = new WLConnectionSupport(this);
        }
        return this.connectionSupport;
    }

    public void addDomainChangeListener(ChangeListener listener) {
        this.mutableState.addDomainChangeListener(listener);
    }

    public void removeDomainChangeListener(ChangeListener listener) {
        this.mutableState.removeDomainChangeListener(listener);
    }

    public boolean isRestartNeeded() {
        return this.mutableState.isRestartNeeded();
    }

    public void setRestartNeeded(boolean restartNeeded) {
        this.mutableState.setRestartNeeded(restartNeeded);
    }

    public WLProductProperties getProductProperties() {
        return this.productProperties;
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.serverVersion = WLPluginProperties.getServerVersion(WLPluginProperties.getServerRoot(this, true));
        this.domainVersion = VersionBridge.getVersion(this.getCommonConfiguration().getDomainVersion());
    }

    private <T> T executeAction(final Action<T> action) throws Exception {
        WLConnectionSupport support = this.getConnectionSupport();
        return support.executeAction(new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    DeploymentManager manager = WLDeploymentManager.this.getDeploymentManager(WLDeploymentManager.this.getInstanceProperties().getProperty("username"), WLDeploymentManager.this.getInstanceProperties().getProperty("password"), WLDeploymentManager.this.host, WLDeploymentManager.this.port);
                    return action.execute(manager);
                }
                catch (DeploymentManagerCreationException ex) {
                    throw new ExecutionException(ex);
                }
            }
        });
    }

    private synchronized DeploymentManager getDeploymentManager(String username, String password, String host, String port) throws DeploymentManagerCreationException {
        if (this.manager != null) {
            try {
                Method m = this.manager.getClass().getMethod("isConnected", null);
                Object o = m.invoke((Object)this.manager, (Object[])null);
                if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                    return this.manager;
                }
            }
            catch (NoSuchMethodException m) {
            }
            catch (IllegalAccessException m) {
            }
            catch (InvocationTargetException m) {
                // empty catch block
            }
            this.manager.release();
        }
        DeploymentManagerCreationException dmce = null;
        try {
            Class<?> helperClazz = Class.forName("weblogic.deploy.api.tools.SessionHelper", false, Thread.currentThread().getContextClassLoader());
            Method m = helperClazz.getDeclaredMethod("getDeploymentManager", String.class, String.class, String.class, String.class, String.class);
            boolean secured = this.getCommonConfiguration().isSecured();
            Object o = m.invoke(null, secured ? "t3s" : "t3", host, port, username, password);
            if (DeploymentManager.class.isAssignableFrom(o.getClass())) {
                this.manager = (DeploymentManager)o;
                return this.manager;
            }
            dmce = new DeploymentManagerCreationException("Instance created by WebLogic is not DeploymentManager instance.");
        }
        catch (Exception e) {
            dmce = new DeploymentManagerCreationException("Cannot create weblogic DeploymentManager instance.");
            dmce.initCause((Throwable)e);
        }
        catch (NoClassDefFoundError err) {
            dmce = new DeploymentManagerCreationException("Cannot create weblogic DeploymentManager instance.");
            dmce.initCause((Throwable)err);
        }
        throw dmce;
    }

    public ProgressObject distribute(Target[] target, File file, File file2) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.deploy(target, file, file2, this.getHost(), this.getPort(), this.getCommonConfiguration().isSecured(), this.getDeployTargets());
    }

    public ProgressObject distribute(Target[] targets, DeploymentContext deployment) {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        this.deployOptionalPackages(deployment.getRequiredLibraries());
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.deploy(targets, deployment.getModuleFile(), deployment.getDeploymentPlan(), this.getHost(), this.getPort(), this.getCommonConfiguration().isSecured(), this.getDeployTargets());
    }

    public ProgressObject distribute(Target[] target, ModuleType moduleType, InputStream inputStream, InputStream inputStream0) throws IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public ProgressObject distribute(Target[] target, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isRedeploySupported() {
        return true;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.redeploy(targetModuleID, file, file2, this.getDeployTargets());
    }

    public ProgressObject redeploy(TargetModuleID[] tmids, DeploymentContext deployment) {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        this.deployOptionalPackages(deployment.getRequiredLibraries());
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.redeploy(tmids, deployment.getModuleFile(), deployment.getDeploymentPlan(), this.getDeployTargets());
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.undeploy(targetModuleID);
    }

    public ProgressObject stop(TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.stop(targetModuleID);
    }

    public ProgressObject start(TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.start(targetModuleID);
    }

    public TargetModuleID[] getAvailableModules(final ModuleType moduleType, final Target[] target) throws TargetException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<TargetModuleID[]>(){

                @Override
                public TargetModuleID[] execute(DeploymentManager manager) throws ExecutionException {
                    try {
                        return WLDeploymentManager.this.translateTargetModuleIDsToPlugin(manager.getAvailableModules(moduleType, WLDeploymentManager.translateTargets(manager, target)));
                    }
                    catch (TargetException ex) {
                        throw new ExecutionException(ex);
                    }
                }
            });
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof TargetException) {
                throw (TargetException)ex.getCause();
            }
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
    }

    public TargetModuleID[] getNonRunningModules(final ModuleType moduleType, final Target[] target) throws TargetException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<TargetModuleID[]>(){

                @Override
                public TargetModuleID[] execute(DeploymentManager manager) throws ExecutionException {
                    try {
                        return WLDeploymentManager.this.translateTargetModuleIDsToPlugin(manager.getNonRunningModules(moduleType, WLDeploymentManager.translateTargets(manager, target)));
                    }
                    catch (TargetException ex) {
                        throw new ExecutionException(ex);
                    }
                }
            });
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof TargetException) {
                throw (TargetException)ex.getCause();
            }
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
    }

    public TargetModuleID[] getRunningModules(final ModuleType moduleType, final Target[] target) throws TargetException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<TargetModuleID[]>(){

                @Override
                public TargetModuleID[] execute(DeploymentManager manager) throws ExecutionException {
                    try {
                        return WLDeploymentManager.this.translateTargetModuleIDsToPlugin(manager.getRunningModules(moduleType, WLDeploymentManager.translateTargets(manager, target)));
                    }
                    catch (TargetException ex) {
                        throw new ExecutionException(ex);
                    }
                }
            });
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof TargetException) {
                throw (TargetException)ex.getCause();
            }
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
    }

    public Target[] getTargets() throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            WLConnectionSupport support = this.getConnectionSupport();
            return support.executeAction(new WLConnectionSupport.JMXRuntimeAction<Target[]>(){

                @Override
                public Target[] call(MBeanServerConnection connection, ObjectName service) throws Exception {
                    ObjectName[] domainTargets;
                    ArrayList<WLTarget> targets = new ArrayList<WLTarget>();
                    ObjectName domainPending = (ObjectName)connection.getAttribute(service, "DomainPending");
                    if (domainPending != null && (domainTargets = (ObjectName[])connection.getAttribute(domainPending, "Targets")) != null) {
                        for (ObjectName singleTarget : domainTargets) {
                            String type = (String)connection.getAttribute(singleTarget, "Type");
                            if (!"Server".equals(type)) continue;
                            String name = (String)connection.getAttribute(singleTarget, "Name");
                            targets.add(new WLTarget(name));
                        }
                    }
                    return targets.toArray(new Target[targets.size()]);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex);
            try {
                return this.executeAction(new Action<Target[]>(){

                    @Override
                    public Target[] execute(DeploymentManager manager) throws ExecutionException {
                        Target[] targets = manager.getTargets();
                        if (targets != null) {
                            ArrayList<Target> ret = new ArrayList<Target>(targets.length);
                            for (Target t : targets) {
                                if (!"server".equals(t.getDescription())) continue;
                                ret.add(t);
                            }
                            return ret.toArray(new Target[ret.size()]);
                        }
                        return targets;
                    }
                });
            }
            catch (Exception fex) {
                LOGGER.log(Level.INFO, null, fex);
                return new Target[0];
            }
        }
    }

    public void release() {
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isLocaleSupported(Locale locale) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale getCurrentLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale getDefaultLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale[] getSupportedLocales() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public ProgressObject redeploy(final TargetModuleID targetModuleID) throws UnsupportedOperationException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<ProgressObject>(){

                @Override
                public ProgressObject execute(DeploymentManager manager) throws ExecutionException {
                    Set<String> wlsTarget = WLDeploymentManager.this.getDeployTargets();
                    if (wlsTarget == null || wlsTarget.isEmpty()) {
                        return WLDeploymentManager.registerProgressObject(new ServerProgressObject(manager.redeploy(WLDeploymentManager.this.translateTargetModuleIDsToServer(new TargetModuleID[]{targetModuleID}), (File)null, null)));
                    }
                    try {
                        ArrayList all = new ArrayList();
                        HashSet allType = new HashSet();
                        Collections.addAll(allType, ModuleType.CAR, ModuleType.EAR, ModuleType.EJB, ModuleType.RAR, ModuleType.WAR);
                        for (ModuleType t : allType) {
                            TargetModuleID[] curr = manager.getAvailableModules(t, manager.getTargets());
                            if (curr == null) continue;
                            Collections.addAll(all, curr);
                        }
                        ArrayList<TargetModuleID> toRedeploy = new ArrayList<TargetModuleID>();
                        block4: for (TargetModuleID id : all) {
                            if (!id.getModuleID().equals(targetModuleID.getModuleID())) continue;
                            for (String name : wlsTarget) {
                                if (!id.getTarget().getName().startsWith(name + "/") && !name.equals(id.getTarget().getName())) continue;
                                toRedeploy.add(id);
                                continue block4;
                            }
                        }
                        if (LOGGER.isLoggable(Level.FINE)) {
                            for (TargetModuleID id : toRedeploy) {
                                LOGGER.log(Level.FINE, "Going to redeploy {0}@{1}", new Object[]{id.getModuleID(), id.getTarget().getName()});
                            }
                        }
                        return WLDeploymentManager.registerProgressObject(new ServerProgressObject(manager.redeploy(toRedeploy.toArray(new TargetModuleID[toRedeploy.size()]), (File)null, null)));
                    }
                    catch (TargetException ex) {
                        throw new ExecutionException(ex);
                    }
                    catch (IllegalStateException ex) {
                        throw new ExecutionException(ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex.getCause());
            WLProgressObject po = new WLProgressObject(targetModuleID);
            po.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.REDEPLOY, StateType.FAILED, NbBundle.getMessage(WLDeploymentManager.class, (String)"MSG_Redeployment_Failed", (Object)ex.getMessage())));
            return po;
        }
    }

    public void deployOptionalPackages(File[] optionalPackages) {
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        if (optionalPackages.length > 0) {
            HashSet<File> files = new HashSet<File>(Arrays.asList(optionalPackages));
            ProgressObject po = wlDeployer.deployLibraries(files, this.getDeployTargets());
            ProgressObjectSupport.waitFor(po);
        }
    }

    public WebLogicDeployer createDeployer() {
        return WebLogicDeployer.getInstance((WebLogicConfiguration)this.getCommonConfiguration(), (File)this.getJavaBinary(), NON_PROXY);
    }

    @NonNull
    private WebLogicConfiguration createConfiguration() {
        WebLogicConfiguration config;
        InstanceProperties ip = this.getInstanceProperties();
        InstancePropertiesCredentials credentials = new InstancePropertiesCredentials(ip);
        String serverHome = ip.getProperty("serverRoot");
        String domainHome = ip.getProperty("domainRoot");
        if (this.isRemote()) {
            int realPort;
            String uri = ip.getProperty("url");
            String[] parts = uri.substring("deployer:WebLogic:http://".length()).split(":");
            String host = parts[0];
            String port = parts.length > 1 ? parts[1] : "";
            try {
                realPort = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                realPort = 7001;
            }
            boolean secured = Boolean.valueOf(ip.getProperty("secured"));
            config = WebLogicConfiguration.forRemoteDomain((File)new File(serverHome), (String)host, (int)realPort, (boolean)secured, (WebLogicConfiguration.Credentials)credentials);
        } else {
            config = WebLogicConfiguration.forLocalDomain((File)new File(serverHome), (File)new File(domainHome), (WebLogicConfiguration.Credentials)credentials);
        }
        return config;
    }

    public Set<String> getDeployTargets() {
        if (!this.isRemote()) {
            return Collections.emptySet();
        }
        String value = this.getInstanceProperties().getProperty("deployTargets");
        if (value == null || value.isEmpty()) {
            return Collections.emptySet();
        }
        String[] parts = value.split(",");
        TreeSet<String> ret = new TreeSet<String>();
        Collections.addAll(ret, parts);
        return ret;
    }

    private File getJavaBinary() {
        FileObject folder;
        File file;
        String javaBinary;
        JavaPlatform platform = JavaPlatformManager.getDefault().getDefaultPlatform();
        Collection folders = platform.getInstallFolders();
        String string = javaBinary = Utilities.isWindows() ? "java.exe" : "java";
        if (folders.size() > 0 && (file = FileUtil.toFile((FileObject)(folder = (FileObject)folders.iterator().next()))) != null) {
            javaBinary = file.getAbsolutePath() + File.separator + "bin" + File.separator + (Utilities.isWindows() ? "java.exe" : "java");
        }
        return new File(javaBinary);
    }

    private TargetModuleID[] translateTargetModuleIDsToPlugin(TargetModuleID[] ids) {
        if (ids == null) {
            return null;
        }
        TargetModuleID[] mapped = new TargetModuleID[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            mapped[i] = !(ids[i] instanceof ServerTargetModuleID) ? new ServerTargetModuleID(ids[i]) : ids[i];
        }
        return mapped;
    }

    private TargetModuleID[] translateTargetModuleIDsToServer(TargetModuleID ... ids) {
        if (ids == null) {
            return null;
        }
        TargetModuleID[] mapped = new TargetModuleID[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            mapped[i] = ids[i] instanceof ServerTargetModuleID ? ((ServerTargetModuleID)ids[i]).moduleId : ids[i];
        }
        return mapped;
    }

    private static Target[] translateTargets(DeploymentManager manager, Target[] originalTargets) {
        Target[] targets = manager.getTargets();
        ArrayList<Target> deployTargets = new ArrayList<Target>(originalTargets.length);
        for (Target t : targets) {
            for (Target t2 : originalTargets) {
                if (!t.getName().equals(t2.getName())) continue;
                deployTargets.add(t);
            }
        }
        return deployTargets.toArray(new Target[deployTargets.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProgressObject registerProgressObject(ServerProgressObject po) {
        Class<WLDeploymentManager> clazz = WLDeploymentManager.class;
        synchronized (WLDeploymentManager.class) {
            if (OBJECTS_TO_POLL.isEmpty()) {
                OBJECT_POLL_RP.post((Runnable)new ProgressObjectPoll());
            }
            OBJECTS_TO_POLL.put(po, po.getDeploymentStatus());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return po;
        }
    }

    static {
        if (DEBUG_JSR88) {
            System.setProperty("weblogic.deployer.debug", "all");
        }
    }

    private static class ProgressObjectPoll
    implements Runnable {
        private ProgressObjectPoll() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                DeploymentStatus status;
                HashMap current = null;
                Class<WLDeploymentManager> clazz = WLDeploymentManager.class;
                // MONITORENTER : org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager.class
                current = new HashMap(OBJECTS_TO_POLL);
                // MONITOREXIT : clazz
                for (Map.Entry entry : current.entrySet()) {
                    status = ((ServerProgressObject)entry.getKey()).getDeploymentStatus();
                    if (status == null ? entry.getValue() != null : !status.equals(entry.getValue())) {
                        ((ServerProgressObject)entry.getKey()).fireProgressEvent(status);
                    }
                    entry.setValue(status);
                }
                clazz = WLDeploymentManager.class;
                // MONITORENTER : org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager.class
                OBJECTS_TO_POLL.putAll(current);
                Iterator iterator = OBJECTS_TO_POLL.entrySet().iterator();
                while (iterator.hasNext()) {
                    status = (DeploymentStatus)iterator.next().getValue();
                    if (!StateType.COMPLETED.equals(status.getState()) && !StateType.FAILED.equals(status.getState()) && !StateType.RELEASED.equals(status.getState())) continue;
                    iterator.remove();
                }
                if (OBJECTS_TO_POLL.isEmpty()) {
                    // MONITOREXIT : clazz
                    return;
                }
                // MONITOREXIT : clazz
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    private class ServerProgressObject
    implements ProgressObject {
        private final ProgressObject po;
        private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();

        public ServerProgressObject(ProgressObject po) {
            this.po = po;
        }

        public boolean isStopSupported() {
            return this.po.isStopSupported();
        }

        public boolean isCancelSupported() {
            return this.po.isCancelSupported();
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return WLDeploymentManager.this.translateTargetModuleIDsToPlugin(this.po.getResultTargetModuleIDs());
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.po.getDeploymentStatus();
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID tmid) {
            return this.po.getClientConfiguration(tmid);
        }

        public void stop() throws OperationUnsupportedException {
            this.po.stop();
        }

        public void cancel() throws OperationUnsupportedException {
            this.po.cancel();
        }

        public void addProgressListener(ProgressListener pl) {
            this.listeners.add(pl);
        }

        public void removeProgressListener(ProgressListener pl) {
            this.listeners.remove(pl);
        }

        public void fireProgressEvent(DeploymentStatus status) {
            ProgressEvent event = new ProgressEvent((Object)this, null, status);
            for (ProgressListener listener : this.listeners) {
                listener.handleProgressEvent(event);
            }
        }
    }

    private class ServerTargetModuleID
    implements WebTargetModuleID {
        private final TargetModuleID moduleId;

        public ServerTargetModuleID(TargetModuleID moduleId) {
            this.moduleId = moduleId;
        }

        public String toString() {
            return this.getModuleID();
        }

        public String getWebURL() {
            String url = this.moduleId.getWebURL();
            boolean secured = WLDeploymentManager.this.getCommonConfiguration().isSecured();
            if (url != null && url.startsWith("/")) {
                url = (secured ? "https://" : "http://") + WLDeploymentManager.this.getHost() + ":" + WLDeploymentManager.this.getPort() + url;
            }
            if (url != null && (url.startsWith("http://") || url.startsWith("https://"))) {
                int start = url.indexOf("//");
                assert (start > 0);
                int end = url.indexOf(47, start + 2);
                if (end < 0) {
                    end = url.length();
                }
                url = (secured ? "https://" : "http://") + WLDeploymentManager.this.getHost() + ":" + WLDeploymentManager.this.getPort() + url.substring(end);
            }
            return url;
        }

        public URL resolveWebURL() {
            ArrayList<URL> candidates = new ArrayList<URL>();
            String url = this.getWebURL();
            if (url != null) {
                try {
                    candidates.add(new URL(url));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            WebLogicDeployer deployer = WLDeploymentManager.this.createDeployer();
            String name = this.getModuleID();
            WebLogicDeployer.Application found = null;
            try {
                for (WebLogicDeployer.Application app : (Collection)deployer.list(null).get(1L, TimeUnit.MINUTES)) {
                    if (!name.equals(app.getName())) continue;
                    found = app;
                    break;
                }
                if (found != null) {
                    candidates.addAll(found.getServerUrls());
                    for (URL c : candidates) {
                        if (!URLWait.waitForUrlReady(null, (ExecutorService)URL_RESOLVE_RP, c, 1000)) continue;
                        if (URLWait.waitForUrlReady(null, (ExecutorService)URL_RESOLVE_RP, (URL)candidates.get(0), 500)) {
                            return (URL)candidates.get(0);
                        }
                        return c;
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            return null;
        }

        public Target getTarget() {
            int index;
            Target delegate = this.moduleId.getTarget();
            if (delegate == null) {
                return null;
            }
            String target = delegate.getName();
            if (target != null && (index = target.indexOf("/server")) >= 0) {
                return new WLTarget(target.substring(index));
            }
            return target == null ? delegate : new WLTarget(target);
        }

        public TargetModuleID getParentTargetModuleID() {
            if (this.moduleId.getParentTargetModuleID() == null) {
                return null;
            }
            return new ServerTargetModuleID(this.moduleId.getParentTargetModuleID());
        }

        public String getModuleID() {
            return this.moduleId.getModuleID();
        }

        public TargetModuleID[] getChildTargetModuleID() {
            return WLDeploymentManager.this.translateTargetModuleIDsToPlugin(this.moduleId.getChildTargetModuleID());
        }
    }

    private static interface Action<T> {
        public T execute(DeploymentManager var1) throws ExecutionException;
    }

    private static class InstancePropertiesCredentials
    implements WebLogicConfiguration.Credentials {
        private final WeakReference<InstanceProperties> ip;

        public InstancePropertiesCredentials(InstanceProperties ip) {
            this.ip = new WeakReference<InstanceProperties>(ip);
        }

        public String getUsername() {
            InstanceProperties real = (InstanceProperties)this.ip.get();
            if (real == null) {
                throw new IllegalStateException("Already removed InstanceProperties");
            }
            return real.getProperty("username");
        }

        public String getPassword() {
            InstanceProperties real = (InstanceProperties)this.ip.get();
            if (real == null) {
                throw new IllegalStateException("Already removed InstanceProperties");
            }
            return real.getProperty("password");
        }
    }
}

