/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.JdbcChildrenFactory;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.UnregisterCookie;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JdbcRetriever
implements JdbcChildrenFactory.Retriever {
    private static final Logger LOGGER = Logger.getLogger(JdbcRetriever.class.getName());
    private static final String JDBC = "jdbc";
    private static final int UNREGISTER_WAIT_TIME = 60000;
    private static final int UNREGISTER_TIMEOUT = 120000;
    private final AtomicReference<List<JdbcChildrenFactory.JDBCDataBean>> data = new AtomicReference();
    private final Lookup lookup;
    private boolean isRetrieveStarted;

    public JdbcRetriever(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void clean() {
        this.data.set(null);
    }

    @Override
    public List<JdbcChildrenFactory.JDBCDataBean> get() {
        return this.data.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retrieve() {
        JdbcRetriever jdbcRetriever = this;
        synchronized (jdbcRetriever) {
            if (this.isRetrieveStarted) {
                return;
            }
            this.isRetrieveStarted = true;
        }
        this.data.set(null);
        WLDeploymentManager manager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
        WLConnectionSupport support = manager.getConnectionSupport();
        List<Object> list = Collections.emptyList();
        try {
            list = support.executeAction(new WLConnectionSupport.JMXRuntimeAction<List<JdbcChildrenFactory.JDBCDataBean>>(){

                @Override
                public List<JdbcChildrenFactory.JDBCDataBean> call(MBeanServerConnection con, ObjectName service) throws Exception {
                    LinkedList<JdbcChildrenFactory.JDBCDataBean> list = new LinkedList<JdbcChildrenFactory.JDBCDataBean>();
                    ObjectName[] adminServers = (ObjectName[])con.getAttribute(service, "ServerRuntimes");
                    HashSet<String> adminNames = new HashSet<String>();
                    for (ObjectName adminServer : adminServers) {
                        adminNames.add(con.getAttribute(adminServer, "Name").toString());
                    }
                    ObjectName config = (ObjectName)con.getAttribute(service, "DomainConfiguration");
                    this.findSystemJdbc(con, list, adminNames, config);
                    this.findDeployedJdbc(con, list, adminNames, config);
                    return list;
                }

                private void findDeployedJdbc(MBeanServerConnection con, List<JdbcChildrenFactory.JDBCDataBean> list, Set<String> adminNames, ObjectName config) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
                    ObjectName[] applications;
                    for (ObjectName application : applications = (ObjectName[])con.getAttribute(config, "AppDeployments")) {
                        ObjectName[] targets;
                        Object objType = con.getAttribute(application, "ModuleType");
                        if (objType == null || !JdbcRetriever.JDBC.equals(objType.toString())) continue;
                        boolean foundAdminServer = false;
                        for (ObjectName target : targets = (ObjectName[])con.getAttribute(application, "Targets")) {
                            String targetServer = con.getAttribute(target, "Name").toString();
                            if (!adminNames.contains(targetServer)) continue;
                            foundAdminServer = true;
                        }
                        if (!foundAdminServer) continue;
                        String path = (String)con.getAttribute(application, "AbsoluteSourcePath");
                        String name = (String)con.getAttribute(application, "Name");
                        if (path == null) continue;
                        JdbcRetriever.this.loadDeployedDataSource(path, list, name);
                    }
                }

                private void findSystemJdbc(MBeanServerConnection con, List<JdbcChildrenFactory.JDBCDataBean> list, Set<String> adminNames, ObjectName objectName) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
                    ObjectName[] objectNames;
                    for (ObjectName resource : objectNames = (ObjectName[])con.getAttribute(objectName, "SystemResources")) {
                        String type = con.getAttribute(resource, "Type").toString();
                        if (!"JDBCSystemResource".equals(type)) continue;
                        ObjectName dataSource = (ObjectName)con.getAttribute(resource, "JDBCResource");
                        ObjectName[] targets = (ObjectName[])con.getAttribute(resource, "Targets");
                        String name = con.getAttribute(dataSource, "Name").toString();
                        boolean foundAdminServer = false;
                        for (ObjectName target : targets) {
                            String targetServer = con.getAttribute(target, "Name").toString();
                            if (!adminNames.contains(targetServer)) continue;
                            foundAdminServer = true;
                        }
                        if (!foundAdminServer) continue;
                        ObjectName dataSourceParams = (ObjectName)con.getAttribute(dataSource, "JDBCDataSourceParams");
                        String[] jndiNames = (String[])con.getAttribute(dataSourceParams, "JNDINames");
                        JdbcChildrenFactory.JDBCDataBean bean = new JdbcChildrenFactory.JDBCDataBean(name, jndiNames);
                        list.add(bean);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
        }
        finally {
            this.data.compareAndSet(null, list);
            JdbcRetriever jdbcRetriever2 = this;
            synchronized (jdbcRetriever2) {
                this.isRetrieveStarted = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion() {
        JdbcRetriever jdbcRetriever = this;
        synchronized (jdbcRetriever) {
            while (this.isRetrieveStarted) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.FINE, null, e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void loadDeployedDataSource(String path, List<JdbcChildrenFactory.JDBCDataBean> list, String deplName) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            JdbcConfigHandler handler = new JdbcConfigHandler();
            FileObject jdbcConfig = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(path)));
            if (jdbcConfig == null) {
                return;
            }
            parser.parse((InputStream)new BufferedInputStream(jdbcConfig.getInputStream()), (DefaultHandler)handler);
            List<String> jndiNames = handler.getJndiNames();
            list.add(new JdbcChildrenFactory.JDBCDataBean(handler.getName(), jndiNames.toArray(new String[jndiNames.size()]), deplName));
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (SAXException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, null, e);
        }
    }

    private static class UnableLockException
    extends Exception {
        private static final long serialVersionUID = 1491526792800773444L;

        private UnableLockException() {
        }
    }

    private static class UnregisterJdbcPool
    implements UnregisterCookie {
        private final String resourceName;
        private final RefreshModulesCookie cookie;
        private final Lookup lookup;

        UnregisterJdbcPool(String name, RefreshModulesCookie cookie, Lookup lookup) {
            this.resourceName = name;
            this.cookie = cookie;
            this.lookup = lookup;
        }

        @Override
        public void unregister() {
            WLDeploymentManager manager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
            WLConnectionSupport support = manager.getConnectionSupport();
            try {
                support.executeAction(new WLConnectionSupport.JMXEditAction<Void>(){

                    @Override
                    public Void call(MBeanServerConnection con, ObjectName service) throws Exception {
                        StringBuilder dataSourceCanonicalName = new StringBuilder("com.bea:Name=");
                        dataSourceCanonicalName.append(UnregisterJdbcPool.this.resourceName);
                        dataSourceCanonicalName.append(",Type=JDBCSystemResource");
                        ObjectName dataSourceBean = new ObjectName(dataSourceCanonicalName.toString());
                        this.disable(con, service, dataSourceBean);
                        return null;
                    }

                    private void disable(MBeanServerConnection connection, ObjectName service, ObjectName dataSourceBean) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, MalformedObjectNameException, UnableLockException {
                        ObjectName manager = (ObjectName)connection.getAttribute(service, "ConfigurationManager");
                        ObjectName domainConfigRoot = (ObjectName)connection.invoke(manager, "startEdit", new Object[]{60000, 120000}, new String[]{"java.lang.Integer", "java.lang.Integer"});
                        if (domainConfigRoot == null) {
                            throw new UnableLockException();
                        }
                        try {
                            ObjectName[] targets;
                            for (ObjectName target : targets = (ObjectName[])connection.getAttribute(dataSourceBean, "Targets")) {
                                connection.invoke(dataSourceBean, "removeTarget", new Object[]{target}, new String[]{"javax.management.ObjectName"});
                            }
                        }
                        catch (InstanceNotFoundException e) {
                            ObjectName[] targets;
                            StringBuilder deploymentCanonicalName = new StringBuilder("com.bea:Name=");
                            deploymentCanonicalName.append(UnregisterJdbcPool.this.resourceName);
                            deploymentCanonicalName.append(",Type=AppDeployment");
                            ObjectName application = new ObjectName(deploymentCanonicalName.toString());
                            for (ObjectName target : targets = (ObjectName[])connection.getAttribute(application, "Targets")) {
                                connection.invoke(application, "removeTarget", new Object[]{target}, new String[]{"javax.management.ObjectName"});
                            }
                        }
                        connection.invoke(manager, "save", null, null);
                        ObjectName activationTask = (ObjectName)connection.invoke(manager, "activate", new Object[]{120000}, new String[]{"java.lang.Long"});
                        connection.invoke(activationTask, "waitForTaskCompletion", null, null);
                    }
                });
            }
            catch (UnableLockException e) {
                this.failNotify();
            }
            catch (MBeanException e) {
                Exception targetException = e.getTargetException();
                if (targetException.getClass().getCanonicalName().equals("weblogic.management.mbeanservers.edit.EditTimedOutException")) {
                    this.failNotify();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
            this.cookie.refresh();
        }

        private void failNotify() {
            NotifyDescriptor.Message notDesc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JdbcRetriever.class, (String)"MSG_UnableUnregister"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
        }
    }

    private static class UnregisterJdbcJndiName
    implements UnregisterCookie {
        private final String jndiName;
        private final RefreshModulesCookie cookie;
        private final Lookup lookup;

        UnregisterJdbcJndiName(String jndiName, RefreshModulesCookie cookie, Lookup lookup) {
            this.jndiName = jndiName;
            this.cookie = cookie;
            this.lookup = lookup;
        }

        @Override
        public void unregister() {
            WLDeploymentManager manager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
            WLConnectionSupport support = manager.getConnectionSupport();
            try {
                support.executeAction(new WLConnectionSupport.JMXEditAction<Void>(){

                    @Override
                    public Void call(MBeanServerConnection con, ObjectName service) throws Exception {
                        ObjectName config = (ObjectName)con.getAttribute(service, "DomainConfiguration");
                        ObjectName[] resources = (ObjectName[])con.getAttribute(config, "SystemResources");
                        ObjectName manager = (ObjectName)con.getAttribute(service, "ConfigurationManager");
                        ObjectName domainConfigRoot = (ObjectName)con.invoke(manager, "startEdit", new Object[]{60000, 120000}, new String[]{"java.lang.Integer", "java.lang.Integer"});
                        if (domainConfigRoot == null) {
                            throw new UnableLockException();
                        }
                        for (ObjectName resource : resources) {
                            String type = con.getAttribute(resource, "Type").toString();
                            if (!"JDBCSystemResource".equals(type)) continue;
                            ObjectName jdbcResource = (ObjectName)con.getAttribute(resource, "JDBCResource");
                            ObjectName params = (ObjectName)con.getAttribute(jdbcResource, "JDBCDataSourceParams");
                            con.invoke(params, "removeJNDIName", new Object[]{UnregisterJdbcJndiName.this.jndiName}, new String[]{"java.lang.String"});
                        }
                        con.invoke(manager, "save", null, null);
                        ObjectName activationTask = (ObjectName)con.invoke(manager, "activate", new Object[]{120000}, new String[]{"java.lang.Long"});
                        con.invoke(activationTask, "waitForTaskCompletion", null, null);
                        return null;
                    }
                });
            }
            catch (UnableLockException e) {
                this.failNotify();
            }
            catch (MBeanException e) {
                Exception targetException = e.getTargetException();
                if (targetException.getClass().getCanonicalName().equals("weblogic.management.mbeanservers.edit.EditTimedOutException")) {
                    this.failNotify();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
            this.cookie.refresh();
        }

        private void failNotify() {
            NotifyDescriptor.Message notDesc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JdbcRetriever.class, (String)"MSG_UnableUnregister"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
        }
    }

    private static class JdbcConfigHandler
    extends DefaultHandler {
        private static final String DATA_SOURCE_PARAMS = "jdbc-data-source-params";
        private final List<String> jndiNames = new LinkedList<String>();
        private final StringBuilder content = new StringBuilder();
        private String name;
        private boolean dataSourceParamsStarted;

        private JdbcConfigHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.content.setLength(0);
            if (DATA_SOURCE_PARAMS.equals(this.getUnprefixedName(qName))) {
                this.dataSourceParamsStarted = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.name == null && "name".equals(this.getUnprefixedName(qName))) {
                this.name = this.content.toString();
            } else if (DATA_SOURCE_PARAMS.equals(this.getUnprefixedName(qName))) {
                this.dataSourceParamsStarted = false;
            } else if (this.dataSourceParamsStarted && "jndi-name".equals(this.getUnprefixedName(qName))) {
                this.jndiNames.add(this.content.toString());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.content.append(ch, start, length);
        }

        String getName() {
            return this.name;
        }

        List<String> getJndiNames() {
            return this.jndiNames;
        }

        private String getUnprefixedName(String name) {
            if (name.contains(":")) {
                return name.substring(name.indexOf(":") + 1);
            }
            return name;
        }
    }

    public static class JdbcUnregisterFactory
    implements JdbcChildrenFactory.UnregisterFactory {
        @Override
        public UnregisterCookie createUnregisterForPool(String name, RefreshModulesCookie refresh, Lookup lookup) {
            return new UnregisterJdbcPool(name, refresh, lookup);
        }

        @Override
        public UnregisterCookie createUnregisterForResource(String name, RefreshModulesCookie refresh, Lookup lookup) {
            return new UnregisterJdbcJndiName(name, refresh, lookup);
        }
    }
}

