/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.modules.javafx2.project.fxml.ConfigureFXMLControllerPanelVisual;
import org.netbeans.modules.javafx2.project.fxml.FXMLTemplateWizardIterator;
import org.netbeans.modules.javafx2.project.fxml.SourceGroupSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class JSEApplicationClassChooser
extends JPanel
implements ActionListener,
DocumentListener {
    static final String JAVA_FILE_EXTENSION = ".java";
    private final PropertyEvaluator evaluator;
    private final Project project;
    private ChangeListener changeListener;
    private final boolean isFXinSwing;
    private SourceGroupSupport support;
    private boolean ignoreRootCombo;
    private RequestProcessor.Task updatePackagesTask;
    private static final ComboBoxModel WAIT_MODEL = SourceGroupSupport.getWaitModel();
    private ButtonGroup buttonGroup1;
    private JComboBox comboBoxPackage;
    private JComboBox comboBoxSourceRoot;
    private JLabel labelClassName;
    private JLabel labelFileLocation;
    private JLabel labelMessage;
    private JLabel labelPackage;
    private JLabel labelSourceRoot;
    private JLabel labelTopComment;
    private JList listAppClasses;
    private JScrollPane listAppClassesScrollPane;
    private JRadioButton radioButtonNewClass;
    private JRadioButton radioButtonSelectClass;
    private JTextField textFieldClassName;
    private JTextField textFieldFileLocation;

    public JSEApplicationClassChooser(@NonNull Project p, @NonNull PropertyEvaluator pe) {
        this.evaluator = pe;
        this.project = p;
        this.isFXinSwing = JFXProjectUtils.isFXinSwingProject(p);
        this.initComponents();
        this.initComponents2();
        if (!SourceUtils.isScanInProgress()) {
            this.labelMessage.setText(null);
        }
        this.listAppClasses.setCellRenderer(new AppClassRenderer());
        this.initClassesView();
        this.initClassesModel();
        this.initCombos();
        this.refreshComponents();
    }

    private void initComponents2() {
        this.textFieldClassName.getDocument().addDocumentListener(this);
        this.comboBoxPackage.getEditor().addActionListener(this);
        Component packageEditor = this.comboBoxPackage.getEditor().getEditorComponent();
        if (packageEditor instanceof JTextField) {
            ((JTextField)packageEditor).getDocument().addDocumentListener(this);
        }
        this.comboBoxSourceRoot.setRenderer(new SourceGroupSupport.GroupListCellRenderer());
        this.comboBoxPackage.setRenderer(PackageView.listRenderer());
        this.comboBoxSourceRoot.addActionListener(this);
    }

    private void initCombos() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] sourceGroupsJava = sources.getSourceGroups("java");
        if (sourceGroupsJava == null) {
            throw new IllegalStateException(NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"MSG_ConfigureFXMLPanel_SGs_Error"));
        }
        this.support = new SourceGroupSupport("java");
        this.support.addSourceGroups(sourceGroupsJava);
        this.comboBoxSourceRoot.setModel(new DefaultComboBoxModel<Object>(this.support.getSourceGroups().toArray()));
        this.updatePackages();
        this.updateText();
        this.updateResult();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.labelTopComment = new JLabel();
        this.radioButtonNewClass = new JRadioButton();
        this.labelClassName = new JLabel();
        this.textFieldClassName = new JTextField();
        this.labelSourceRoot = new JLabel();
        this.comboBoxSourceRoot = new JComboBox();
        this.labelPackage = new JLabel();
        this.comboBoxPackage = new JComboBox();
        this.labelFileLocation = new JLabel();
        this.radioButtonSelectClass = new JRadioButton();
        this.textFieldFileLocation = new JTextField();
        this.listAppClassesScrollPane = new JScrollPane();
        this.listAppClasses = new JList();
        this.labelMessage = new JLabel();
        this.setPreferredSize(new Dimension(480, 350));
        this.setLayout(new GridBagLayout());
        this.labelTopComment.setText(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"JSEApplicationClassChooser.labelTopComment.text"));
        this.labelTopComment.setVerticalAlignment(1);
        this.labelTopComment.setMinimumSize(new Dimension(470, 40));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.labelTopComment, gridBagConstraints);
        this.buttonGroup1.add(this.radioButtonNewClass);
        this.radioButtonNewClass.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioButtonNewClass, (String)NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"JSEApplicationClassChooser.radioButtonNewClass.text"));
        this.radioButtonNewClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSEApplicationClassChooser.this.radioButtonNewClassActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.add((Component)this.radioButtonNewClass, gridBagConstraints);
        this.radioButtonNewClass.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AN_JFXApplicationClassChooser.radioButtonNewClass"));
        this.radioButtonNewClass.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AD_JFXApplicationClassChooser.radioButtonNewClass"));
        this.labelClassName.setLabelFor(this.textFieldClassName);
        Mnemonics.setLocalizedText((JLabel)this.labelClassName, (String)NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"JSEApplicationClassChooser.labelClassName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 20, 0, 0);
        this.add((Component)this.labelClassName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.add((Component)this.textFieldClassName, gridBagConstraints);
        this.textFieldClassName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AN_JFXApplicationClassChooser.textFieldClassName"));
        this.textFieldClassName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AD_JFXApplicationClassChooser.textFieldClassName"));
        this.labelSourceRoot.setLabelFor(this.comboBoxSourceRoot);
        Mnemonics.setLocalizedText((JLabel)this.labelSourceRoot, (String)NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"JSEApplicationClassChooser.labelSourceRoot.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 20, 0, 0);
        this.add((Component)this.labelSourceRoot, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.add((Component)this.comboBoxSourceRoot, gridBagConstraints);
        this.comboBoxSourceRoot.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AN_JFXApplicationClassChooser.comboBoxSourceRoot"));
        this.comboBoxSourceRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AD_JFXApplicationClassChooser.comboBoxSourceRoot"));
        this.labelPackage.setLabelFor(this.comboBoxPackage);
        Mnemonics.setLocalizedText((JLabel)this.labelPackage, (String)NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"JSEApplicationClassChooser.labelPackage.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 20, 0, 0);
        this.add((Component)this.labelPackage, gridBagConstraints);
        this.comboBoxPackage.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.add((Component)this.comboBoxPackage, gridBagConstraints);
        this.comboBoxPackage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AN_JFXApplicationClassChooser.comboBoxPackage"));
        this.comboBoxPackage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AD_JFXApplicationClassChooser.comboBoxPackage"));
        this.labelFileLocation.setLabelFor(this.textFieldFileLocation);
        this.labelFileLocation.setText(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"JSEApplicationClassChooser.labelFileLocation.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 20, 0, 0);
        this.add((Component)this.labelFileLocation, gridBagConstraints);
        this.buttonGroup1.add(this.radioButtonSelectClass);
        Mnemonics.setLocalizedText((AbstractButton)this.radioButtonSelectClass, (String)NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"JSEApplicationClassChooser.radioButtonSelectClass.text"));
        this.radioButtonSelectClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSEApplicationClassChooser.this.radioButtonSelectClassActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(15, 5, 0, 0);
        this.add((Component)this.radioButtonSelectClass, gridBagConstraints);
        this.radioButtonSelectClass.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AN_JFXApplicationClassChooser.radioButtonSelectClass"));
        this.radioButtonSelectClass.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AD_JFXApplicationClassChooser.radioButtonSelectClass"));
        this.textFieldFileLocation.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.add((Component)this.textFieldFileLocation, gridBagConstraints);
        this.listAppClasses.setModel(new AbstractListModel(){
            String[] strings = new String[]{"<No Application class found in current project>"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.listAppClassesScrollPane.setViewportView(this.listAppClasses);
        this.listAppClasses.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AN_JFXApplicationClassChooser.listAppClasses"));
        this.listAppClasses.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"AD_JFXApplicationClassChooser.listAppClasses"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 10);
        this.add((Component)this.listAppClassesScrollPane, gridBagConstraints);
        this.labelMessage.setFont(this.labelMessage.getFont().deriveFont(this.labelMessage.getFont().getStyle() | 2));
        this.labelMessage.setText(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"LBL_ChooseMainClass_SCANNING_MESSAGE"));
        this.labelMessage.setMinimumSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 7, 0, 0);
        this.add((Component)this.labelMessage, gridBagConstraints);
        this.labelMessage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"LBL_ChooseMainClass_SCANNING_MESSAGE"));
    }

    private void fireChange(Object evt) {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(evt));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.comboBoxSourceRoot == e.getSource()) {
            if (!this.ignoreRootCombo) {
                this.updatePackages();
            }
            this.updateText();
            this.updateResult();
            this.fireChange(e);
        } else if (this.comboBoxPackage == e.getSource()) {
            this.updateText();
            this.updateResult();
            this.fireChange(e);
        } else if (this.comboBoxPackage.getEditor() == e.getSource()) {
            this.updateText();
            this.updateResult();
            this.fireChange(e);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.getNewClassName() == null) {
            this.fireChange(e);
        } else {
            this.changedUpdate(e);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateText();
        this.updateResult();
        this.fireChange(e);
    }

    private void updatePackages() {
        final Object item = this.comboBoxSourceRoot.getSelectedItem();
        if (!(item instanceof SourceGroupSupport.SourceGroupProxy)) {
            return;
        }
        WAIT_MODEL.setSelectedItem(this.comboBoxPackage.getEditor().getItem());
        this.comboBoxPackage.setModel(WAIT_MODEL);
        if (this.updatePackagesTask != null) {
            this.updatePackagesTask.cancel();
        }
        this.updatePackagesTask = new RequestProcessor("ComboUpdatePackages").post(new Runnable(){

            @Override
            public void run() {
                final ComboBoxModel model = ((SourceGroupSupport.SourceGroupProxy)item).getPackagesComboBoxModel();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        model.setSelectedItem(JSEApplicationClassChooser.this.comboBoxPackage.getEditor().getItem());
                        JSEApplicationClassChooser.this.comboBoxPackage.setModel(model);
                    }
                });
            }
        });
    }

    private void updateText() {
        String className = this.getNewClassName();
        if (className == null) {
            ProjectInformation info = ProjectUtils.getInformation((Project)this.project);
            className = info.getName();
            String firstChar = String.valueOf(className.charAt(0)).toUpperCase();
            String otherChars = className.substring(1);
            className = firstChar + otherChars + NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"TXT_FileNameApplicationClassPostfix");
            this.textFieldClassName.setText(className);
        }
    }

    private void updateResult() {
        String createdFileName;
        String className = this.getNewClassName();
        if (className == null) {
            this.textFieldFileLocation.setText(null);
            return;
        }
        Object selectedItem = this.comboBoxSourceRoot.getSelectedItem();
        if (selectedItem instanceof SourceGroupSupport.SourceGroupProxy) {
            String path;
            SourceGroupSupport.SourceGroupProxy g = (SourceGroupSupport.SourceGroupProxy)selectedItem;
            String packageName = this.getPackageName();
            this.support.setCurrentSourceGroup(g);
            this.support.setCurrentPackageName(packageName);
            this.support.setCurrentFileName(className);
            if (className != null && className.length() > 0) {
                className = className + JAVA_FILE_EXTENSION;
            }
            createdFileName = (path = this.support.getCurrentPackagePath()) == null ? "" : path.replace(".", "/") + className;
        } else {
            createdFileName = "";
        }
        this.textFieldFileLocation.setText(createdFileName.replace('/', File.separatorChar));
    }

    private void refreshComponents() {
        boolean newClass = this.radioButtonNewClass.isSelected();
        this.labelClassName.setEnabled(newClass);
        this.labelSourceRoot.setEnabled(newClass);
        this.labelPackage.setEnabled(newClass);
        this.labelFileLocation.setEnabled(newClass);
        this.textFieldClassName.setEnabled(newClass);
        this.comboBoxSourceRoot.setEnabled(newClass);
        this.comboBoxPackage.setEnabled(newClass);
        this.textFieldFileLocation.setEnabled(newClass);
        this.listAppClasses.setEnabled(!newClass);
        this.listAppClassesScrollPane.setEnabled(!newClass);
    }

    private void radioButtonNewClassActionPerformed(ActionEvent evt) {
        this.refreshComponents();
        this.fireChange(evt);
    }

    private void radioButtonSelectClassActionPerformed(ActionEvent evt) {
        this.refreshComponents();
        this.fireChange(evt);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListener = null;
    }

    private Object[] getWarmupList() {
        return new Object[]{NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"Item_ChooseMainClass_WARMUP_MESSAGE")};
    }

    private Object[] getEmptyList() {
        return new Object[]{NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"Item_ChooseMainClass_EMPTY_MESSAGE")};
    }

    private void initClassesView() {
        this.listAppClasses.setSelectionMode(0);
        this.listAppClasses.setListData(this.getWarmupList());
        this.listAppClasses.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JSEApplicationClassChooser.this.fireChange(evt);
            }
        });
        this.listAppClasses.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e) && JSEApplicationClassChooser.this.getSelectedExistingClass() != null) {
                    JSEApplicationClassChooser.this.fireChange(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void initClassesModel() {
        final Map<FileObject, List<ClassPath>> classpathMap = JFXProjectUtils.getClassPathMap(this.project);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                final Set<String> appClassNames = JSEApplicationClassChooser.this.isFXinSwing ? JFXProjectUtils.getMainClassNames(JSEApplicationClassChooser.this.project) : JFXProjectUtils.getAppClassNames(classpathMap, "javafx.application.Application");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (appClassNames.isEmpty()) {
                            JSEApplicationClassChooser.this.radioButtonNewClass.setSelected(true);
                            JSEApplicationClassChooser.this.radioButtonSelectClass.setEnabled(false);
                            JSEApplicationClassChooser.this.listAppClasses.setEnabled(false);
                            JSEApplicationClassChooser.this.listAppClassesScrollPane.setEnabled(false);
                            JSEApplicationClassChooser.this.listAppClasses.setListData(JSEApplicationClassChooser.this.getEmptyList());
                        } else {
                            JSEApplicationClassChooser.this.listAppClasses.setListData(appClassNames.toArray());
                            String appClassName = JSEApplicationClassChooser.this.evaluator.getProperty(JSEApplicationClassChooser.this.isFXinSwing ? "main.class" : "javafx.main.class");
                            if (appClassName != null && appClassNames.contains(appClassName)) {
                                JSEApplicationClassChooser.this.listAppClasses.setSelectedValue(appClassName, true);
                            }
                        }
                    }
                });
            }
        });
    }

    public String getSelectedExistingClass() {
        Object sel = this.listAppClasses.getSelectedValue();
        if (sel == null) {
            return null;
        }
        if (sel instanceof String) {
            return (String)sel;
        }
        return null;
    }

    public String getNewClassName() {
        String text = this.textFieldClassName.getText().trim();
        return text.length() == 0 ? null : text;
    }

    public FileObject getLocationFolder() {
        Object selectedItem = this.comboBoxSourceRoot.getSelectedItem();
        return selectedItem instanceof SourceGroupSupport.SourceGroupProxy ? ((SourceGroupSupport.SourceGroupProxy)selectedItem).getRootFolder() : null;
    }

    public String getPackageFileName() {
        return this.getPackageName().replace('.', '/');
    }

    public String getPackageName() {
        return this.comboBoxPackage.getEditor().getItem().toString();
    }

    public FileObject getCurrentPackageFolder(boolean create) {
        return this.support.getCurrentPackageFolder(create);
    }

    public String getCurrentFileName() {
        return this.support.getCurrentFileName();
    }

    String isNewClassValid() {
        if (!this.radioButtonNewClass.isSelected()) {
            return null;
        }
        if (!Utilities.isJavaIdentifier((String)this.getNewClassName())) {
            return NbBundle.getMessage(JSEApplicationClassChooser.class, (String)"WARN_Provide_Java_Class_Name");
        }
        return FXMLTemplateWizardIterator.canUseFileName(FileUtil.toFile((FileObject)this.support.getCurrentChooserFolder()), this.getNewClassName() + JAVA_FILE_EXTENSION);
    }

    public boolean isClassSelectionValid() {
        if (this.radioButtonNewClass.isSelected()) {
            if (!FXMLTemplateWizardIterator.isValidPackageName(this.getPackageName())) {
                this.labelMessage.setText(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"WARN_ConfigureFXMLPanel_Provide_Package_Name"));
                return false;
            }
            if (!FXMLTemplateWizardIterator.isValidPackage(this.getLocationFolder(), this.getPackageName())) {
                this.labelMessage.setText(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"WARN_ConfigureFXMLPanel_Package_Invalid"));
                return false;
            }
            String errorMessage = this.isNewClassValid();
            this.labelMessage.setText(errorMessage);
            return errorMessage == null;
        }
        this.labelMessage.setText(null);
        return this.getSelectedExistingClass() != null;
    }

    private static final class AppClassRenderer
    extends DefaultListCellRenderer {
        private AppClassRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayName = value instanceof String ? (String)value : value.toString();
            return super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
        }
    }
}

