/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsEnvironment;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.settings.GrailsSettings;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class GrailsProjectConfig {
    public static final String GRAILS_PORT_PROPERTY = "grails.port";
    public static final String GRAILS_ENVIRONMENT_PROPERTY = "grails.environment";
    public static final String GRAILS_JAVA_PLATFORM_PROPERTY = "grails.java.platform";
    public static final String GRAILS_PLATFORM_PROPERTY = "grails.platform";
    public static final String GRAILS_DEBUG_BROWSER_PROPERTY = "grails.debug.browser";
    public static final String GRAILS_DISPLAY_BROWSER_PROPERTY = "grails.display.browser";
    public static final String GRAILS_PROJECT_PLUGINS_DIR_PROPERTY = "grails.project.plugins.dir";
    public static final String GRAILS_GLOBAL_PLUGINS_DIR_PROPERTY = "grails.global.plugins.dir";
    public static final String GRAILS_PROJECT_WORK_DIR_PROPERTY = "grails.project.work.dir";
    public static final String GRAILS_WORK_DIR_PROPERTY = "grails.work.dir";
    public static final String GRAILS_IVY_CACHE_DIR_PROPERTY = "grails.dependency.cache.dir";
    public static final String GRAILS_LOCAL_PLUGINS_PROPERTY = "grails.local.plugins";
    public static final String GRAILS_VM_OPTIONS_PROPERTY = "grails.vm.options";
    private static final String DEFAULT_PORT = "8080";
    private static final JavaPlatformManager PLATFORM_MANAGER = JavaPlatformManager.getDefault();
    private final Project prj;
    private final GrailsSettings settings = GrailsSettings.getInstance();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final PlatformChangeListener platformChangeListener = new PlatformChangeListener(this.propertyChangeSupport);

    public GrailsProjectConfig(Project prj) {
        this.prj = prj;
    }

    public void initListeners() {
        GrailsPlatform platform = GrailsPlatform.getDefault();
        platform.addChangeListener(WeakListeners.change((ChangeListener)this.platformChangeListener, (Object)platform));
    }

    public static GrailsProjectConfig forProject(Project project) {
        GrailsProjectConfig config = (GrailsProjectConfig)project.getLookup().lookup(GrailsProjectConfig.class);
        return config;
    }

    public Project getProject() {
        return this.prj;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPort() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            String port = this.settings.getPortForProject(this.prj);
            if (port == null) {
                port = DEFAULT_PORT;
            }
            return port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(String port) {
        String oldValue;
        assert (port != null);
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            oldValue = this.getPort();
            this.settings.setPortForProject(this.prj, port);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_PORT_PROPERTY, oldValue, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVmOptions() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            String port = this.settings.getVmOptionsForProject(this.prj);
            if (port == null) {
                port = "";
            }
            return port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVmOptions(String options) {
        String oldValue;
        assert (options != null);
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            oldValue = this.getPort();
            this.settings.setVmOptionsForProject(this.prj, options);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_VM_OPTIONS_PROPERTY, oldValue, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrailsEnvironment getEnvironment() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            return this.settings.getEnvForProject(this.prj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnvironment(GrailsEnvironment env) {
        GrailsEnvironment oldValue;
        assert (env != null);
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            oldValue = this.getEnvironment();
            this.settings.setEnvForProject(this.prj, env);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_ENVIRONMENT_PROPERTY, oldValue, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDebugBrowser() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            return this.settings.getDebugBrowserForProject(this.prj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDebugBrowser(String browser) {
        String oldValue;
        assert (browser != null);
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            oldValue = this.getDebugBrowser();
            this.settings.setDebugBrowserProject(this.prj, browser);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_DEBUG_BROWSER_PROPERTY, oldValue, browser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaPlatform getJavaPlatform() {
        JavaPlatform[] platforms;
        String platformId;
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            platformId = this.settings.getJavaPlatformForProject(this.prj);
        }
        if (platformId == null) {
            return JavaPlatform.getDefault();
        }
        for (JavaPlatform platform : platforms = PLATFORM_MANAGER.getPlatforms(null, new Specification("j2se", null))) {
            String antName;
            if (platform.getInstallFolders().size() <= 0 || !platformId.equals(antName = (String)platform.getProperties().get("platform.ant.name"))) continue;
            return platform;
        }
        return JavaPlatform.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaPlatform(JavaPlatform platform) {
        JavaPlatform oldValue;
        assert (platform != null);
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            oldValue = this.getJavaPlatform();
            this.settings.setJavaPlatformForProject(this.prj, (String)platform.getProperties().get("platform.ant.name"));
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_JAVA_PLATFORM_PROPERTY, oldValue, platform);
    }

    public GrailsPlatform getGrailsPlatform() {
        GrailsPlatform runtime = GrailsPlatform.getDefault();
        return runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDisplayBrowser() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            return this.settings.getDisplayBrowserForProject(this.prj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayBrowser(boolean displayBrowser) {
        boolean oldValue;
        GrailsProjectConfig grailsProjectConfig = this;
        synchronized (grailsProjectConfig) {
            oldValue = this.getDisplayBrowser();
            this.settings.setDisplayBrowserForProject(this.prj, displayBrowser);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_DISPLAY_BROWSER_PROPERTY, oldValue, displayBrowser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getProjectPluginsDir() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            String value = this.settings.getProjectPluginsDirForProject(this.prj);
            if (value != null) {
                return new File(value);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectPluginsDir(File dir) {
        File oldValue;
        assert (FileUtil.normalizeFile((File)dir).equals(dir));
        GrailsProjectConfig grailsProjectConfig = this;
        synchronized (grailsProjectConfig) {
            oldValue = this.getProjectPluginsDir();
            this.settings.setProjectPluginsDirForProject(this.prj, dir.getAbsolutePath());
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_PROJECT_PLUGINS_DIR_PROPERTY, oldValue, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getGlobalPluginsDir() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            String value = this.settings.getGlobalPluginsDirForProject(this.prj);
            if (value != null) {
                return new File(value);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalPluginsDir(File dir) {
        File oldValue;
        assert (FileUtil.normalizeFile((File)dir).equals(dir));
        GrailsProjectConfig grailsProjectConfig = this;
        synchronized (grailsProjectConfig) {
            oldValue = this.getGlobalPluginsDir();
            this.settings.setGlobalPluginsDirForProject(this.prj, dir.getAbsolutePath());
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_GLOBAL_PLUGINS_DIR_PROPERTY, oldValue, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, File> getLocalPlugins() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            Map<String, String> value = this.settings.getLocalPluginsForProject(this.prj);
            if (value != null) {
                File base = FileUtil.toFile((FileObject)this.prj.getProjectDirectory());
                HashMap<String, File> ret = new HashMap<String, File>();
                for (Map.Entry<String, String> entry : value.entrySet()) {
                    File file = new File(entry.getValue());
                    if (!file.isAbsolute()) {
                        file = new File(base, entry.getValue());
                    }
                    ret.put(entry.getKey(), file);
                }
                return ret;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalPlugins(Map<String, File> plugins) {
        Map<String, File> oldValue;
        boolean changed = false;
        GrailsProjectConfig grailsProjectConfig = this;
        synchronized (grailsProjectConfig) {
            oldValue = this.getLocalPlugins();
            HashMap<String, String> prepared = new HashMap<String, String>();
            for (Map.Entry<String, File> entry : plugins.entrySet()) {
                prepared.put(entry.getKey(), entry.getValue().getAbsolutePath());
                File oldFile = oldValue.remove(entry.getKey());
                if (oldFile != null && oldFile.equals(entry.getValue())) continue;
                changed = true;
            }
            this.settings.setLocalPluginsForProject(this.prj, prepared);
        }
        if (changed || !oldValue.isEmpty()) {
            this.propertyChangeSupport.firePropertyChange(GRAILS_LOCAL_PLUGINS_PROPERTY, oldValue, plugins);
        }
    }

    private static class PlatformChangeListener
    implements ChangeListener {
        private final PropertyChangeSupport propertyChangeSupport;

        public PlatformChangeListener(PropertyChangeSupport propertyChangeSupport) {
            this.propertyChangeSupport = propertyChangeSupport;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.propertyChangeSupport.firePropertyChange(GrailsProjectConfig.GRAILS_PLATFORM_PROPERTY, null, null);
        }
    }
}

