/*
 * Decompiled with CFR 0.152.
 */
package info.dmtree.security;

import info.dmtree.security.DmtAlertPermissionCollection;
import java.security.Permission;
import java.security.PermissionCollection;

public class AlertPermission
extends Permission {
    private static final long serialVersionUID = -3206463101788245739L;
    private final boolean isPrefix;
    private final String serverId;

    public AlertPermission(String target) {
        super(target);
        if (target == null) {
            throw new NullPointerException("'target' parameter must not be null.");
        }
        if (target.equals("")) {
            throw new IllegalArgumentException("'target' parameter must not be empty.");
        }
        this.isPrefix = target.endsWith("*");
        this.serverId = this.isPrefix ? target.substring(0, target.length() - 1) : target;
    }

    public AlertPermission(String target, String actions) {
        this(target);
        if (actions == null) {
            throw new NullPointerException("'actions' parameter must not be null.");
        }
        if (!actions.equals("*")) {
            throw new IllegalArgumentException("'actions' parameter must be \"*\".");
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AlertPermission)) {
            return false;
        }
        AlertPermission other = (AlertPermission)obj;
        return this.isPrefix == other.isPrefix && this.serverId.equals(other.serverId);
    }

    public String getActions() {
        return "*";
    }

    public int hashCode() {
        return ((Object)new Boolean(this.isPrefix)).hashCode() ^ this.serverId.hashCode();
    }

    public boolean implies(Permission p) {
        if (!(p instanceof AlertPermission)) {
            return false;
        }
        AlertPermission other = (AlertPermission)p;
        return this.impliesServer(other);
    }

    public PermissionCollection newPermissionCollection() {
        return new DmtAlertPermissionCollection();
    }

    boolean impliesServer(AlertPermission p) {
        return this.isPrefix ? p.serverId.startsWith(this.serverId) : !p.isPrefix && p.serverId.equals(this.serverId);
    }
}

