/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import javax.swing.Action;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;

public abstract class Variable {
    protected final Variable parent;
    protected final ModelChangeDelegator updater;
    private String name = "<unset name>";
    protected String type = "";
    protected String value = "";
    protected boolean isLeaf = true;
    protected boolean isPtr = false;
    protected boolean literal = false;
    private boolean isExpanded = false;
    protected boolean waitingForDebugger;
    protected Variable[] children = null;
    private boolean stat;
    protected boolean hasMore = false;

    protected Variable(ModelChangeDelegator updater, Variable parent, String name, String type, String value) {
        this.parent = parent;
        this.updater = updater;
        if (name != null) {
            this.name = name;
        }
        if (type != null) {
            this.type = type;
        }
        if (value != null) {
            this.value = value;
        }
        if (Log.Variable.debug) {
            System.out.printf("Variable.<init>(%s)\n", name);
        }
    }

    public ModelChangeDelegator getUpdater() {
        return this.updater;
    }

    protected void update() {
        if (Log.Variable.debug) {
            System.out.printf("Variable.update()\n", new Object[0]);
        }
        this.updater.treeNodeChanged(this);
    }

    public String getVariableName() {
        return this.name;
    }

    public void setVariableName(String name) {
        this.name = name;
    }

    public String getFullName() {
        StringBuilder res = new StringBuilder(this.name);
        Variable p = this.parent;
        while (p != null) {
            res.insert(0, p.getVariableName() + '.');
            p = p.parent;
        }
        return res.toString();
    }

    public boolean isEditable() {
        return this.isLeaf() && !this.literal || this.isPtr();
    }

    public String getAsText() {
        return this.value;
    }

    public void setAsText(String value) {
        String ovalue = this.value;
        this.value = value == null ? "<null>" : value.trim();
    }

    public void setExpanded(boolean e) {
        if (Log.Variable.expanded) {
            System.out.printf("Variable[%s].setExpanded(%s)\n", this.getVariableName(), e);
        }
        this.isExpanded = e;
    }

    public boolean isExpanded() {
        if (Log.Variable.expanded) {
            System.out.printf("Variable[%s].isExpanded() -> %s\n", this.getVariableName(), this.isExpanded);
        }
        return this.isExpanded;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setStatic(boolean stat) {
        this.stat = stat;
    }

    public boolean isStatic() {
        return this.stat;
    }

    public boolean isLeaf() {
        if (Log.Variable.leaf) {
            System.out.printf("Variable[%s].isLeaf() -> %s\n", this.getVariableName(), this.isLeaf);
        }
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        if (Log.Variable.leaf) {
            System.out.printf("Variable[%s].setLeaf(%s)\n", this.getVariableName(), isLeaf);
        }
        this.isLeaf = isLeaf;
        this.update();
    }

    public void setLiteral(boolean lit) {
        this.literal = lit;
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public void setPtr(boolean e) {
        this.isPtr = e;
    }

    public boolean isPtr() {
        return this.isPtr;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }

    public void setChildren(Variable[] children, boolean andUpdate) {
        if (Log.Variable.debug) {
            int nc = children == null ? -1 : children.length;
            System.out.printf("Variable[%s].setChildren(%d, %s)\n", this.name, nc, andUpdate);
        }
        this.children = children;
        this.waitingForDebugger = false;
        if (andUpdate) {
            this.update();
        }
    }

    private void addChildren(Variable[] extra) {
        Variable[] child_list = new Variable[extra.length + this.children.length];
        int vx = 0;
        for (vx = 0; vx < this.children.length; ++vx) {
            child_list[vx] = this.children[vx];
        }
        int index = vx;
        for (vx = 0; vx < extra.length; ++vx) {
            child_list[index + vx] = extra[vx];
        }
        this.children = child_list;
    }

    public void addChildren(Variable[] extra, boolean andUpdate) {
        if (Log.Variable.debug) {
            int nc = extra == null ? -1 : extra.length;
            System.out.printf("Variable[%s].setChildren(%d, %s)\n", this.name, nc, andUpdate);
        }
        if (extra == null) {
            return;
        }
        this.addChildren(extra);
        this.waitingForDebugger = false;
        if (andUpdate) {
            this.update();
        }
    }

    public int getNumChild() {
        return this.getChildren().length;
    }

    public Variable[] getChildren() {
        if (Log.Variable.debug) {
            int nc = this.children == null ? -1 : this.children.length;
            System.out.printf("Variable[%s].getChildren() -> %d\n", this.name, nc);
        }
        if (this.children != null) {
            return this.children;
        }
        return new Variable[0];
    }

    public void getMoreChildren() {
    }

    public String toString() {
        return this.getVariableName() + '=' + this.getAsText();
    }

    public abstract String getDebugInfo();

    public abstract NativeDebugger getDebugger();

    public abstract void removeAllDescendantFromOpenList(boolean var1);

    public abstract Action[] getActions(boolean var1);

    public abstract boolean getDelta();

    public abstract void setVariableValue(String var1);

    public abstract boolean isArrayBrowsable();

    public abstract void noteExpanded(boolean var1);

    public abstract void noteCollapsed(boolean var1);

    public abstract void postFormat(String var1);

    public abstract String getFormat();

    public abstract void createWatch();
}

