/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.Comparator;
import org.openide.util.CharSequences;

public class CharSequenceUtils {
    public static final Comparator<CharSequence> ComparatorIgnoreCase = new CharSequenceComparatorIgnoreCase();

    public static int indexOf(CharSequence text, CharSequence seq) {
        return CharSequenceUtils.indexOf(text, seq, 0);
    }

    public static int indexOf(CharSequence text, char c) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence text, CharSequence seq, int fromIndex) {
        int textLength = text.length();
        int seqLength = seq.length();
        if (fromIndex >= textLength) {
            return seqLength == 0 ? textLength : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (seqLength == 0) {
            return fromIndex;
        }
        char first = seq.charAt(0);
        int max = textLength - seqLength;
        for (int i = fromIndex; i <= max; ++i) {
            if (text.charAt(i) != first) {
                while (++i <= max && text.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + seqLength - 1;
            int k = 1;
            while (j < end && text.charAt(j) == seq.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence text, CharSequence seq) {
        return CharSequenceUtils.lastIndexOf(text, seq, text.length());
    }

    public static int lastIndexOf(CharSequence text, CharSequence seq, int fromIndex) {
        int start;
        int textLength = text.length();
        int seqLength = seq.length();
        int rightIndex = textLength - seqLength;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (seqLength == 0) {
            return fromIndex;
        }
        int strLastIndex = seqLength - 1;
        char strLastChar = seq.charAt(strLastIndex);
        int min = seqLength - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && text.charAt(i) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (seqLength - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (text.charAt(j--) == seq.charAt(k--)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static int lastIndexOf(CharSequence text, int ch) {
        return CharSequenceUtils.lastIndexOf(text, ch, text.length() - 1);
    }

    public static int lastIndexOf(CharSequence text, int ch, int fromIndex) {
        if (fromIndex > text.length() - 1) {
            fromIndex = text.length() - 1;
        }
        while (fromIndex >= 0) {
            if (text.charAt(fromIndex) == ch) {
                return fromIndex;
            }
            --fromIndex;
        }
        return -1;
    }

    public static boolean contentEquals(CharSequence str1, CharSequence str2) {
        return CharSequences.comparator().compare(str1, str2) == 0;
    }

    public static boolean startsWith(CharSequence text, CharSequence prefix) {
        int p_length = prefix.length();
        if (p_length > text.length()) {
            return false;
        }
        for (int x = 0; x < p_length; ++x) {
            if (text.charAt(x) == prefix.charAt(x)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(CharSequence text, CharSequence prefix) {
        int p_length = prefix.length();
        if (p_length > text.length()) {
            return false;
        }
        for (int x = 0; x < p_length; ++x) {
            char c2;
            char c1 = text.charAt(x);
            if (c1 == (c2 = prefix.charAt(x)) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(CharSequence text, CharSequence suffix) {
        int text_length;
        int s_length = suffix.length();
        if (s_length > (text_length = text.length())) {
            return false;
        }
        for (int x = 0; x < s_length; ++x) {
            if (text.charAt(text_length - s_length + x) == suffix.charAt(x)) continue;
            return false;
        }
        return true;
    }

    public static String toString(CharSequence prefix, char separator, CharSequence postfix) {
        int i;
        int prefLength = prefix.length();
        int postLength = postfix.length();
        char[] chars = new char[prefLength + 1 + postLength];
        int indx = 0;
        if (prefix instanceof String) {
            ((String)prefix).getChars(0, prefLength, chars, indx);
            indx = prefLength;
        } else {
            for (i = 0; i < prefLength; ++i) {
                chars[indx++] = prefix.charAt(i);
            }
        }
        chars[indx++] = separator;
        if (postfix instanceof String) {
            ((String)postfix).getChars(0, postLength, chars, indx);
        } else {
            for (i = 0; i < postLength; ++i) {
                chars[indx++] = postfix.charAt(i);
            }
        }
        return new String(chars);
    }

    public static boolean isNullOrEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static CharSequence concatenate(final char s1, final CharSequence s2) {
        return new CharSequence(){
            private final int l1 = 1;
            private final int l2 = 1 + s2.length();

            @Override
            public int length() {
                return this.l2;
            }

            @Override
            public char charAt(int index) {
                if (index < 1) {
                    return s1;
                }
                return s2.charAt(index - 1);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return new StringBuilder(this.length()).append(s1).append(s2).subSequence(start, end);
            }

            @Override
            public String toString() {
                return new StringBuilder(this.length()).append(s1).append(s2).toString();
            }
        };
    }

    public static CharSequence concatenate(final CharSequence s1, final CharSequence s2) {
        return new CharSequence(){
            private final int l1;
            private final int l2;
            {
                this.l1 = s1.length();
                this.l2 = this.l1 + s2.length();
            }

            @Override
            public int length() {
                return this.l2;
            }

            @Override
            public char charAt(int index) {
                if (index < this.l1) {
                    return s1.charAt(index);
                }
                return s2.charAt(index - this.l1);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return new StringBuilder(this.length()).append(s1).append(s2).subSequence(start, end);
            }

            @Override
            public String toString() {
                return new StringBuilder(this.length()).append(s1).append(s2).toString();
            }
        };
    }

    public static CharSequence concatenate(final char s1, final CharSequence s2, final CharSequence s3) {
        return new CharSequence(){
            private final int l1 = 1;
            private final int l2 = 1 + s2.length();
            private final int l3 = this.l2 + s3.length();

            @Override
            public int length() {
                return this.l3;
            }

            @Override
            public char charAt(int index) {
                if (index < 1) {
                    return s1;
                }
                if (index < this.l2) {
                    return s2.charAt(index - 1);
                }
                return s3.charAt(index - this.l2);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return new StringBuilder(this.length()).append(s1).append(s2).append(s3).subSequence(start, end);
            }

            @Override
            public String toString() {
                return new StringBuilder(this.length()).append(s1).append(s2).append(s3).toString();
            }
        };
    }

    public static CharSequence concatenate(final char s1, final char s2, final CharSequence s3) {
        return new CharSequence(){
            private final int l1 = 1;
            private final int l2 = 2;
            private final int l3 = 2 + s3.length();

            @Override
            public int length() {
                return this.l3;
            }

            @Override
            public char charAt(int index) {
                if (index < 1) {
                    return s1;
                }
                if (index < 2) {
                    return s2;
                }
                return s3.charAt(index - 2);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return new StringBuilder(this.length()).append(s1).append(s2).append(s3).subSequence(start, end);
            }

            @Override
            public String toString() {
                return new StringBuilder(this.length()).append(s1).append(s2).append(s3).toString();
            }
        };
    }

    public static CharSequence concatenate(final CharSequence s1, final CharSequence s2, final CharSequence s3) {
        return new CharSequence(){
            private final int l1;
            private final int l2;
            private final int l3;
            {
                this.l1 = s1.length();
                this.l2 = this.l1 + s2.length();
                this.l3 = this.l2 + s3.length();
            }

            @Override
            public int length() {
                return this.l3;
            }

            @Override
            public char charAt(int index) {
                if (index < this.l1) {
                    return s1.charAt(index);
                }
                if (index < this.l2) {
                    return s2.charAt(index - this.l1);
                }
                return s3.charAt(index - this.l2);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return new StringBuilder(this.length()).append(s1).append(s2).append(s3).subSequence(start, end);
            }

            @Override
            public String toString() {
                return new StringBuilder(this.length()).append(s1).append(s2).append(s3).toString();
            }
        };
    }

    public static CharSequence concatenate(final CharSequence s1, final CharSequence s2, final CharSequence s3, final CharSequence s4) {
        return new CharSequence(){
            private final int l1;
            private final int l2;
            private final int l3;
            private final int l4;
            {
                this.l1 = s1.length();
                this.l2 = this.l1 + s2.length();
                this.l3 = this.l2 + s3.length();
                this.l4 = this.l3 + s4.length();
            }

            @Override
            public int length() {
                return this.l4;
            }

            @Override
            public char charAt(int index) {
                if (index < this.l1) {
                    return s1.charAt(index);
                }
                if (index < this.l2) {
                    return s2.charAt(index - this.l1);
                }
                if (index < this.l3) {
                    return s3.charAt(index - this.l2);
                }
                return s4.charAt(index - this.l3);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return new StringBuilder(this.length()).append(s1).append(s2).append(s3).append(s4).subSequence(start, end);
            }

            @Override
            public String toString() {
                return new StringBuilder(this.length()).append(s1).append(s2).append(s3).append(s4).toString();
            }
        };
    }

    private static class CharSequenceComparatorIgnoreCase
    implements Comparator<CharSequence> {
        private CharSequenceComparatorIgnoreCase() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            int n1 = o1.length();
            int n2 = o2.length();
            int i1 = 0;
            for (int i2 = 0; i1 < n1 && i2 < n2; ++i1, ++i2) {
                char c2;
                char c1 = o1.charAt(i1);
                if (c1 == (c2 = o2.charAt(i2)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    }
}

