/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.filters.ElfDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.utils.filters.ElfStaticLibraryFileFilter;
import org.netbeans.modules.cnd.utils.filters.MacOSXDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.utils.filters.PeDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.utils.filters.PeStaticLibraryFileFilter;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AllLibraryFileFilter
extends FileFilterFactory.AbstractFileAndFileObjectFilter {
    private static AllLibraryFileFilter instance = null;
    private final List<FileFilterFactory.AbstractFileAndFileObjectFilter> filters = new ArrayList<FileFilterFactory.AbstractFileAndFileObjectFilter>();

    public static AllLibraryFileFilter getInstance() {
        if (instance == null) {
            instance = new AllLibraryFileFilter();
        }
        return instance;
    }

    private AllLibraryFileFilter() {
        this.filters.add(ElfStaticLibraryFileFilter.getInstance());
        if (Utilities.isWindows()) {
            this.filters.add(PeDynamicLibraryFileFilter.getInstance());
            this.filters.add(PeStaticLibraryFileFilter.getInstance());
        } else if (Utilities.getOperatingSystem() == 4096) {
            this.filters.add(MacOSXDynamicLibraryFileFilter.getInstance());
        } else {
            this.filters.add(ElfDynamicLibraryFileFilter.getInstance());
        }
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(AllLibraryFileFilter.class, (String)"ALL_LIB_FILTER");
    }

    @Override
    public boolean accept(File f) {
        for (FileFilterFactory.AbstractFileAndFileObjectFilter filter : this.filters) {
            if (!filter.accept(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(FileObject fileObject) {
        for (FileFilterFactory.AbstractFileAndFileObjectFilter filter : this.filters) {
            if (!filter.accept(fileObject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSuffixesAsString() {
        return "";
    }
}

