/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import org.netbeans.modules.cnd.utils.FileAndFileObjectFilter;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ShellFileFilter
extends FileAndFileObjectFilter {
    private static ShellFileFilter instance = null;

    public static ShellFileFilter getInstance() {
        if (instance == null) {
            instance = new ShellFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(ShellFileFilter.class, (String)"FILECHOOSER_SHELL_FILEFILTER");
    }

    @Override
    protected boolean mimeAccept(File f) {
        return this.mimeAccept(CndFileUtils.toFileObject(f));
    }

    @Override
    protected boolean mimeAccept(FileObject fo) {
        if (fo != null) {
            if (fo.isValid()) {
                return "text/sh".equals(FileUtil.getMIMEType((FileObject)fo, (String[])new String[]{"text/sh"}));
            }
            return MIMEExtensions.isRegistered("text/sh", FileUtil.getExtension((String)fo.getNameExt()));
        }
        return false;
    }

    @Override
    protected String[] getSuffixes() {
        return new String[0];
    }
}

